/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_internal_h_
#define _gm_internal_h_

#ifdef	__cplusplus
extern "C"
{
#if 0
}				/* indent hack */
#endif
#endif

/****************************************************************
 * Headers
 ****************************************************************/


#ifdef __GNUC__
#if (__GNUC__==2) && (__GNUC_MINOR__==96)
#if (defined(__ia64__) && defined(__linux__))
    /* ia64 linux must use gcc-2.96 at a minumum */
#else
#warning gcc-2.96 can NOT properly compile GM code.
#warning Please use an earlier version of gcc.
#warning Here is one that works:
#warning      gcc version egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)
#warning For IA32 RedHat7.0 you can use "kgcc"
#error   Bad GCC version
#endif
#endif
#endif


/************
 * Myricom debugging HACKS
 ************/

/* gm_config.h set the configuration options for this architecture.
   This must be included before gm.h so it can override the
   auto-detect definitions there when this file is included by the
   MCP. */

#include "gm_config.h"

/* defines only the GM types used in the GM API. */

#include "gm.h"

/* gm_types.h defines gm_dp_t &c used in GM internals.  Depends on
   the types in gm.h */

#include "gm_types.h"

/* Include the driver types so that kernel code can simply include
   this file to get the entire GM internal driver software interface. */

#define GM_OPENER_STRING_MAX_LEN 64
#if GM_KERNEL
#  include "gm_arch.h"		/* defines internal driver SPI */
#  include "gm_impl.h"          /* defines port_state types    */
#endif

/* gm_lanai.h defines the layout of the LANai for the driver and any
   privileged user level program that can access parts of it.  For
   example, the libgm and the gm_board_info application need to know
   the layout of the eeprom. */

#include "gm_lanai.h"		/* defines layout of the LANai */

/* Define the details of user<->kernel I/O for the user-level and
   kernel-level code that performs the I/O. */

#if !GM_BUILDING_FIRMWARE
#include "gm_io.h"
#endif

#include "gm_enable_ethernet.h"
#include "gm_stbar.h"

/* read back the last int in the structure pointed to by ptr to flush
   the write to the LANai. */

#if GM_NEED_READBACK_TO_FLUSH_WRITES
#define GM_READBACK_TO_FLUSH_WRITES(port,ptr) do {	       		\
  (port)->trash = ((int *)(ptr+1))[-1];					\
} while (0)
#else
#define GM_READBACK_TO_FLUSH_WRITES(port,ptr)
#endif

#define GM_FLUSH_SEND_EVENT(port,hst) do {				\
  GM_STBAR ();								\
  GM_READBACK_TO_FLUSH_WRITES (port, hst);				\
} while (0)
  
#define GM_SIMULATE_SIMULATE()

/****************************************************************
 * Constants
 ****************************************************************/

enum {
  /* max length of a string returned by _gm_get_firmware_string().
     Actual firware strings may be longer. */
  GM_MAX_FIRMWARE_STRING_LEN = 128
};

enum {
  /* max length of a string returned by _gm_get_kernel_build_id().
     Actual strings may be longer. */
  GM_MAX_KERNEL_BUILD_ID_LEN = 128
};

#define GM_SIZEOF_SIZE_T GM_SIZEOF_VOID_P
GM_TOP_LEVEL_ASSERT (sizeof (gm_size_t) == GM_SIZEOF_SIZE_T);

#define GM_STATIC_CAST(x,y) (x)(y)

/**********************************************************************
 * Typdefs
 **********************************************************************/

/****
 * Ports
 ****/

struct gm_send_queue_slot_token
{
  struct gm_send_queue_slot_token *next;
  gm_send_completion_callback_t sent_handler;
  void *sent_handler_context;
  void *pad;
};

/* Allow the use of the symbol "lanai" when the lanai compiler is being
   used. */

#ifdef lanai
#undef lanai
#define lanai lanai
#endif

typedef struct gm_port
{
  /* The version of the GM API supported by this port. */
  enum gm_api_version api_version;
  /* a field the user may use for any purpose.  Not touched by GM. */
  void *context;

#if GM_KERNEL
  struct gm_port_state *kernel_port_state;
#endif /* ethernet GM_KERNEL */
 
  unsigned this_node_id;
  unsigned max_node_id;
  int sleeping;

  /* Pointer to mapped lanai SRAM, including lanai-resident queues */

  struct gm_port_unprotected_lanai_side *lanai;

  /********************
  ** Host->LANai queues (in LANai SRAM)
  ********************/

  /* send queue slot tokens */

  struct gm_send_queue_slot_token send_queue_slot_token[GM_NUM_SEND_QUEUE_SLOTS];
  struct gm_send_queue_slot_token *first_free_send_queue_slot_token;
  struct gm_send_queue_slot_token *last_free_send_queue_slot_token;
				/* for forging GM_SENT_EVENTS */
  gm_up_n_t sent_list[GM_NUM_SEND_QUEUE_SLOTS+1];
  gm_up_n_t *sent_list_slot;
  
  /* Send token queue. */
  volatile gm_u32_t send_token_cnt[GM_NUM_PRIORITIES];
  volatile struct gm_send_queue_slot *send_queue_start;
  volatile struct gm_send_queue_slot *send_queue_limit;
  
  /* Recv token queue */
  volatile struct gm_host_recv_token *recv_token_queue_start;
  volatile struct gm_host_recv_token *recv_token_queue_slot;
  volatile struct gm_host_recv_token *recv_token_queue_limit;

  /********************
  ** LANai->host queues (in host memory)
  ********************/

  /* Recv message queue. */
  volatile struct gm_recv_queue_slot *recv_queue_start;
  volatile struct gm_recv_queue_slot *recv_queue_slot;
  volatile struct gm_recv_queue_slot *recv_queue_limit;


  /********************
   * Alarm stuff
   *******************/
  
  gm_u64_t lanai_alarm_time;
  enum lanai_alarm_state {LANAI_ALARM_IDLE,
			  LANAI_ALARM_SET,
			  LANAI_ALARM_FLUSHING} lanai_alarm_state;
	     
  /********************
   * Other state
   ********************/

  unsigned num_zones;
  struct gm_zone *dma_zone[32];
  void *dma_zone_base[32];
  gm_size_t dma_zone_len[32];
  gm_size_t alloced_dma_mem_len;

  unsigned unit;
  unsigned id;
  unsigned max_used_id;

  gm_recv_token_t _recv_tokens[GM_NUM_RECV_TOKENS + 1];
  struct gm_lanai_globals *lanai_globals;
  union gm_lanai_special_registers *lanai_special_regs;
#ifdef WIN32
  HANDLE fd;
#else
  int fd;
#endif
  struct gm_mapping_specs *mappings;
  int sleep_pending;
  volatile int trash;
  char unique_board_id[6];

  /* Alarm state */

  gm_alarm_t *first_alarm;

  /* pointer to the lanai-side real-time clock
     (the first page of LANai SRAM) */

  gm_u64_n_t *RTC;

  /* ethernet state */

#if GM_ENABLE_ETHERNET
  struct
  {
    gm_ethernet_recv_token_t *recv_token_queue_start;
    gm_ethernet_recv_token_t *recv_token_queue_slot;
    gm_ethernet_recv_token_t *recv_token_queue_limit;
  }
  ethernet;
#endif

  /* _gm_get_kernel_build_id() state */

  char *kernel_build_id;

  struct gm_port *next_open_port;
  
  /****************
   * debugging state
   ****************/

  unsigned send_count;
}
gm_port_t;

/****************************************************************
 * Enumerations
 ****************************************************************/

enum gm_mapping_mode
{
  GM_MAP_READ = 1,
  GM_MAP_WRITE = 2,
  GM_MAP_RDWR = 3
};

/****************************************************************
 * Globals
 ****************************************************************/

GM_ENTRY_POINT extern struct gm_mutex *_gm_global_mutex;
GM_ENTRY_POINT extern unsigned long _gm_initialized;
GM_ENTRY_POINT extern const char *_gm_build_id;
GM_ENTRY_POINT extern const char *_gm_version;
GM_ENTRY_POINT extern const char *_gm_version_plus_space;
GM_ENTRY_POINT extern const gm_u32_t gm_crc_table[];

/****************************************************************
 * External function declarations
 ****************************************************************/

/****************
 * Internal functions that you should not assume you know how to use
 * unless you wrote them yourself and have reviews the implications of
 * using the function.
 ****************/

gm_u16_t __gm_ip_checksum (void *_message, unsigned long _len);
void __gm_stbar (void);

/* Flag to indicate if we are currently executing in the interrupt
   handler routine. */

#if GM_KERNEL
extern int gm_in_intr;
#else
#define gm_in_intr 0
#endif

/****************
 * Simple internal functions
 ****************/

void _gm_finalize_all (void);
char *_gm_ioctl_cmd_name (unsigned int cmd);
gm_u16_t _gm_ip_checksum (void *message, unsigned long len);
gm_status_t _gm_ip_checksum_verify (void *message, unsigned long len,
				    gm_u16_t cks);
void *_gm_malloc (unsigned long len);
gm_status_t _gm_mmap (struct gm_port *p, gm_offset_t offset,
		      gm_size_t len, int flags, void **result);
gm_status_t _gm_munmap (struct gm_port *p, void *ptr, unsigned long len);
gm_port_t *_gm_open_ports_remove (struct gm_port *port);
void _gm_open_ports_close_all (void);
void _gm_open_ports_insert (struct gm_port *port);
int _gm_open_ports_test(void);
void _gm_perform_on_exit_callbacks (gm_status_t);
void _gm_provide_ethernet_scatter_list (gm_port_t * p,
					gm_u32_t segment_cnt,
					gm_ethernet_segment_descriptor_t
					segment[]);
char *_gm_recv_event_name (enum gm_recv_event_type t);
void _gm_request_sleep (struct gm_port * p);
void _gm_sent (struct gm_port *p, void *context, gm_status_t status);
gm_status_t _gm_sleep (struct gm_port *p);
gm_status_t _gm_unknown (gm_port_t *port, gm_recv_event_t *e);

int gm_fork(void);
char *gm_get_buf_status_name (enum gm_buf_status s);
void gm_safer_bzero (void *ptr, int len);

/****************
 * unsupported exported functions
 ****************/

GM_ENTRY_POINT gm_status_t _gm_clear_all_routes (struct gm_port *p);
GM_ENTRY_POINT gm_status_t _gm_cop_wakeup (struct gm_port *port);
GM_ENTRY_POINT gm_status_t _gm_cop_end (struct gm_port *port);
GM_ENTRY_POINT gm_status_t _gm_cop_send (struct gm_port *port, int d);
GM_ENTRY_POINT gm_status_t _gm_cop_receive (struct gm_port *port, int *d);
GM_ENTRY_POINT gm_status_t _gm_user_write_lanai_register (struct gm_port *port, gm_u32_t offset, gm_u32_t value);
GM_ENTRY_POINT void	   _gm_dump_receive_queue (gm_port_t *port);
GM_ENTRY_POINT gm_status_t _gm_enable_raw_receives (struct gm_port *p);
GM_ENTRY_POINT gm_status_t _gm_finish_mmap (gm_port_t *port, gm_offset_t off,
					    gm_size_t len, gm_up_t uvma);
GM_ENTRY_POINT gm_status_t _gm_get_eeprom (struct gm_port *p,
					   gm_myrinet_eeprom_t *eeprom);
GM_ENTRY_POINT gm_status_t _gm_get_firmware_string
(gm_port_t *port, gm_lp_t lanai_ptr, char str[GM_MAX_FIRMWARE_STRING_LEN], gm_u32_t *len);
GM_ENTRY_POINT gm_status_t _gm_get_globals (struct gm_port *port, gm_u8_t *ptr,
					    gm_size_t length);
GM_ENTRY_POINT gm_status_t _gm_get_globals_by_request (gm_port_t * port,
						       gm_u8_t *ptr,
						       unsigned int off,
						       gm_size_t length);
GM_ENTRY_POINT gm_status_t _gm_get_page_hash_cache_size (gm_port_t *port,
				unsigned int *cache_size);
GM_ENTRY_POINT char *      _gm_get_kernel_build_id (struct gm_port *p);
GM_ENTRY_POINT gm_status_t _gm_get_mapping_specs (struct gm_port *p,
						  struct gm_mapping_specs *ms);
GM_ENTRY_POINT gm_status_t _gm_get_opener_pids (struct gm_port *p,
						gm_pid_t *pids);
GM_ENTRY_POINT gm_status_t _gm_get_page_len (unsigned long *result);
GM_ENTRY_POINT gm_status_t _gm_handle_alarm (struct gm_port *port);
GM_ENTRY_POINT gm_status_t _gm_handle_flushed_alarm (struct gm_port *p);
GM_ENTRY_POINT gm_status_t _gm_mapper_open (struct gm_port **p,
					    unsigned int unit,
					    enum gm_api_version gm_version);
GM_ENTRY_POINT unsigned int _gm_max_used_node_id (gm_port_t *port);
GM_ENTRY_POINT void        _gm_nt_foo (void);
GM_ENTRY_POINT gm_status_t _gm_open_common (gm_port_t **port, unsigned unit,
					    unsigned port_id,
					    const char *client_type,
					    enum gm_api_version api_version);
GM_ENTRY_POINT void        _gm_preserve_lanai_globals(gm_port_t * p);
GM_ENTRY_POINT void        _gm_provide_raw_receive_buffer (struct gm_port *p,
							   void *ptr);
GM_ENTRY_POINT void        _gm_raw_send (struct gm_port *p, void *ptr,
					 unsigned int len,
					 unsigned int route_len);
GM_ENTRY_POINT void        _gm_raw_send_with_callback
(struct gm_port *p, void *ptr, unsigned int len, unsigned int route_len,
 gm_send_completion_callback_t cb, void *context);
GM_ENTRY_POINT gm_status_t _gm_set_host_name (struct gm_port *p,
					      unsigned int node_id,
					      char *name);
GM_ENTRY_POINT gm_status_t _gm_set_node_type (struct gm_port *p,
					      int node_type);
GM_ENTRY_POINT gm_status_t _gm_set_mapper_level (struct gm_port *p, int level);
GM_ENTRY_POINT gm_status_t _gm_set_node_id (struct gm_port *p,
					    unsigned int node_id);
GM_ENTRY_POINT gm_status_t _gm_set_opener_pid (struct gm_port *p,
					       gm_pid_t pid);
GM_ENTRY_POINT gm_status_t _gm_set_physical_pages (struct gm_port *port);
GM_ENTRY_POINT gm_status_t _gm_set_port_num (struct gm_port *p,
					     unsigned long _id);
GM_ENTRY_POINT gm_status_t _gm_set_route (struct gm_port *p,
					  unsigned int node_id,
					  unsigned int len, char *route);
GM_ENTRY_POINT gm_status_t _gm_set_unique_id (struct gm_port *p,
					      unsigned int node_id,
					      char id[6]);
GM_ENTRY_POINT void        _gm_unknown_debug_buffers (gm_port_t * p,
						      gm_recv_event_t * e);
GM_ENTRY_POINT gm_status_t _gm_user_ioctl (struct gm_port *p, unsigned int cmd,
					   void *buf, gm_size_t bufsize);


/* Needed by gm_deregister.c from gm_register.c */

void _gm_register_memory_mutex_enter (void);
void _gm_register_memory_mutex_exit (void);

#ifdef __cplusplus
#if 0
{				/* indent hack */
#endif
}
#endif


#endif /* ifndef _gm_internal_h_ */
