/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1998 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gm_debug_lanai_dma_h_
#define _gm_debug_lanai_dma_h_

/* Set this to use Loic's bitmap-based DMA addr checking to prevent
   DMAs to pages not registered for GM DMA. */
#define GM_DEBUG_LANAI_DMA 0

/* Set this to print details of all DMA page registrations and all
   DMAs as they start. */
#define GM_TRACE_LANAI_DMA 0

/****************************************************************/

#include "gm_simple_types.h"
#include "gm_bitmap.h"

/* This is used to size the dma_pages_bitmap, which is used iff
   GM_DEBUG_LANAI_DMA is set, so set this to 1 to minimize memory
   wastage when this GM_DEBUG_LANAI_DMA feature is not used.

   (1<<21) is large enough to check the bottom 33 bits on all archs. */

#if !loic
#define GM_MAX_HOST_DMA_PAGES	(GM_DEBUG_LANAI_DMA ? (1<<21) : 1)
#define GM_PCI_WIN_START 0
#else
#define GM_MAX_HOST_DMA_PAGES	(GM_DEBUG_LANAI_DMA ? (1<<16) : 1)
#ifdef GM_CPU_alpha
#define GM_PCI_WIN_START (0x40000000)
#else
#define GM_PCI_WIN_START 0
#endif
#endif

typedef GM_BITMAP_DECL(gm_dma_page_bitmap_t, GM_MAX_HOST_DMA_PAGES);

gm_status_t __gm_noticed_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp);
void __gm_notice_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp);
void __gm_forget_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp);

static gm_inline gm_status_t
gm_noticed_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  gm_assert (bitmap);
  if (GM_DEBUG_LANAI_DMA)
    {
      return __gm_noticed_dma_addr (bitmap, dp - GM_PCI_WIN_START);
    }
  else
    {
      return GM_SUCCESS;
    }
}

static gm_inline void
_gm_notice_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  if (GM_DEBUG_LANAI_DMA)
    {
      __gm_notice_dma_addr (bitmap, dp - GM_PCI_WIN_START);
    }
}

#define gm_notice_dma_addr(bitmap, dp) do {	\
  gm_assert (bitmap);				\
  _gm_notice_dma_addr (bitmap, dp);		\
} while (0)

static gm_inline void
_gm_forget_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  if (GM_DEBUG_LANAI_DMA)
    {
      __gm_forget_dma_addr (bitmap, dp - GM_PCI_WIN_START);
    }
}

#define gm_forget_dma_addr(bitmap, dp) do {	\
  gm_assert (bitmap);				\
  _gm_forget_dma_addr (bitmap, dp);		\
} while (0)

#endif /* _gm_debug_lanai_dma_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
