/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* this file includes commonly used preprocessor hacks. */

#ifndef _gm_cpp_h_
#define _gm_cpp_h_

#define GM_STRINGIFY(param) #param
#define GM_SUB_N_STRINGIFY(param) GM_STRINGIFY (param)

#define GM_CAT(a,b) a ## b
#define GM_CAT3(a,b,c) a ## b ## c
#define GM_CAT4(a,b,c,d) a ## b ## c ## d

#define GM_SUB_N_CAT(a,b) GM_CAT(a,b)
#define GM_SUB_N_CAT3(a,b,c) GM_CAT3(a,b,c)
#define GM_SUB_N_CAT4(a,b,c,d) GM_CAT4(a,b,c,d)

/* __GM_LINE__ : The current line being compile AS A STRING.  Use
   the ANSI standard "__LINE__" macro for the line as an int. */

#define __GM_LINE__ GM_SUB_N_STRINGIFY (__LINE__)

/* __GM_FUNCTION__ : name of the current function being compiled, if
   this information is available to the preprocessor.  Otherwise,
   report the file and line number.  Like the GCC "__FUNCTION__" macro,
   only it works with all compilers. */

#define __GM_FUNCTION__ __GM_FUNCTION_DEFAULT__

/* __GM_FUNCTION_DEFAULT__ : This is the "real" definition of
   __GM_FUNCTION__, allowing users who override __GM_FUNCTION__
   manually reset it to its default after they are done overriding
   it. */

#if defined __GNUC__
#if __GNUC__ > 2							\
    || (__GNUC__ == 2							\
	&& __GNUC_MINOR__ >= (defined __cplusplus ? 6 : 4))
#define __GM_FUNCTION_DEFAULT__	__PRETTY_FUNCTION__
#else /* __GNUC__ __PRETTY_FUNCTION__ is broken */
#define __GM_FUNCTION_DEFAULT__ __FUNCTION__
#endif /* __GNUC__ __PRETTY_FUNCTION__ is broken */
#elif defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#define __GM_FUNCTION_DEFAULT__ __func__
#else
#define __GM_FUNCTION_DEFAULT__ "???"
#endif

/* __GM_WHERE__ : the current compilation position, with as much
   detail as is available, in a format compatible with emacs
   compilation mode for automatic editor jumping to the line. */

#define __GM_WHERE__ __FILE__ ":" __GM_LINE__ ":" __GM_FUNCTION__

#ifdef __GNUC__
#define GM_TOP_LEVEL_ASSERT(cond)					\
extern gm_u8_t __GM_TOP_LEVEL_ASSERT[(cond) ? 1 : -1]
#else
#define GM_TOP_LEVEL_ASSERT(cond)
#endif

/****************************************************************
 * #warning support
 ****************************************************************/

/* Determine if we should use #error's instead of #warnings.  For
   example, #warning generates an error on the SGI Mips Pro compiler,
   but #error just generates a warning.  (Crazy, Huh?) */
#if defined sgi && defined _COMPILER_VERSION	/* SGI Mips Pro compiler */
#define GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS 1
#else
#define GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS 0
#endif

#if __GNUC__
#define GM_CPP_WARNINGS_BEHAVE 1
#else
#define GM_CPP_WARNINGS_BEHAVE 0
#endif

#endif /* _gm_cpp_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
