/*                                  tab:2

 * lam_barrier.c - Active Messages barrier
 *
 * "Copyright (c) 1994 by Lok Tin Liu and The Regents of the University 
 * of California.  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "am.h"

static int AM_myproc;
static int AM_procs;

static int up_buf[2];
static int down_buf;

int 
am_barrier_init()
{
	AM_myproc = am_my_proc();
	AM_procs = am_procs();
	up_buf[0] = up_buf[1] = down_buf = 0;
	return 0;
}

void 
am_incr_handler(vnn_t node, void *val)
{
	(*((int *) val))++;
}

void 
am_barrier_up()
{
	int parent = (AM_myproc - 1) / 2;
	int odd_child = 2 * AM_myproc + 1;
	int even_child = 2 * AM_myproc + 2;
	int parity = AM_myproc & 1;

	if (AM_myproc == 0) {
		if (AM_procs != 1)
			if (AM_procs == 2) {
				while (up_buf[1] == 0)
					am_poll();

			}
			else {
				while (up_buf[0] == 0 || up_buf[1] == 0)
					am_poll();
			}
	}
	else {
		if (odd_child >= AM_procs) {
			am_request_4(parent, am_incr_handler, (int) &up_buf[parity], 0, 0, 0);
		}
		else if (even_child >= AM_procs) {
			while (up_buf[1] == 0)
				am_poll();
			am_request_4(parent, am_incr_handler, (int) &up_buf[parity], 0, 0, 0);
		}
		else {
			while (up_buf[0] == 0 || up_buf[1] == 0)
				am_poll();
			am_request_4(parent, am_incr_handler, (int) &up_buf[parity], 0, 0, 0);
		}
	}
	up_buf[0] = up_buf[1] = 0;
}

void 
am_barrier_down()
{
	int left = 2 * AM_myproc + 1;
	int right = 2 * AM_myproc + 2;
	if (AM_myproc != 0) {
		while (down_buf == 0)
			am_poll();
	}
	if (left < AM_procs)
		am_request_4(left, am_incr_handler, (int) &down_buf, 0, 0, 0);
	if (right < AM_procs)
		am_request_4(right, am_incr_handler, (int) &down_buf, 0, 0, 0);
	down_buf = 0;
}

void 
am_barrier()
{
	am_barrier_up();
	am_barrier_down();
}


void 
am_wait(volatile int *flag, int value)
{
	do {
		am_poll();
	} while (*flag < value);

	*flag -= value;
}

void 
am_poll_wait(volatile int *flag, int value)
{

	while (*flag < value) {
		am_poll();
	}

	*flag -= value;
}
