/*                                                                      tab:8
 *
 * "Copyright (c) 1994 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Author:              Richard P. Martin
 * Version: 		1
 * Creation Date:       Thu Oct 28 10:47:28 PDT 1993
 * Filename:            ping.c ping test for HPAM library
 * History:
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include "am.h"

extern int errno;

char *buf1;
char *buf2;

static void poof(int src, volatile int *flag)
{
  (*flag)++; 
}
     
static void pong(int src, void *rva, int nbytes, volatile int *return_flag)
{
  am_reply_1(src, poof, (int)return_flag); 
}

void main (int argc, char *argv[])
{
  int i;
  int iterations;
  int me,to;
  static volatile int go;
  static volatile int done1;
  struct timeval begin,end,lapsed;

  double total_time,rtt;

  am_enable();

  buf1 = am_dma_calloc (1, 4096);
  gm_always_assert (buf1);
  buf2 = am_dma_calloc (1, 4096);
  gm_always_assert (buf2);
  
  me = am_my_proc();
  to=0;

  if (argc > 1) {
    to = atoi(argv[1]);
  }

  iterations = 5000;

  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);

    printf(" Timing full round trip time \n");
    gettimeofday(&begin, 0);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_store(to, buf1, buf2, 4096, pong, &done1);  
      while (done1 ==0) 
	am_poll(); 
    }    
    gettimeofday(&end, 0);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1000000;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1000000.00+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("average full rtt = %.3f usec \n",rtt);

    am_request_1(to,poof,(int)(&go));
  }
  else {
    while(go < 1) 
      am_poll();
  }
  printf("done!\n");
  fflush(stdout);
  am_disable();
}





