#include "vxWorks.h"
#include "wdLib.h"
#include "stdlib.h"
#include "taskLib.h"
#include "logLib.h"
#include "intLib.h"
#include "netLib.h"
#include "stdio.h"
#include "stdlib.h"
#include "sysLib.h"
#include "iv.h"
#include "memLib.h"
#include "semLib.h"
#include "cacheLib.h"
#include "sys/ioctl.h"
#include "etherLib.h"
#include "net/mbuf.h"
#include "net/protosw.h"
#include "sys/socket.h"
#include "errno.h"
#include "net/if.h"
#include "net/route.h"
#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/in_var.h"
#include "netinet/ip.h"
#include "netinet/if_ether.h"
#include "net/if_subr.h"
#include "m2Lib.h"
#include "etherMultiLib.h"
#include "end.h"
#include "netBufLib.h"
#include "muxLib.h"
#include "endLib.h"


#include "geLink.h"
#include "ge.h"
#include "insist.h"

static struct gm_port loopPort;
static gm_recv_event_t eventPool [GM_NUM_SEND_TOKENS + GM_NUM_ETHERNET_RECV_TOKENS];
static gm_recv_event_t noEvent;

static GeQueue freeSends;
static GeQueue freeReceives;
static GeQueue receiveQueue;
static GeQueue eventQueue;
static int loopInterruptsEnabled;
static void (*loopInterruptCallback) (void*);
static void*loopInterruptContext;
static char loopAddress [6] = {1,0,0,0,0,0};
static int loopOpened = 0;

static void loopInterrupt ()
{
  if (loopInterruptsEnabled && loopInterruptCallback)
    loopInterruptCallback (loopInterruptContext);
}

static void loopAddInterrupt ()
{
  int r;
  r = netJobAdd ((FUNCPTR) loopInterrupt, 0, 0, 0, 0, 0);
  insist (r);
  
  exception: return;
  
}

static gm_status_t loop_open (struct gm_port **p, unsigned unit,
			   unsigned port, char *port_name,
			   enum gm_api_version version)
{
  int r, i;
  
  insist (p);
  insist (port == GM_ETHERNET_PORT_ID);
  insist (!loopOpened);
  
  loopOpened = 1;
  *p = &loopPort;
  noEvent.recv.type = GM_NO_RECV_EVENT;
  
  for (i = 0; i < GM_NUM_SEND_TOKENS; i++)
  {
    eventPool [i].recv.type = GM_ETHERNET_SENT_EVENT;
    r = gePut (&freeSends, &eventPool [i]);
    insist (r);
  }
  
  for (;i < GM_NUM_SEND_TOKENS + GM_NUM_ETHERNET_RECV_TOKENS; i++)
  {
    eventPool [i].recv.type = GM_ETHERNET_RECV_EVENT;
    r = gePut (&freeReceives, &eventPool [i]);
    insist (r);
  }
  
  return GM_SUCCESS;
  exception: return GM_SUCCESS + 1;
}

static union gm_recv_event* loop_receive (struct gm_port *p)
{
  int r;
  gm_recv_event_t*event;
  
  insist (loopOpened);
  insist (p == &loopPort);

  event = (gm_recv_event_t*) geGet (&eventQueue);

  if (event)
  {
    switch (event->recv.type)
    {
      case GM_ETHERNET_SENT_EVENT:
	r = gePut (&freeSends, event);
	insist (r);
	break;
      case GM_ETHERNET_RECV_EVENT:
	r = gePut (&freeReceives, event);
	insist (r);
	break;
      default:
	insist (0);
    }
    return event;
  }
  
  exception: return &noEvent;
}

static void loop_unknown (struct gm_port * p, union gm_recv_event *e)
{
  insist (loopOpened);
  insist (p == &loopPort);
  insist (0);
  exception: return;
}

static void loop_ethernet_send (struct gm_port *p,
			     gm_u32_t segment_count,
			     gm_ethernet_segment_descriptor_t segment[],
			     gm_u8_t *ethernet_addr,
			     int prepend_type)
{
  int r;
  gm_recv_event_t*e;
  
  insist (loopOpened);
  insist (p == &loopPort);
  insist (segment_count == 1);

  e = geGet (&freeSends);
  insist (e);

  e->recv.type = GM_ETHERNET_SENT_EVENT;
  r = gePut (&eventQueue, e);
  insist (r);
  loopAddInterrupt ();
  
  e = geGet (&receiveQueue);
  insist (e);
  
  e->recv.type = GM_ETHERNET_RECV_EVENT;
  r = gePut (&eventQueue, e);
  insist (r);
  loopAddInterrupt ();

  exception: return;
}

static void loop_broadcast (struct gm_port *p,
			 gm_u32_t segment_cnt,
			 gm_ethernet_segment_descriptor_t segment[],
			 int prepend_type)
{
  insist (loopOpened);
  insist (p == &loopPort);

  loop_ethernet_send (p, segment_cnt, segment, 0, prepend_type);
  exception: return;
}

static void loop_provide_ethernet_scatter_list (struct gm_port *p,
					     gm_u32_t segment_cnt,
					     gm_ethernet_segment_descriptor_t
					     segment[])
{
  int r;
  
  insist (loopOpened);
  insist (p == &loopPort);

  insist (segment_cnt == 1);
  insist (segment);

  r = gePut (&receiveQueue, geGet (&freeReceives));
  insist (r);
  exception: return;
}

static gm_status_t loop_get_unique_board_id (struct gm_port * p, char unique [6])
{
  insist (loopOpened);
  insist (p == &loopPort);

  bcopy (loopAddress, unique, 6);
  
  return GM_SUCCESS;
  exception: return GM_SUCCESS + 1;
}

static void loop_close (struct gm_port *p)
{
  insist (loopOpened);
  insist (p == &loopPort);

  loopOpened = 0;
  bzero ((char*) &freeReceives, sizeof (GeQueue));
  bzero ((char*) &freeSends, sizeof (GeQueue));
  bzero ((char*) &receiveQueue, sizeof (GeQueue));
  bzero ((char*) &eventQueue, sizeof (GeQueue));

  loopInterruptCallback = 0;
  loopInterruptContext = 0;

  exception: return;
}

static void loop_enableInterrupts  (struct gm_port *p)
{
  insist (loopOpened);
  insist (p == &loopPort);
  
  loopInterruptsEnabled = 1;
  exception: return;
}

static void loop_disableInterrupts (struct gm_port *p)
{
  insist (loopOpened);
  insist (p == &loopPort);

  loopInterruptsEnabled = 0;
  exception: return;
}

static void loop_set_intr_callback (struct gm_port *p,
				 void (*callback)(void *),
				 void *context)
{
  insist (loopOpened);
  insist (p == &loopPort);

  loopInterruptCallback = callback;
  loopInterruptContext = context;
  exception: return;
}

int geGetLoopLink (GeDevice*device)
{

  insist (device);
  
  device->link.version = 0;
  device->link.gm_open = loop_open;
  device->link.gm_receive = loop_receive;
  device->link.gm_unknown = loop_unknown;
  device->link.gm_ethernet_send = loop_ethernet_send;
  device->link.gm_ethernet_broadcast = loop_broadcast;
  device->link.gm_provide_ethernet_scatter_list = loop_provide_ethernet_scatter_list;
  device->link.gm_get_unique_board_id = loop_get_unique_board_id;
  device->link.gm_close = loop_close;
  device->link.enableInterrupts = loop_enableInterrupts;
  device->link.disableInterrupts = loop_disableInterrupts;
  device->link.gm_ethernet_set_intr_callback = loop_set_intr_callback;

  return 1;
  exception: return 0;
}




