#include "vxWorks.h"
#include "wdLib.h"
#include "stdlib.h"
#include "taskLib.h"
#include "logLib.h"
#include "intLib.h"
#include "netLib.h"
#include "stdio.h"
#include "stdlib.h"
#include "sysLib.h"
#include "iv.h"
#include "memLib.h"
#include "semLib.h"
#include "cacheLib.h"
#include "sys/ioctl.h"
#include "etherLib.h"
#include "net/mbuf.h"
#include "net/protosw.h"
#include "sys/socket.h"
#include "errno.h"
#include "net/if.h"
#include "net/route.h"
#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/in_var.h"
#include "netinet/ip.h"
#include "netinet/if_ether.h"
#include "net/if_subr.h"
#include "m2Lib.h"
#include "etherMultiLib.h"
#include "end.h"
#include "netBufLib.h"
#include "muxLib.h"
#include "endLib.h"

#define INSIST 1
#include "gm_ether.h"
#include "ge.h"
#include "insist.h"
#include "gm_debug.h"
#include "gm_bsp_support.h"

STATUS geStart (GeDevice*device);
STATUS geStop (GeDevice*device);
STATUS geUnload (GeDevice*device);
static int geIoctl (GeDevice*device, int command, caddr_t data);
static STATUS geSend (GeDevice*device, M_BLK_ID block);
static STATUS geMulticastAddressAdd (GeDevice*device, char*address);
static STATUS geMulticastAddressDelete (GeDevice*device, char*address);
static STATUS geMulticastAddressGet (GeDevice*device, MULTI_TABLE*table);
static STATUS gePollSend (GeDevice*device, M_BLK_ID block);
static STATUS gePollReceive (GeDevice*device, M_BLK_ID block);
static int geStartGm (GeDevice*device);

static int geParseInitString (GeDevice*device, char*initString);
static int geInitialize (GeDevice*device);
static void geFree (GeDevice*device);
static int geGiveReceiveBuffer (GeDevice*device);
static void geHandleReceiveDone (GeDevice*device, M_BLK_ID block);
static void geSendInterrupt (GeDevice*device);
static void geReceiveInterrupt (GeDevice*device, unsigned length, gm_u16_t csum);
void gePrintBlock (M_BLK_ID block);
void geMarkBlock (M_BLK_ID block);

#define GE_CACHE_PHYSICAL(d,p)(GM_ARCH_KVADDR_TO_PCI_ADDR ((int) CACHE_DRV_VIRT_TO_PHYS (&d->cacheFunctions, (p))))
#define GE_CACHE_VIRTUAL(d,p)CACHE_DRV_PHYS_TO_VIRT(&d->cacheFunctions, (p))
#define GE_CACHE_INVALIDATE(d,p,n)CACHE_DRV_INVALIDATE (&d->cacheFunctions, (p), (n))

static NET_FUNCS functionTable =
{
  (void*) geStart,
  (void*) geStop,
  (void*) geUnload,
  (void*) geIoctl,
  (void*) geSend,
  (void*) geMulticastAddressAdd,
  (void*) geMulticastAddressDelete,
  (void*) geMulticastAddressGet,
  (void*) gePollSend,
  (void*) gePollReceive,
  (void*) endEtherAddressForm,
  (void*) endEtherPacketDataGet,
  (void*) endEtherPacketAddrGet
};


END_OBJ*geEndObjs [GE_MAX_BOARDS];

int geHandleReceiveCount;
int geSendInterruptCount;
int geReceiveInterruptCount;
int geSendCount;
int geProvideCount;
int geReceiveDropCount;

#include <boardCsr.h>

extern int gm_instance_initialized[GM_ARCH_MAX_INSTANCE];

/*global entry point*/
END_OBJ*geLoad (char*initString, void* somePtr)
{
  GeDevice*device = 0;
  int r;

  printf ("geLoad\n");
  printf ("initString is %s\n", initString); 

  insist (CACHE_DMA_IS_WRITE_COHERENT ());
  insist (GM_ETHERNET_MTU < GE_BUFFER_SIZE);
  insist (GE_QUEUE_SIZE >= GE_NUM_RECEIVE_BUFFERS);
  insist (GE_QUEUE_SIZE >= GE_NUM_SEND_BUFFERS);
  insist (initString);
  
  if (!*initString)
  {
    bcopy (GE_NAME, initString, strlen (GE_NAME));
    return 0;
  }
  
  device = (GeDevice*) calloc (sizeof (GeDevice), 1);
  insist (device);
  
  r = geParseInitString (device, initString);
  insist (r);

  /*printf ("vxWorks unit number is %d, GM unit number is %d\n",
	  device->muxUnit, device->gmUnit);*/
  
  r = END_OBJ_INIT (&device->end, (DEV_OBJ*) device, GE_NAME, device->muxUnit, &functionTable, GE_DESCRIPTION);
  insist (r != ERROR);

  geStartGm (device);
  insist (device->gmUnit >= 0 && device->gmUnit < GE_MAX_BOARDS);
  
  return geEndObjs [device->gmUnit] =  &device->end;

  exception:
  if (device)
  {
    geFree (device);
    free (device);
  }
  
  return 0;
}

/*


ld < /ufs/wind/finucane/gm/libgm/_gm_provide_ethernet_scatter_list_k.o
ld < /ufs/wind/end2/target/lib/objPPC860gnuvx/ge.o

printf "%d, %d, %d %d\n", geHandleReceiveCount, geSendInterruptCount, geReceiveInterruptCount, geSendCount

p *(((GeDevice*)geEndObjs[0])->port->kernel_port_state->instance->lanai.globals
p/x *((int*)(((GeDevice*)geEndObjs[0])->port->kernel_port_state->instance->lanai.sram))
p ((GeDevice*)geEndObjs[0])

cd "../sbin"
ld < mapper
cplusCtors "mapper"
sp mapper,"david.args"


muxDevLoad 1, geLoad, "1", 0, 0
muxDevStart
ipAttach 1, "myri"
ifAddrSet "myri1", "199.201.130.151"
hostAdd "bigbox-t","199.201.130.100"
hostAdd "beta-t","199.201.130.23"
ifShow


14:08:33.660000 0:60:dd:7f:ee:2e 0:60:dd:7f:f1:1b ip 98: bigbox.myritest.com > mtx.myritest.com: icmp: echo request (ttl 64, id 21501)
                         4500 0054 53fd 0000 4001 921d c7c9 8264
                         c7c9 8297 0800 04df 554a 0000 516c 0e37
                         4930 0a00 0809 0a0b 0c0d 0e0f 1011 1213
                         1415 1617 1819
14:08:33.670000 0:60:dd:7f:f1:1b Broadcast arp 48: arp who-has bigbox.myritest.com tell mtx.myritest.com
                         0001 0800 0604 0001 0060 dd7f f11b c7c9
                         8297 0000 0000 0000 c7c9 8264 0000 0000
                         0000
14:08:33.670000 0:60:dd:7f:ee:2e 0:60:dd:7f:f1:1b arp 42: arp reply bigbox.myritest.com is-at 0:60:dd:7f:ee:2e
                         0001 0800 0604 0002 0060 dd7f ee2e c7c9
                         8264 0060 dd7f f11b c7c9 8297
14:08:33.670000 0:60:dd:7f:f1:1b 0:60:dd:7f:ee:2e ip 104: mtx.myritest.com > bigbox.myritest.com: icmp: echo reply (ttl 64, id 4164)
                         4500 0054 1044 0000 4001 d5d6 c7c9 8297
                         c7c9 8264 0000 0cdf 554a 0000 516c 0e37
                         4930 0a00 0809 0a0b 0c0d 0e0f 1011 1213
                         1415 1617 1819


*/
  

static int geGiveReceiveBuffer (GeDevice*device)
{
  char*cluster = 0;
  M_BLK_ID block = 0;
  gm_ethernet_segment_descriptor_t segment;
  int r;
  
  /*  printf ("geGiveReceiveBuffer\n"); */

  insist (device);

  block = netTupleGet (&device->receivePool, GE_BUFFER_SIZE, M_DONTWAIT, MT_DATA, FALSE);

  if (!block)
    return 0;

  insist (block->pClBlk);
  insist (block->mBlkHdr.mData == block->pClBlk->clNode.pClBuf);
  cluster = block->mBlkHdr.mData = GE_ROUND_POINTER (block->pClBlk->clNode.pClBuf);
  insist (cluster);
  insist (((unsigned)cluster) % GE_GRAIN == 0);

  /*geMarkBlock (block);*/
  segment.ptr.n = htonl (GE_CACHE_PHYSICAL (device, cluster));
  segment.len.n = htonl (GE_BUFFER_SIZE);
  insist (segment.ptr.n);

  r = gePut (&device->receiveQueue, block);
  insist (r);
  
  _gm_provide_ethernet_scatter_list (device->port, 1, &segment);
  geProvideCount++;
  device->provided++;

  insist (device->provided > 0 && device->provided <= GM_NUM_ETHERNET_RECV_TOKENS);
  
  return 1;
  
  exception:
  if (block)
    netMblkClFree (block);
  
  return 0;
}

static void geFree (GeDevice*device)
{  
  /*printf ("geFree\n"); */
  
  if (device)
  {
    if (device->sendBlockTable.memArea)
      free (device->sendBlockTable.memArea);
    device->sendBlockTable.memArea = 0;
    
    if (device->sendClusterTable.memArea)
      cacheDmaFree (device->sendClusterTable.memArea);
    device->sendClusterTable.memArea = 0;
    
    if (device->sendBlockTable.memArea)
      free (device->receiveBlockTable.memArea);
    device->receiveBlockTable.memArea = 0;
    
    if (device->receiveClusterTable.memArea)
      cacheDmaFree (device->receiveClusterTable.memArea);
    device->receiveClusterTable.memArea = 0;
    
  }
}

/* vxWorks seems prepend unit_number: to the init string*/

static int geParseInitString (GeDevice*device, char*initString)
{
  insist (device);
  insist (initString);

  /*printf ("initString is %s\n", initString); */
  device->muxUnit = device->gmUnit = -1;
  
  return sscanf (initString, "%d:%d", &device->muxUnit, &device->gmUnit) == 2;

  exception: return 0;
}

static int geInitialize (GeDevice*device)
{
  int r;

  /*  printf ("geInitialize\n"); */
  
  insist (device);
  device->end.pNetPool = malloc (sizeof (NET_POOL));
  insist (device->end.pNetPool);


  device->endBlockTable.mBlkNum = 2;
  device->endBlockTable.clBlkNum = 2;
  device->endBlockTable.memSize = 8 +  2 * (M_BLK_SZ + GE_GRAIN) + 2 * CL_BLK_SZ;
  device->endBlockTable.memArea = memalign (8, device->endBlockTable.memSize);
  insist (device->endBlockTable.memArea);

  r  = netPoolInit (device->end.pNetPool, &device->endBlockTable, &device->endClusterTable, 1, NULL);
  insist (r != ERROR);
  
  device->numSendTokens = GM_NUM_SEND_TOKENS;
  device->sendQueue.head = device->sendQueue.tail = 0;
  device->receiveQueue.head = device->receiveQueue.tail = 0;

  device->sendBlockTable.mBlkNum = GE_NUM_SEND_BUFFERS * 2;
  device->sendBlockTable.clBlkNum = GE_NUM_SEND_BUFFERS;
  device->sendBlockTable.memSize = GE_NUM_SEND_BUFFERS * 2 * (M_BLK_SZ + GE_GRAIN) + GE_NUM_SEND_BUFFERS * CL_BLK_SZ;
  device->sendBlockTable.memArea = memalign (8, device->sendBlockTable.memSize);
  insist (device->sendBlockTable.memArea);

  device->sendClusterTable.clSize = GE_BUFFER_SIZE;
  device->sendClusterTable.clNum = GE_NUM_SEND_BUFFERS;
  device->sendClusterTable.memSize = GE_NUM_SEND_BUFFERS * (GE_BUFFER_SIZE + GE_GRAIN);
  device->sendClusterTable.memArea = cacheDmaMalloc (device->sendClusterTable.memSize);
  insist (device->sendClusterTable.memArea);
  insist (((unsigned)device->sendClusterTable.memArea) % GE_GRAIN == 0);
  
  r = netPoolInit (&device->sendPool, &device->sendBlockTable, &device->sendClusterTable, 1, NULL);
  insist (r != ERROR);

  device->receiveBlockTable.mBlkNum = GE_NUM_RECEIVE_BUFFERS * 2;
  device->receiveBlockTable.clBlkNum = GE_NUM_RECEIVE_BUFFERS;
  device->receiveBlockTable.memSize = GE_NUM_RECEIVE_BUFFERS * 2 * (M_BLK_SZ + GE_GRAIN) + GE_NUM_RECEIVE_BUFFERS * CL_BLK_SZ;
  device->receiveBlockTable.memArea = memalign (8, device->receiveBlockTable.memSize);
  insist (device->receiveBlockTable.memArea);

  device->receiveClusterTable.clSize = GE_BUFFER_SIZE;
  device->receiveClusterTable.clNum = GE_NUM_RECEIVE_BUFFERS;
  device->receiveClusterTable.memSize = GE_NUM_RECEIVE_BUFFERS * (GE_BUFFER_SIZE + GE_GRAIN);
  device->receiveClusterTable.memArea = cacheDmaMalloc (device->receiveClusterTable.memSize);
  insist (device->receiveClusterTable.memArea);

  insist (((unsigned)device->receiveClusterTable.memArea) % GE_GRAIN == 0);
  
  r = netPoolInit (&device->receivePool, &device->receiveBlockTable, &device->receiveClusterTable, 1, NULL);
  insist (r != ERROR);		   

  return 1;
  
  exception:
  geFree (device);
  return 0;
}

static void geHandleReceiveDone (GeDevice*device, M_BLK_ID block)
{
  int level, r;

  /* printf ("geHandleReceiveDone\n");*/

  geHandleReceiveCount++;
  
  insist (device);
  insist (block);

  GE_CACHE_INVALIDATE(device, block->mBlkHdr.mData, block->mBlkHdr.mLen);
  
  /*  gePrintBlock (block); */


  level = intLock ();
  
  while (device->provided < GM_NUM_ETHERNET_RECV_TOKENS
	 && geGiveReceiveBuffer (device));

  intUnlock (level);
  
  if (device->provided < GE_MIN_RECEIVE_BUFFERS)
  {
    /*printf ("out of buffers. dropping packet\n");*/
    geReceiveDropCount++;
    
    END_ERR_ADD (&device->end, MIB2_IN_ERRS, 1);
    
    netMblkClChainFree (block);

    level = intLock ();
    
    r = geGiveReceiveBuffer (device);

    intUnlock (level);
    
    insist (r);
    return;
  }
  END_ERR_ADD (&device->end, MIB2_IN_UCAST, 1);
  END_RCV_RTN_CALL (&device->end, block);
  
  exception:;
}

extern STATUS gmVxWorksInit(void);

static int geStartGm (GeDevice*device)
{
  int r;
  insist (device);

  geHandleReceiveCount = 0;
  geSendInterruptCount = 0;
  geReceiveInterruptCount = 0;
  geSendCount = 0;
  geProvideCount = 0;
  
  /*printf ("geStartGm\n"); */

  if (!gm_instance_initialized[device->gmUnit])
  	gmVxWorksInit ();

  insist(gm_instance_initialized[device->gmUnit]);

  GM_NOTE (("geStartGm: call gm_open\n"));
  r =  gm_open (&device->port, device->gmUnit, GM_ETHERNET_PORT_ID, GE_NAME, GM_API_VERSION_1_0);
  insist (r == GM_SUCCESS);

  GM_NOTE (("geStartGm: call gm_get_unique_board_id\n"));
  r = gm_get_unique_board_id (device->port, device->address);
  insist (r == GM_SUCCESS);
  
  r = END_MIB_INIT (&device->end, M2_ifType_ethernet_csmacd, device->address, 6, GM_IP_MTU, 10000000);
  
  insist (r != ERROR);
    
  GM_NOTE (("geStartGm: geInitialize\n"));
  r = geInitialize (device);
  insist (r);
  
  
  END_OBJ_READY (&device->end, IFF_UP | IFF_RUNNING | IFF_NOTRAILERS | IFF_BROADCAST | IFF_SIMPLEX);
  device->gmStarted = 1;
  
  return 1;
  exception: return 0;
}

STATUS geStart (GeDevice*device)
{
  int i, r;
  int level;

  insist (device);

  /*  printf ("geStart\n"); */
  
  if (device->gmStarted)
  {
    level = intLock ();
    
    gm_ethernet_set_sent_intr_callback (device->port, (void*) geSendInterrupt, device);
    gm_ethernet_set_recv_intr_callback (device->port, (void*) geReceiveInterrupt, device);
    
    for (i = 0; i < GM_NUM_ETHERNET_RECV_TOKENS; i++)
    {
      r = geGiveReceiveBuffer (device);
      insist (r);
    }
    
    intUnlock (level);
  }
  
  return OK;
  exception: return ERROR;
}

STATUS geStop (GeDevice*device)
{
  insist (device);

  gm_ethernet_set_sent_intr_callback (device->port, (void*) 0, 0);
  gm_ethernet_set_recv_intr_callback (device->port, (void*) 0, 0);
  
  return OK; 
  exception: return ERROR;
}

STATUS geUnload (GeDevice*device)
{
  insist (device);

  END_OBJECT_UNLOAD (&device->end);
  gm_close (device->port);
  geFree (device);
  
  return OK;
  exception: return ERROR;
}

static STATUS geIoctl (GeDevice*device, int command, caddr_t data)
{
  int error = OK;
  long value;

  /*  printf ("geIoctl\n"); */
  
  insist (device);

  switch (command)
  {
    case EIOCSADDR:
      /*printf ("EIOCSADDR\n"); */
  
      return EINVAL;
      break;

    case EIOCGADDR:
      /*      printf ("EIOCGADDR\n"); */
  
      if (data == NULL)
	return EINVAL;
      bcopy (device->address, (char*) data, 6);
      break;

    case EIOCSFLAGS:
      /*      printf ("EIOCSFLAGS\n"); */
      
      value = (long) data;
      if (value < 0)
      {
	value = -value;
	value--;
	END_FLAGS_CLR (&device->end, value);
      }
      else
      {
	END_FLAGS_SET (&device->end, value);
      }
      break;
      
    case EIOCGFLAGS:
      /*      printf ("EIOCGFLAGS\n");*/
      
      *(int*) data = END_FLAGS_GET (&device->end);
      break;

    case EIOCPOLLSTART:
    case EIOCPOLLSTOP:
      /*      printf ("EIOCPOLLSTART/STOP\n"); */
      
      break;

    case EIOCGMIB2:
      /*       printf ("EIOCGMIB2\n");*/
      
      if (data == NULL)
	return EINVAL;
      bcopy ((char*) &device->end.mib2Tbl, (char*) data, sizeof(device->end.mib2Tbl));
      break;

    case EIOCGFBUF:
      /*       printf ("EIOCGFBUF\n");*/
      
      if (data == NULL)
	return EINVAL;
      *(int*) data = GE_MIN_FIRST_BUFFER;
      break;

    case EIOCGHDRLEN:
      /*       printf ("EIOCGHDRLEN\n");*/
      
      if (data == NULL)
	return EINVAL;
      *(int*) data = 14;
      break;
    default:
      /*       printf ("default\n");*/
      
      error = EINVAL;
  }
  return error;
  
  exception: return ERROR;
}

static STATUS geSend (GeDevice*device, M_BLK_ID chain)
{
  M_BLK_ID m;
  char address [6];
  char*cluster = 0;
  gm_ethernet_segment_descriptor_t segments[GM_MAX_ETHERNET_GATHER_CNT];
  int numSegments;
  int r, i, totalLength, length, broadcast;

  geSendCount++;
  
  /*printf ("geSend\n");*/
  
  insist (device);
  insist (chain);
  insist (device->numSendTokens >= 0 && device->numSendTokens <= GM_NUM_SEND_TOKENS);
  
  if (!device->numSendTokens || geFull (&device->sendQueue))
  {
    END_ERR_ADD (&device->end, MIB2_OUT_ERRS, 1); 
    return ERROR;
  }  

  insist (chain->mBlkPktHdr.len >= 14 && chain->mBlkPktHdr.len <= GM_ETHERNET_MTU);
  
  bcopy (chain->mBlkHdr.mData, address, 6);

#if GM_EMULATE_BYTE_DMAS && !CSPI_MAP26xx
  for (m = chain, totalLength = 0, numSegments = 0; m; numSegments++)
  {
    insist (m->mBlkHdr.mLen >= 0 && m->mBlkHdr.mLen <= GM_ETHERNET_MTU);

    /*for some reason sections (hopefully last) are sometimes empty.*/
    if (m->mBlkHdr.mLen == 0)
    {
      while ((m = m->mBlkHdr.mNext))
      {
	insist (!m->mBlkHdr.mLen);
      }
      break;
    }
    
    totalLength += m->mBlkHdr.mLen;
    m = m->mBlkHdr.mNext;
  }
  
  insist (numSegments > 0);
  insist (totalLength >= 14);

  /*  printf ("numSegments is  %d\n", numSegments);*/
  
  if (numSegments <= GM_MAX_ETHERNET_GATHER_CNT && totalLength > GE_MIN_GATHER_LENGTH)
  {
    m = chain;
    
    for (i = 0; i < numSegments; i++)
    {
      insist (m);
      insist (m->mBlkHdr.mLen > 0 && m->mBlkHdr.mLen <= GM_ETHERNET_MTU);
      insist (i < GM_MAX_ETHERNET_GATHER_CNT);

      /*      gePrintBlock (m);*/
      
      GE_CACHE_INVALIDATE (device, m->mBlkHdr.mData, m->mBlkHdr.mLen);

      segments [i].ptr.n = htonl (GE_CACHE_PHYSICAL (device, m->mBlkHdr.mData));
      segments [i].len.n = htonl (m->mBlkHdr.mLen);
      
      m = m->mBlkHdr.mNext;
    }
    m = chain;
  }
  else
#else
#endif
  {
    m = netTupleGet (&device->sendPool, GE_BUFFER_SIZE, M_DONTWAIT, MT_DATA, FALSE);
    insist (m);
    
    insist (m->pClBlk);
    cluster = GE_ROUND_POINTER (m->pClBlk->clNode.pClBuf);
    insist ( (unsigned long long)cluster % GE_GRAIN == 0);
    insist (cluster);
    
    length = netMblkToBufCopy (chain, ((unsigned char*)cluster), NULL);
    insist (length > 0 && length <= GM_ETHERNET_MTU);
    /*    *((short *)cluster) = gm_htons (GM_ETHERNET_PACKET_TYPE);*/
    
    /*gePrintBlock (chain);*/
    
    netMblkClChainFree (chain);
    
    GE_CACHE_INVALIDATE (device, cluster, length);

    numSegments = 1;
    segments [0].ptr.n = htonl (GE_CACHE_PHYSICAL (device, cluster));
    segments [0].len.n = htonl (GE_ROUND_INT (length));
    insist (segments [0].ptr.n);
  }
  
  r = gePut (&device->sendQueue, m);
  insist (r);

  broadcast =
    address [0] == (char) 0xff &&
    address [1] == (char) 0xff &&
    address [2] == (char) 0xff &&
    address [3] == (char) 0xff &&
    address [4] == (char) 0xff &&
    address [5] == (char) 0xff;  

  device->numSendTokens--;
  
  END_ERR_ADD (&device->end, MIB2_OUT_UCAST, 1);

  /*#warning nelson debug stuff*/
  /*gePrintBuf(segments[0].ptr & (~0x80000000), segments[0].len);   nre */
  
  if (broadcast)
    gm_ethernet_broadcast (device->port, numSegments, segments, 1);
  else
    gm_ethernet_send (device->port, numSegments, segments, address, 1);

  /*   printf ("sent %s", broadcast ? "broadcast\n" : "unicast\n");*/
  
  return OK;
  exception: return ERROR;
}

static STATUS geMulticastAddressAdd (GeDevice*device, char*address)
{
  insist (device && address);
  insist (0);
  
  return OK;
  exception: return ERROR;
}

static STATUS geMulticastAddressDelete (GeDevice*device, char*address)
{
  insist (device && address);
  insist (0);
  
  return OK;
  exception: return ERROR;
}

static STATUS geMulticastAddressGet (GeDevice*device, MULTI_TABLE*table)
{
  insist (device && table);
  insist (0);
  
  return OK;
  exception: return ERROR;
}

static STATUS gePollSend (GeDevice*device, M_BLK_ID block)
{
  return geSend (device, block);
}

static void geSendInterrupt (GeDevice*device)
{
  
  M_BLK_ID block;

  insist (device);
  geSendInterruptCount++;
  
  /*   printf ("got a sent event\n");*/
  block = (M_BLK_ID) geGet (&device->sendQueue);
  insist (block);
  netMblkClChainFree (block);
  device->numSendTokens++;
  insist (device->numSendTokens >= 0 && device->numSendTokens <= GM_NUM_SEND_TOKENS);

  exception: return;
}

static void geReceiveInterrupt (GeDevice*device, unsigned length, gm_u16_t csum)
{
  int r;
  M_BLK_ID block;

  insist (device && length);
  insist (length <= GM_ETHERNET_MTU);

  geReceiveInterruptCount++;
  device->provided--;
  
  insist (device->provided >= 0 && device->provided <= GM_NUM_ETHERNET_RECV_TOKENS);
  
  /*  printf ("got a receive event\n");*/
  block = (M_BLK_ID) geGet (&device->receiveQueue);
  insist (block);
  
  insist (((unsigned)block->mBlkHdr.mData) % GE_GRAIN == 0);
  
  block->mBlkHdr.mData += GE_GM_SIZEOF_GM_HEADER;
  block->mBlkHdr.mLen = length - GE_GM_SIZEOF_GM_HEADER;
  block->mBlkHdr.mFlags |= M_PKTHDR;
  block->mBlkPktHdr.len = block->mBlkHdr.mLen;
  
  r = netJobAdd ((FUNCPTR) geHandleReceiveDone, (int) device, (int) block, 0, 0, 0);

  exception: return;
}

/*this function is broken*/

static STATUS gePollReceive (GeDevice*device, M_BLK_ID block)
{
#ifdef DEAD_CODE
  M_BLK_ID m;
  int r;
  
  insist (device);
  insist (block);

  
  if (!geCheckEventQueue (device, &m))
    return EAGAIN;
  */
  
  if (block->mBlkHdr.mLen < m->mBlkHdr.mLen || !(block->mBlkHdr.mFlags & M_EXT))
  {
    END_ERR_ADD (&device->end, MIB2_IN_ERRS, 1);
    printf ("gePollReceive: buffer not big enough\n");
    return EAGAIN;
  }

  bcopy (m->mBlkHdr.mData, block->mBlkHdr.mData, m->mBlkHdr.mLen);
  block->mBlkHdr.mLen = m->mBlkHdr.mLen;
  block->mBlkHdr.mFlags |= M_PKTHDR;
  block->mBlkPktHdr.len = block->mBlkHdr.mLen;

  END_ERR_ADD (&device->end, MIB2_IN_UCAST, 1);
  netMblkClChainFree (m);
  r = geGiveReceiveBuffer (device);
  insist (r);

  return OK;
  exception:
#endif
  return ERROR;
}

int geSize (GeQueue*queue)
{
  insist (queue);
  insist (queue->head <= GE_QUEUE_SIZE && queue->head >= 0);
  insist (queue->tail <= GE_QUEUE_SIZE && queue->tail >= 0);
  
  if (queue->tail >= queue->head)
    return queue->tail - queue->head;

  if (!(GE_QUEUE_SIZE - queue->head + queue->tail < GE_QUEUE_SIZE))
    printf ("%d, %d, %d", GE_QUEUE_SIZE, queue->tail, queue->head);
  
  insist (GE_QUEUE_SIZE - queue->head + queue->tail <= GE_QUEUE_SIZE);
  insist (!geFull (queue) || GE_QUEUE_SIZE - queue->tail + queue->head == GE_QUEUE_SIZE);
  
  return GE_QUEUE_SIZE - queue->head + queue->tail;
  
  exception: return 0;
}


int geFull (GeQueue*queue)
{
  insist (queue);
  insist (queue->head <= GE_QUEUE_SIZE && queue->head >= 0);
  insist (queue->tail <= GE_QUEUE_SIZE && queue->tail >= 0);
  
  return queue->tail + 1 == queue->head || (queue->head == 0 && queue->tail == GE_QUEUE_SIZE);
  exception: return 0;
}

int geEmpty (GeQueue*queue)
{
  insist (queue);
  insist (queue->head <= GE_QUEUE_SIZE && queue->head >= 0);
  insist (queue->tail <= GE_QUEUE_SIZE && queue->tail >= 0);
  
  return queue->tail == queue->head;
  exception: return 0;
}

int gePut (GeQueue*queue, void*buffer)
{
  insist (queue && buffer);

  if (geFull (queue))
    return 0;

  queue->items [queue->tail] = buffer;
  if (++queue->tail == GE_QUEUE_SIZE + 1)
    queue->tail = 0;
  return 1;
  exception: return 0;
}

void*geGet (GeQueue*queue)
{
  void*buffer;
  
  insist (queue);

  if (geEmpty (queue))
    return 0;

  buffer = queue->items [queue->head];
  if (++queue->head == GE_QUEUE_SIZE + 1)
    queue->head = 0;
  return buffer;
  exception: return 0;
}


void gePrintBlock (M_BLK_ID block)
{
  int i, length;
  char*p;
  
  insist (block);

  printf ("block->mBlkHdr.mData = %x\n", (unsigned) block->mBlkHdr.mData);
  printf ("block->mBlkHdr.mLen = %d\n",  block->mBlkHdr.mLen);

  length = block->mBlkHdr.mLen;
  p = (char*) block->mBlkHdr.mData;
  
  if (length > 256)
    length = 256;
  
  for (i = 0; i < length; i++)
    printf ("%02x%c",0xff & p[i], i % 8 == 7 ? '\n' : ' ');
  printf ("\n");
   
  exception: return;
}

void geMarkBlock (M_BLK_ID block)
{
  int i;
  char*p;
  
  insist (block);

  p = (char*) block->mBlkHdr.mData;
  
  for (i = 0; i < 256; i++)
    p [i] = i;
   
  exception: return;
}

#include "time.h"

void geDocat (int msec)
{
  int i, j;
  struct timespec t;

  for (;;)
  {
    for ( i = 0; i < 500; i++)
    {
      for (j = 0; j < 40; j++)
	printf ("%d", j);
      printf ("\n");
    }
    
    t.tv_sec = msec / (1000);
    t.tv_nsec = 1000 * 1000 * (msec % (1000));
    nanosleep (&t, NULL);
  }
}

void gePrintBuf (char*p, int length)
{
  int i;

  GM_PRINT (1, ("length is %d\n", length));
  _GM_PRINT (1, ("p = 0x%08x\n", p));

  insist (p);
  
  for (i = 0; i < length; i++)
    _GM_PRINT (1, ("%02x%c",0xff & p[i], i % 8 == 7 ? '\n' : ' '));
  _GM_PRINT (1, ("\n"));
  
  exception: return;
}
