/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/*
 You need to enable one of these sections, or write your own. These are
 the defines to handle quirks of each BSP.
*/

#include "vxWorks.h"
#include "intLib.h"
#include "semLib.h"


/*******************************************************************************/
#ifdef CSPI_MAP26xx

/* currently cspi MAP26xx board can ONLY support 1 myrinet board */
/* NOTE:  the MAP2610 is an exception and is defined under
   MOTOROLA_MVME, later in this file */

#define GM_ARCH_NUM_BOARDS_SUPPORTED     1

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_MAP26xx

#define GM_SYSTEM_HAS_BIOS          0

/* this board has a lanai chip built into it, so it doesn't have a PCI bus
   so we don't define the usual pci definitions */
#define GM_CSPI_MAP26xx_INT_LINE    0x1b

#define GM_ARCH_DMA_BITS_TO_SET    0x00000000 
#define GM_ARCH_DMA_BITS_TO_CLEAR  0x00000000

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif
#endif /* CSPI_MAP26xx */
/*******************************************************************************/


/*******************************************************************************/
#ifdef MTX_603
/* Motorola MTX 603 */
#define TARGET_DIR "mtx603"
#include "config.h"

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     3

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

#define GM_SYSTEM_HAS_BIOS          0

/* Define the characteristics of each slot we might possibly use */
/* Make sure the address spaces don't overlap, and that each 
   interrupt is correct for your hardware.  */

#define GM_SLOT_0_ADDR      0x02000000
#define GM_SLOT_0_SPAN      0x01000000
#define GM_SLOT_0_INT_LINE  0x19
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     16
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x03000000
#define GM_SLOT_1_SPAN      0x01000000
#define GM_SLOT_1_INT_LINE  0x1a
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     17
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x04000000
#define GM_SLOT_2_SPAN      0x01000000
#define GM_SLOT_2_INT_LINE  0x1b
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     18
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x00000000
#define GM_SLOT_3_SPAN      0x00000000
#define GM_SLOT_3_INT_LINE  0x0
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     0
#define GM_SLOT_3_FUNCNO    0

/* How do we convert from a pci address to a cpu address */
#define GM_BOARD_PCI_TO_CPU(x)     ((unsigned int)(x) | 0xc0000000)

/* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_SET	        0x80000000	
#define GM_ARCH_DMA_BITS_TO_CLEAR	0x00000000
#endif /* MTX_603 */
/*******************************************************************************/


/*******************************************************************************/
#ifdef FORCE_PCORE750
/* Force PowerCore 750 */
#include "pcore750/config.h"
#include "frcPciLib.c"

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     1

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

#define GM_SYSTEM_HAS_BIOS          0

#define GM_SLOT_0_ADDR      0xb0000000
#define GM_SLOT_0_SPAN      0x01000000
#define GM_SLOT_0_INT_LINE  0x0e
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     16
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x00000000
#define GM_SLOT_1_SPAN      0x00000000
#define GM_SLOT_1_INT_LINE  0x0
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     0
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x00000000
#define GM_SLOT_2_SPAN      0x00000000
#define GM_SLOT_2_INT_LINE  0x0
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     0
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x00000000
#define GM_SLOT_3_SPAN      0x00000000
#define GM_SLOT_3_INT_LINE  0x0
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     0
#define GM_SLOT_3_FUNCNO    0

#define GM_BOARD_PCI_TO_CPU(x)     (x)

#define GM_ARCH_DMA_BITS_TO_SET     0x00000000  /* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_CLEAR   0x00000000
#endif /* FORCE_PCORE750 */
/*******************************************************************************/



/*******************************************************************************/
#ifdef MOTOROLA_MVME
/* Motorola MVME2603, MVME2303, MVME2403, MVME2703, and CSPI MAP2610  */
/* #define TARGET_DIR "MAP2610" */
/* #include "config.h: */

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     1

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

#define GM_SYSTEM_HAS_BIOS          0

#define GM_SLOT_0_ADDR      0x02000000
#define GM_SLOT_0_SPAN      0x01000000
#define GM_SLOT_0_INT_LINE  0x19
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     16
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x00000000
#define GM_SLOT_1_SPAN      0x00000000
#define GM_SLOT_1_INT_LINE  0x0
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     0
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x00000000
#define GM_SLOT_2_SPAN      0x00000000
#define GM_SLOT_2_INT_LINE  0x0
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     0
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x00000000
#define GM_SLOT_3_SPAN      0x00000000
#define GM_SLOT_3_INT_LINE  0x0
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     0
#define GM_SLOT_3_FUNCNO    0

#define GM_BOARD_PCI_TO_CPU(x)     ((unsigned int)(x) | 0xc0000000)

#define GM_ARCH_DMA_BITS_TO_SET         0x80000000 /* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_CLEAR       0x00000000
#endif /* MOTOROLA_MVME */
/*******************************************************************************/

/*******************************************************************************/
#ifdef CP600

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     2

/* PEP CP600 */
#include "config.h"

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec) >> 3)
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) ((intNum) << 3))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

/* having a bios implies each card has already been assigned
   an address and interrupt, and that gm should use them. */
#define GM_SYSTEM_HAS_BIOS         1

/* we have a bios, so these don't matter */
#define GM_SLOT_0_ADDR      0x00000000
#define GM_SLOT_0_SPAN      0x00000000
#define GM_SLOT_0_INT_LINE  0x0
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     0
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x00000000
#define GM_SLOT_1_SPAN      0x00000000
#define GM_SLOT_1_INT_LINE  0x0
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     0
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x00000000
#define GM_SLOT_2_SPAN      0x00000000
#define GM_SLOT_2_INT_LINE  0x0
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     0
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x00000000
#define GM_SLOT_3_SPAN      0x00000000
#define GM_SLOT_3_INT_LINE  0x0
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     0
#define GM_SLOT_3_FUNCNO    0

#define GM_BOARD_PCI_TO_CPU(x)     ((unsigned int)(x) | 0x00000000)

#define GM_ARCH_DMA_BITS_TO_SET		0x00000000	/* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_CLEAR	0x00000000
#endif /* CP600 */
/*******************************************************************************/

/*******************************************************************************/
#ifdef MCP_750
/* Motorola MTC 750 */
#define TARGET_DIR "mcp750"
#include "config.h"

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     1

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

#define GM_SYSTEM_HAS_BIOS          0

/* Define the characteristics of each slot we might possibly use */
/* Make sure the address spaces don't overlap, and that each 
   interrupt is correct for your hardware.  */

#define GM_SLOT_0_ADDR      0x02000000
#define GM_SLOT_0_SPAN      0x01000000
#define GM_SLOT_0_INT_LINE  0x13
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     16
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x00000000
#define GM_SLOT_1_SPAN      0x00000000
#define GM_SLOT_1_INT_LINE  0x0
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     0
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x00000000
#define GM_SLOT_2_SPAN      0x00000000
#define GM_SLOT_2_INT_LINE  0x0
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     0
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x00000000
#define GM_SLOT_3_SPAN      0x00000000
#define GM_SLOT_3_INT_LINE  0x0
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     0
#define GM_SLOT_3_FUNCNO    0

/* How do we convert from a pci address to a cpu address */
#define GM_BOARD_PCI_TO_CPU(x)     ((unsigned int)(x) | 0xc0000000)

/* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_SET	        0x80000000	
#define GM_ARCH_DMA_BITS_TO_CLEAR	0x00000000
#endif /* MCP_750 */
/*************************************************************************/
/*************************************************************************/
#ifdef IBM_405
#define TARGET_DIR "ibm405"
#include "config.h"

/* because vxworks doesn't have MMU support for the IBM 405 board
   ( the walnut board ) yet, we need some hacks to get things working */
#define IBM_405_MMU_HACK

/* GM_ARCH_NUM_BOARDS_SUPPORTED must be <= GM_ARCH_MAX_INSTANCE */
#define GM_ARCH_NUM_BOARDS_SUPPORTED     4

#ifndef INUM_TO_IVEC
#define IVEC_TO_INUM(intVec)    ((int) (intVec))
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#endif

/* must be a gm_bus_type */
#define GM_SYSTEM_BUS_TYPE         GM_MYRINET_BUS_PCI

#define GM_SYSTEM_HAS_BIOS          0

/* Define the characteristics of each slot we might possibly use */
/* Make sure the address spaces don't overlap, and that each 
   interrupt is correct for your hardware.  */

#define GM_SLOT_0_ADDR      0x80000000
#define GM_SLOT_0_SPAN      0x01000000
#define GM_SLOT_0_INT_LINE  0x1c
#define GM_SLOT_0_BUSNO     0
#define GM_SLOT_0_DEVNO     1
#define GM_SLOT_0_FUNCNO    0
#define GM_SLOT_1_ADDR      0x81000000
#define GM_SLOT_1_SPAN      0x01000000
#define GM_SLOT_1_INT_LINE  0x1d
#define GM_SLOT_1_BUSNO     0
#define GM_SLOT_1_DEVNO     2
#define GM_SLOT_1_FUNCNO    0
#define GM_SLOT_2_ADDR      0x82000000
#define GM_SLOT_2_SPAN      0x01000000
#define GM_SLOT_2_INT_LINE  0x1e
#define GM_SLOT_2_BUSNO     0
#define GM_SLOT_2_DEVNO     3
#define GM_SLOT_2_FUNCNO    0
#define GM_SLOT_3_ADDR      0x83000000
#define GM_SLOT_3_SPAN      0x01000000
#define GM_SLOT_3_INT_LINE  0x1f
#define GM_SLOT_3_BUSNO     0
#define GM_SLOT_3_DEVNO     4
#define GM_SLOT_3_FUNCNO    0

/* How do we convert from a pci address to a cpu address */
#define GM_BOARD_PCI_TO_CPU(x)     ((unsigned int)x | 0x00000000)

/* convert kvaddr to PCI DMAaddr */
#define GM_ARCH_DMA_BITS_TO_SET         0x00000000      
#define GM_ARCH_DMA_BITS_TO_CLEAR       0x00000000

#endif /* IBM_405 */
/***************************************************************************/

#define GM_ARCH_KVADDR_TO_PCI_ADDR(x) (x | GM_ARCH_DMA_BITS_TO_SET)







