/*****************************************************************\
*                                                                 *
* FILE:        boardCsr.h                                         *
*                                                                 *
* DESCRIPTION: This file contain register descriptions for the    *
*              MAP2640 and MAP2740 board.                         *
*                                                                 *
*                                                                 *
*  Copyright CSP Inc. 1991 - 1997. All rights reserved            *
*                                                                 *
*  All copyrights in this computer program, version of which was  *
*  first licensed on the date indicated above, are the exclusive  *
*  property of CSP Inc.  Claim of copyright does not imply        *
*  publication of CSP's trade secrets or waiver of CSP's other    *
*  rights in the work.  See the following Notice of Proprietary   *
*  Rights.                                                        *
*                                                                 *
*  NOTICE OF PROPRIETARY RIGHTS                                   *
*  This computer program is a confidential trade secret of        *
*  CSP Inc.  Use, examination, reproduction, copying, transfer    *
*  and/or disclosure to others of all or any part of this computer*
*  program are prohibited except with the express written consent *
*  of CSP Inc.                                                    *
*                                                                 *
* Revision History:                                               *
*   01-JUL-1999  WLIU Added support for POST
*   06-MAR-1997  SAB  Created.                                    *
*   29-MAY-1998  ETS  2641 additions                              *
*         PPCLAN Registers added to structure, Defines for new PPC*
*         Configuration register bits, External I/O Devices, Flash*
*         types, sector sizes, sector counters,  and  defines for *
*         FMT and user flash memory space added                   *
*                                                                 *
\*****************************************************************/

#ifndef CSPI_ALL_BOARDS
#if defined MAP2610 || defined MAP2611 || defined MAP2710 || defined MAP2711 || \
    defined MAP2640 || defined MAP2641 || defined MAP2316 || \
    defined MAP2740 || defined MAP2741
#define CSPI_ALL_BOARDS
#
#if defined MAP2610 || defined MAP2611 || defined MAP2710 || defined MAP2711
#   define CSPI_MOTOROLA_BOARDS
#else
#   define CSPI_BASE_BOARDS
#endif
#
#if GM_2610_DRV || GM_2611_DRV || \
    GM_2640_DRV || GM_2641_DRV || \
    GM_2316_DRV || GM_2740_DRV || \
    GM_2741_DRV || GM_2742_DRV || \
    GM_2840_DRV || GM_2841_DRV
#   define INCLUDE_GM_DRIVER 1
#endif
#endif
#endif /* end of CSPI_ALL_BOARDS */

#ifndef INC_BOARDCSR
#define INC_BOARDCSR 

/*****************************\
* Define CSPI 64 bit register * 
\*****************************/
#ifndef _ASMLANGUAGE
#ifndef __CSPIREG
#define __CSPIREG
typedef struct {
   volatile unsigned long  reg;
   long   pad;
   }  CSPI_REG2;
typedef struct {
   volatile unsigned long  reg;
   long   pad1;
   long   pad2;
   long   pad3;
   }  CSPI_REG4;
#endif
#endif /* end of ASMLANGUAGE */

/*****************************\
* Missing definitions from WR
\*****************************/
#define SYSFLG_BOOTP             0x40   /* Use bootp to get boot parameters */

/*****************************\
* Defines cpu type            
* PPC definition from hardware
\*****************************/
#define CPU_TYPE                ((vxPvrGet() >> 16) & 0xffff)
#define CPU_TYPE_601            0x01    /* PPC 601 CPU */
#define CPU_TYPE_602            0x02    /* PPC 602 CPU */
#define CPU_TYPE_603            0x03    /* PPC 603 CPU */
#define CPU_TYPE_603E           0x06    /* PPC 603e CPU */
#define CPU_TYPE_603P           0x07    /* PPC 603p CPU */
#define CPU_TYPE_750            0x08    /* PPC 750 CPU */
#define CPU_TYPE_604            0x04    /* PPC 604 CPU */
#define CPU_TYPE_604E           0x09    /* PPC 604e CPU */
#define CPU_TYPE_604R           0x0A    /* PPC 604r CPU */
 
/*****************************\
* Defines for unused memory 
\*****************************/
#define MEM_UNUSED 0x90000000

/*****************************\
* Defines for SDRAM
\*****************************/
#define SDRAM_START 0x00000000

/******************************\
* Defines for LANai SRAM
\******************************/
#define SRAM_START 0x40000000

/*****************************\
* Defines for LANai Registers *
\*****************************/
#define LANAI_REG_START 0x48000000

/*****************************\
* Defines for LANai EEPROM/   *
* BOARD_CFG_INFO struct    *
\*****************************/
#define BOARD_CONFIG_INFO_START 0xffffff00
#define EEPROM_START BOARD_CONFIG_INFO_START  

#ifndef _ASMLANGUAGE
/******************************\
* Defines for Board Config Info
* structure in flash 
\******************************/
struct MYRINET_EEPROM_1 {            /* Also defined in lanai_def.h */
   unsigned int lanai_clockval;
   unsigned short lanai_cpu_version;
   unsigned char lanai_board_id[6];
   unsigned int lanai_sram_size;
   unsigned char fpga_version[32];
   unsigned char more_version[16];
   unsigned short delay_line_value;
   unsigned short board_type;
   unsigned short bus_type;
   unsigned short future_use[29];
   };
 
typedef struct {
   struct MYRINET_EEPROM_1 myriInfo;/* myrinet info block     */
   long memSize;                    /* SDRAM size (bytes)     */
   long flashType;                  /* flash type (see below) */
   long ppcClkRate;                 /* clock speed (Hz)       */
   long flashSize;                  /* flash size (bytes)     */
   long P0Present;                  /* board has P0 connector */
   long IOPresent;                  /* board has External I/O */
   long procType;                   /* cpu processor type     */
   long pageSize;                   /* SDRAM page size (bytes)*/
   long LANmemSize;                 /* LANai SRAM size (bytes)*/
   long IOmemSize;                  /* Ext IO mem size (bytes)*/
   long L2CacheInit;                /* L2 cache register init value */
   long boardType;                  /* board type             */
   long postAddr;                   /* address of CSPI POST test */
   long usrPostAddr;                /* address of user POST test */
   long reserved[16];               /* ...unused...           */
   unsigned long checksum;          /* Config Info checksum   */
   long PPC403vector;               /* only used on 2316      */
   } BOARD_CFG_INFO;
#else
#  define pCSPI_POST_ADDR 0xffffffb0  /* (BOARD_CONFIG_INFO_START + 0xb0) */
#  define pUSER_POST_ADDR 0xffffffb4  /* (BOARD_CONFIG_INFO_START + 0xb4) */
#endif /* end of ASMLANGUAGE */

/******************************\
* Defines for POST parameter   *
* addresses                    *
\******************************/
#define CSPI_POST_PARAM_ADDR  0xfff000a8    /* CSPI POST parameter address */
#define USER_POST_PARAM_ADDR  0xfff000d0    /* User POST parameter address */
#define CSPI_POST_ADDR 0xfffe0000

/******************************\
* Defines for PPCLAN Registers
\******************************/
#define PPCLAN_CSR_START 0xf0000000
#define PPC_CSR_SET        (PPCLAN_CSR_START + 0x000)
#define PPC_CSR_CLR        (PPCLAN_CSR_START + 0x008)

#ifndef _ASMLANGUAGE
typedef struct {
   CSPI_REG2  CSR_SET;     /* CSR Set                        */
   CSPI_REG2  CSR_CLR;     /* CSR Clear                      */
   CSPI_REG2  INT_SET;     /* Interrupt Flag Set             */
   CSPI_REG2  INT_CLR;     /* Interrupt Flag Clear           */
   CSPI_REG2  INTE_SET;    /* Interrupt Enable Set           */
   CSPI_REG2  INTE_CLR;    /* Interrupt Enable Clear         */
   CSPI_REG4  RTC;         /* RTC Count Value                */
   CSPI_REG4  DUR;         /* RTC Duration Value             */
   CSPI_REG4  CFG;         /* Configuration Register         */
   CSPI_REG4  PPC_LAT;     /* PowerPC Bus Latency            */
   CSPI_REG4  LAN_LAT;     /* LANai Bus Latency              */
   CSPI_REG4  PPC_CMRI;    /* Coherent Mem Region Inhibit    */
   CSPI_REG4  PPC_PMEC;    /* Perf Monitor Event Counter     */
   CSPI_REG4  DIAG_TEST;   /* Diagnostic Test                */
   CSPI_REG4  WATCH_DOG;   /* Watch Timer                    */
   CSPI_REG4  MSEC;        /* Micro-second Clock             */
   CSPI_REG4  RETRY;       /* Retry Count                    */
   CSPI_REG4  HIT;         /* Cache Hit Count                */
   } PPCLAN ;
#else
#  define PPCLAN_CFG_REG   PPCLAN_CSR_START + 0x50  /* Configuration Reg. */
#endif /* end of ASMLANGUAGE */


/******************************\
* Defines for Board CSR bits   *
\******************************/
#define PRSET        0x80000000
#define HRSET        0x40000000
#define SREST        0x20000000
#define LANRST       0x10000000
#define ERST         0x08000000
#define IORST        0x04000000
#define GSENB        0x02000000
#define LANINT       0x01000000
#define PPCUN        0x00800000
#define DIAGSYNC     0x00400000
#define LED0         0x00100000
#define LED1         0x00080000
#define ITENB        0x00008000     /* PPC clock enable                  */
#define RTENB        0x00004000     /* Board Clock on                    */
#define RTINC        0x00002000     /* Board Clock increment (diagnostic)*/
#define RTIEN        0x00001000     /* Board Clock Interrupt Enable      */
#define RTINT        0x00000800     /* Board Clock Interrupt             */
#define ARB1         0x00000200     /* Arbitration Priority Select 1     */
#define ARB0         0x00000100     /* Arbitration Priority Select 0     */
#define WATCH_MODE   0x00000020     /* Board Watch Dog Clock board reset */
#define WATCH_ENB    0x00000010     /* Board Watch Dog Clock on          */
#define EN_DMA       0x00000008
#define FLBSY        0x00000002     /* 0 => FLASH operation in progress  */
#define IO_OK        0x00000001     

#define LED_OFF      (LED0 | LED1)
#define LED_RED      LED1
#define LED_GREEN    LED0
#define LED_AMBER    (LED0 | LED1)

#define PRIORITY_SHF 8;

/******************************\
* Defines for PPC_INT bits     *
* Defines for PPC_INTE bits    *
\******************************/
#define GLB_INT      0x80000000
#define IO_INT       0x00000080
#define PARITY_INT   0x00000040
#define WATCH_INT    0x00000020
#define LANAI_INT    0x00000010
#define E2L_INT      0x00000008
#define L2E_INT      0x00000004
#define PPC_ILAD     0x00000002
#define DMA_ILAD     0x00000001
#define PPC_ALL_INT  0x000000ff

/*****************************\
* Defines for Flash PROM      *
\*****************************/
#define FLASH_START      0xffe00000
#define FLASH_SIZE_1M    0x00100000
#define FLASH_SIZE_2M    0x00200000
#define FLASH_SIZE_4M    0x00400000
#define FLASH_SIZE_8M    0x00800000
#define FLASH_SIZE_16M   0x01000000
#define FLASH_SIZE       FLASH_SIZE_2M

#define FLASH_CFG_BYTE_WIDE                             0  /* 2640 */
#define FLASH_CFG_SHORT_WIDE                            1
#define FLASH_CFG_DUAL_SHORT_WIDE                       2  /* 2641, 2740 */
#define FLASH_CFG_LONG_WIDE                             3
#define FLASH_CFG_DUAL_LONG_WIDE                        4
#define FLASH_CFG_DUAL_SHORT_WIDE_BACKWARDS             5  /* 2640 backwards */
#define FLASH_CFG_DUAL_SHORT_WIDE_READ_ONLY             6  /* 2641 readonly  */
#define FLASH_CFG_DUAL_SHORT_WIDE_BACKWARDS_READ_ONLY   7  /* 2641 backwards */
                                                           /*  read only     */
#define FLASH_CFG_DUAL_SHORT_WIDE_8MB                   8  /* 2741,2840 - 8mb*/
#define FLASH_CFG_DUAL_SHORT_WIDE_16MB                  9  /* 2841 - 16mb    */


/*******************************\
* L2 Cache Definitions          *
\*******************************/
#define L2_SIZE_256KB    0x00040000
#define L2_SIZE_512KB    0x00080000
#define L2_SIZE_1MB      0x00100000
 
#define L2_BitSIZE_256KB   0x1
#define L2_BitSIZE_512KB   0x2
#define L2_BitSIZE_1MB     0x3
  
#define L2_SIZE_SHF                        28
#define L2_SIZE_MSK                       0x3
#define L2_CLK_RATIO_SHF                   25
#define L2_CLK_RATIO_MSK                  0x7
#define L2_INVALIDATE_IN_PROGRESS  0x00000001
#define L2_INVALIDATE              0x00200000
#define L2_ENABLE                  0x80000000


/*******************************\
* Defines for PPC Configuration *
* register.                     *
\*******************************/
#define PPC_CFG_SDRAM_SIZE_MSK                 0x0000000f
#define PPC_CFG_SDRAM_SIZE_SHF                 0 
#define PPC_CFG_SDRAM_PAGE_SIZE_MSK            0x00000010 
#define PPC_CFG_SDRAM_PAGE_SIZE_SHF            4
#define PPC_CFG_SRAM_SIZE_MSK                  0x00000f00
#define PPC_CFG_SRAM_SIZE_SHF                  8
#define PPC_CFG_IO_MEM_SIZE_MSK                0x0000f000
#define PPC_CFG_EXT_IO_MEM_SIZE_SHF            12
#define PPC_CFG_PROC_TYPE_MSK                  0x000f0000
#define PPC_CFG_PROC_TYPE_SHF                  16
#define PPC_CFG_REV_LEVEL_MSK                  0x00f00000
#define PPC_CFG_REV_LEVEL_SHF                  20
#define PPC_CFG_LAN_IF_MSK                     0x01000000
#define PPC_CFG_LAN_IF_SHF                     24
#define PPC_CFG_SWITCH_MSK                     0x1e000000
#define PPC_CFG_SWITCH_SHF                     25
#define PPC_CFG_DIAG_MSK                       0x04000000
#define PPC_CFG_BOOT_MSK                       0x02000000
#define PPC_CFG_EXT_IO_PRESENT_MSK             0x20000000
#define PPC_CFG_EXT_IO_PRESENT_SHF             29
#define PPC_CFG_FLASH_SIZE_MSK                 0xc0000000
#define PPC_CFG_FLASH_SIZE_SHF                30 
#define IS_ASIC  (pPpcLanRegs->CFG.reg & PPC_CFG_LAN_IF_MSK)

/******************************\
* Defies for External I/O Device
\******************************/
#define EXTIO_MEM_START       0x41000000
#define EXTIO_REG_START       0x49000000

/******************************\
* Defines for Flash 
\******************************/
#define FLASH_SECTOR_SIZE  		   0x00010000
#define DUAL_SHORT_FLASH_SECTOR_SIZE 	   (2 * FLASH_SECTOR_SIZE)
#define DUAL_SHORT_FLASH_SECTOR_SIZE_8MB   (4 * FLASH_SECTOR_SIZE)
#define DUAL_SHORT_FLASH_SECTOR_SIZE_16MB  (8 * FLASH_SECTOR_SIZE)

/******************************\
* Miscellaneous defines
\******************************/
#define ONE_BYTE    1
#define TWO_BYTE    2
#define FOUR_BYTE   4
#define EIGHT_BYTE  8

#define BOOT_PARAMS_FROM_FLASH	0
#define BOOT_PARAMS_FROM_NET	1
 
#define write64(x,y)  *((double *)(x)) = y
#define write32(x,y)  *((unsigned long *)(x)) = y
#define write16(x,y)  *((unsigned short *)(x)) = y
#define write08(x,y)  *((unsigned char *)(x)) = y
#define read64(x)     *((double *)(x))
#define read32(x)     *((unsigned long *)(x))
#define read16(x)     *((unsigned short *)(x))
#define read08(x)     *((unsigned char *)(x))


#define DIAG_SYNC_HI   write32(PPC_CSR_SET, DIAGSYNC)
#define DIAG_SYNC_LO   write32(PPC_CSR_CLR, DIAGSYNC)

#define DIAG_SYNC_PULSE DIAG_SYNC_HI; DIAG_SYNC_LO

#define SET_LED_OFF    write32(PPC_CSR_SET, LED_OFF)
#define SET_LED_RED    write32(PPC_CSR_CLR, LED_RED)
#define SET_LED_GREEN  write32(PPC_CSR_CLR, LED_GREEN)
#define SET_LED_AMBER  write32(PPC_CSR_CLR, LED_AMBER)

#define RTC_INCREMENT(x)  { long i; \
                            for (i = 0; i < x; i++) \
                               write32(PPC_CSR_SET, RTINC); \
                          }


/******************************************************\
* Definitions brought over from bdmp/h/lana_device.h   *
\******************************************************/
#ifndef _ASMLANGUAGE
#ifndef LANAI_REG_DEF
#define LANAI_REG_DEF
struct LANAI_REG {
        volatile unsigned int IPF0;     /* 5 context-0 state registers */
        int pad_04;
        volatile unsigned int CUR0;
        int pad_0c;
        volatile unsigned int PREV0;
        int pad_14;
        volatile unsigned int DATA0;
        int pad_1c;
        volatile unsigned int DPF0;
        int pad_24;
 
        volatile unsigned int IPF1;     /* 5 context-1 state registers */
        int pad_2c;
        volatile unsigned int CUR1;
        int pad_34;
        volatile unsigned int PREV1;
        int pad_3c;
        volatile unsigned int DATA1;
        int pad_44;
        volatile unsigned int DPF1;
        int pad_4c;
 
        volatile unsigned int ISR;      /* interrupt status register */
        int pad_54;
        volatile unsigned int EIMR;     /* external-interrupt mask register */
        int pad_5c;
 
        volatile unsigned int IT;       /* interrupt timer */
        int pad_64;
        volatile unsigned int RTC;      /* real-time clock */
        int pad_6c;
 
        volatile unsigned int LAR;      /* EBUS-DMA LBUS address */
        int pad_74;
        volatile unsigned int CTR;      /* EBUS-DMA counter */
        int pad_7c;
 
        volatile unsigned int L2E_LAR;  /* L->E DMA LBUS address */
        int pad_84;
        volatile unsigned int E2L_LAR;  /* E->L DMA LBUS address */
        int pad_8c;
 
        volatile unsigned int L2E_EAR;  /* L->E DMA EBUS address */
        int pad_94;
        volatile unsigned int E2L_EAR;  /* E->L DMA EBUS address */
        int pad_9c;
 
        volatile unsigned int L2E_CTR;  /* initiate L->E DMA */
        int pad_a4;
        volatile unsigned int E2L_CTR;  /* initiate E->L DMA */
 
        unsigned int pad_A[(0xcc - 0xa8) / sizeof(int)];
 
        volatile unsigned int RMW;      /* receive-DMA header */
        int pad_d4;
        volatile unsigned int RMC;      /* receive-DMA header CRC */
        int pad_dc;
 
        volatile unsigned int RMP;      /* receive-DMA buffer */
        int pad_e4;
        volatile unsigned int RML;      /* initiate receive DMA */
        int pad_ec;
 
        volatile unsigned int SMP;      /* send-DMA buffer */
        int pad_f4;
        volatile unsigned int SMH;      /* send-DMA packet routing header */
        int pad_fc;
 
        volatile unsigned int SML;      /* initiate send DMA */
        int pad_104;
        volatile unsigned int SMLT;     /* initiate send DMA */
        int pad_10c;
 
        volatile unsigned int SMC;      /* send-DMA header CRC */
        int pad_114;
        volatile unsigned int SA;       /* send alignment */
        int pad_11c;
 
        volatile unsigned int BURST;    /* EBUS-DMA configuration */
        int pad_124;
        volatile unsigned int TIMEOUT;  /* NRES-timeout selection */
        int pad_12c;
 
        volatile unsigned int MYRINET;  /* Myrinet-link configuration */
        int pad_134;
        volatile unsigned int DEBUG;    /* internal-timing observation */
        int pad_13c;
 
        volatile unsigned int LED;      /* LED output pin (To HRSET in CSR) */
        int pad_144;
        volatile unsigned int VERSION;  /* configuration of Myrinet-link IF */
        int pad_14c;
 
        volatile unsigned int WRITE_ENABLE;     /* memory protection */
 
        unsigned int pad_B[(0x1f4 - 0x150) / sizeof(int)];
 
        volatile unsigned int clock_val;  /* clock register at offset 0x1f8 */
 
};
#endif
#endif /* end of ASMLANGUAGE */

#endif  /* INC_BOARDCSR */
