/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

/**********************************************************************
 * This file architecture-specific types and macros needed by gm_impl.h
 **********************************************************************/

#include "gm_internal.h"

#ifndef _KERNEL
#define SUNDDI
#define KERNEL
#define _KERNEL
#endif

#include <assert.h>
#include <sys/cred.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/open.h>
#include <sys/cred.h>
#include <sys/modctl.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <sys/ksynch.h>
#include <sys/debug.h>
#include <sys/ddidmareq.h>
/* #include <unistd.h> redefines sleep erroneously */
/* Must include these 2 files as last system includes. */
#include <sys/ddi.h>
#include <sys/sunddi.h>

#include "gm_internal.h"
#include "gm_config.h"
#include "gm_types.h"
#include "gm_io.h"
#include "gm_lanai.h"

				/* Values of flags passed to
                                   dma_region_alloc() to indicate the
                                   type of receive buffer to allocate */
#define GM_ARCH_DMA_READ	DDI_DMA_READ
#define GM_ARCH_DMA_WRITE	DDI_DMA_WRITE
#define GM_ARCH_DMA_CONSISTENT  DDI_DMA_CONSISTENT
#define GM_ARCH_DMA_STREAMING   DDI_DMA_STREAMING
#define GM_ARCH_DMA_CONTIGUOUS	0
#define GM_ARCH_DMA_RDWR	(DDI_DMA_READ | DDI_DMA_WRITE)


				/* Return values for gm_intr() to
                                   indicate whether the interrupt was
                                   claimed. */
#define GM_ARCH_INTR_CLAIMED	DDI_INTR_CLAIMED
#define GM_ARCH_INTR_UNCLAIMED	DDI_INTR_UNCLAIMED

				/* command passed to
                                   gm_sync_dma_region() to indicate
                                   the direction of the sync. */
#define GM_ARCH_SYNC_FOR_DEVICE	DDI_DMA_SYNC_FORDEV
#define GM_ARCH_SYNC_FOR_CPU	DDI_DMA_SYNC_FORCPU

#define GM_SLEEP_WOKE 0
#define GM_SLEEP_TIMED_OUT (-1)
#define GM_SLEEP_INTERRUPTED 1

/************
 * Error notification values, used as return values for most driver functions.
 ************/
  
#if 0
#define GM_EACCES		EACCES
#define GM_EBUSY		EBUSY
#define GM_EFAULT       	EFAULT
#define GM_EINTR		EINTR
#define GM_EINVAL		EINVAL
#define GM_ENOMEM		ENOMEM
#define GM_ENOTTY		ENOTTY
#define GM_EPERM		EPERM
#define GM_EPROTO		EPROTO
#define GM_EUNATCH		EUNATCH
#endif
     
/* Architecture-specific type for the "arch" field of the gm_intance_state_t
   data structure. */

typedef struct gm_arch_sync
{
  /* mutex, which will eventually be separated out */
  kmutex_t mu;

  /* fields used to implement a semaphore */
  int wake_cnt;
  kmutex_t _mu;
  kcondvar_t cv;
} gm_arch_sync_t;
 
typedef struct gm_arch_dma_region
{
  ddi_dma_handle_t dma_handle;
  ddi_acc_handle_t acc_handle;
  ddi_dma_cookie_t cookie;
  unsigned int cookie_cnt;
  void *addr;
  void *alloc_addr;
  unsigned len;
  unsigned int sts;
} gm_arch_dma_region_t;

typedef struct gm_arch_instance_info  
{
  dev_info_t *dip;		/* Pointer to DDI/DDK device info */
  dev_t dev;
  ddi_acc_handle_t pci_acc_handle; /* for accessing PCI configuration space. */
  ddi_acc_handle_t acc_handle;	/* For unmapping the board. */
  /* interrupt state */
  ddi_iblock_cookie_t iblock_cookie;
  ddi_idevice_cookie_t idevice_cookie;
#if GM_SOLARIS_COMPLICATED_SPIN
  gm_arch_sync_t spin_sync;
#endif
  int reg_set;			/* The register set used to map the board. */
  char reg_set_cached;		/* boolean indicating if reg_set is cached */
  char board_span_cached;	/* boolean indicating if board_span cached */
} gm_arch_instance_info_t;

typedef struct gm_arch_port_info
{
#if GM_COPYX_MODE_REQUIRED
  int mode;
#endif
  int ddi_copyxx_context;
} gm_arch_port_info_t;

#if GM_CAN_REGISTER_MEMORY
typedef struct 
{
  struct buf *buf;
  ddi_dma_handle_t dma_handle;
  ddi_dma_cookie_t dma_cookie;
} gm_arch_page_lock_t;
#else
typedef char gm_arch_page_lock_t;
#endif

typedef minor_t gm_arch_minor_t;

typedef int gm_arch_ioctl_context_t;

/************
 * Debugging output macros
 ************/

#ifdef __GNUC__
#define GM_ERR(level, type, args...)  do { \
  if (level<=PRINT_LEVEL) cmn_err ((type), "gm: " args); \
} while (0)
#endif

#endif /* _gm_solaris_h_ */

