/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_solaris_h_
#define _gm_solaris_h_

/**********************************************************************
 * This file architecture-specific marcros and inline functions
 * required by gm.c and gm_arch.c. See gm_arch_types.h for typedefs.
 **********************************************************************/

/************************************************************************
 * Items in this section are not required by gm.c, but needed by the
 * implementations of the functions required by gm.c.
 ************************************************************************/

/************
 * Debugging output macros
 ************/

/* These are here so that asserts in gm_internal.h will get properly defined */


void gm_solaris_print (char *format, ...);
void gm_solaris_info (char *format, ...);
void gm_solaris_warn  (char *format, ...);
void gm_solaris_panic (char *format, ...);
void gm_solaris_note  (char *format, ...);

#define GM_ARCH_PRINT(args) gm_solaris_print args
#define GM_ARCH_INFO(args) gm_solaris_info args
#define GM_ARCH_NOTE(args) gm_solaris_note args
#define GM_ARCH_WARN(args) gm_solaris_warn args
#define GM_ARCH_PANIC(args) gm_solaris_panic args


#include "gm_internal.h"
#include "gm_arch_types.h"
#include "gm_impl.h"
#include "gm_lanai.h"

#include <assert.h>
#include <sys/cred.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/open.h>
#include <sys/cred.h>
#include <sys/modctl.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <sys/ksynch.h>
#include <sys/debug.h>
#include <sys/ddidmareq.h>
#include <sys/kmem.h>

/* #include <unistd.h> redefines sleep erroneously */

/* Must include these 2 files as last system includes. */

#include <sys/ddi.h>
#include <sys/sunddi.h>

#if GM_BC_DRIVER
#define GM_BC_PAGE_LEN 8192
#endif

/* 1K pages = 4MB */
/* Keep this low until Sun fixes DDI_DMA_REGION_ALLOC. */
#define GM_MAX_BUFFER_PAGES (1*1024)

extern void *gm_instancep;
extern void *gm_minorp;

extern unsigned gm_control_program_4k_length;
extern unsigned gm_control_program_8k_length;
extern char gm_control_program_4k[];
extern char gm_control_program_8k[];


#endif /* _gm_solaris_h_ */
