/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/*
  gd.h
  header file for gm ifnet driver for digital unix
  finucane@myri.com
*/

#ifndef gd_h
#define gd_h

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/map.h>
#include <sys/buf.h>
#include <sys/vm.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/kernel.h>
#include <sys/devio.h>
#include <hal/cpuconf.h>
#include <sys/exec.h>
#include <io/common/devdriver.h>
#include <sys/sysconfig.h>
#include <kern/kalloc.h>
#include <sys/mman.h>
#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/if_ether.h>
#include <net/ether_driver.h>
#include <sys/mbuf.h>

#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_ether.h"
#include "gm_debug_lanai_dma.h"
#include "gm_arch_def.h"
  

#define GD_SLOP 16
#define GD_GRAIN 8
#define GD_BUFFER_SIZE (GM_ETHERNET_MTU + GD_SLOP)
#define GD_NUM_SEND_BUFFERS (GM_NUM_SEND_TOKENS * 2)
#define GD_NUM_RECEIVE_BUFFERS (GM_NUM_ETHERNET_RECV_TOKENS * 2)
#define GD_MIN_RECEIVE_BUFFERS 3
#define GD_MIN_GATHER_LENGTH 0
#define GD_ROUND_POINTER(p)(char*)(((((unsigned long long)(p)) + (GD_GRAIN - 1)) & ~(GD_GRAIN - 1)))
#define GD_ROUND_INT(p)(long int)(((((unsigned long)(p)) + (GD_GRAIN - 1)) & ~(GD_GRAIN - 1)))
#define GD_ALIGNED(p)(!((p) & GD_GRAIN - 1))
#define GD_NAME "myri"
#define GD_NAME_LEN 71
#define GD_MAX_DEVICES 16

#define GD_DMA_DIRECT_MAP_MASK  0x40000000UL
#define GD_VTOP(va) (char*)(GD_DMA_DIRECT_MAP_MASK | vtop (0, (va)))

struct gd_Device;

typedef struct gd_Item
{
  struct gd_Item*next;
  struct gd_Device*device;
  int osize;
  int size;
  struct mbuf*m;
  char*ma;
  char*va;
  char*pa;

  dma_handle_t dmaHandle;
  dma_handle_t pieces [GM_MAX_ETHERNET_GATHER_CNT];
  int numPieces;
}gd_Item;

typedef struct gd_Queue
{
  int size;
  gd_Item*head;
  gd_Item*tail;
}gd_Queue;

typedef struct gd_Device
{
  struct ether_driver ed;
  simple_lock_data_t lock;
  
#define gd_ac ed.ess_ac
#define gd_ctrblk ed.ess_ctrblk
#define gd_ztime ed.ess_ztime
#define gd_if gd_ac.ac_if
#define gd_ztime ed.ess_ztime
#define gd_address gd_ac.ac_enaddr

  struct gm_port*port;
  char address [6];
  char name [GD_NAME_LEN];
  int unit;
  int forceAlignment;
  int useDmaMap;
  int opened;
  
  gd_Queue freeSends;
  gd_Queue freeReceives;
  gd_Queue pendingSends;
  gd_Queue pendingReceives;
  struct controller *_controller;
}gd_Device;


int gd_isEmpty (gd_Queue*q);
int gd_put (gd_Queue*q, gd_Item*p);
gd_Item*gd_get (gd_Queue*q);
gd_Item*gd_newItem ();
void gd_freeItem (gd_Item*p);
gd_Item*gd_newBufferItem (gd_Device*d, int size);
void gd_freeBufferItem (gd_Item*p);
int gd_feedGm (gd_Device*d);
void gd_reclaimReceiveMbufItem (caddr_t address, u_long length, caddr_t argument);
gd_Item*gd_newMbufItem (gd_Device*d, gd_Item*p);
gd_Device*gd_newDevice (struct controller*_controller);
void gd_freeDevice (gd_Device*d);
int gd_attach (int unit);
int gd_detach (int unit);
int gd_send (gd_Device*d, struct mbuf*m);
void gd_receiveDone (void *ptr, unsigned length, gm_u16_t csum);
void gd_sendDone (void *ptr);
int gd_open (gd_Device*d);
int gd_close (gd_Device*d);

#endif /*gd_h*/


