/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

/**********************************************************************
 * This file architecture-specific types and macros needed by gm_impl.h
 **********************************************************************/

#include "gm_internal.h"

#ifndef _KERNEL
#define KERNEL
#define _KERNEL
#endif


#include "kern/assert.h"

/***************************************************
 * Common driver header files                      *
 ***************************************************/
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/map.h>
#include <sys/buf.h>
#include <sys/vm.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/kernel.h>
#include <sys/devio.h>
#include <hal/cpuconf.h>
#include <sys/exec.h>
#include <io/common/devdriver.h>
#include <sys/sysconfig.h>
#include <kern/kalloc.h>
#include <sys/mman.h>
/*****************************
  network driver includes
 ******************************/
#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/if_ether.h>
#include <net/ether_driver.h>


#include <sys/mbuf.h>
#include <io/dec/pci/pci.h>
#include <machine/cpu.h>

#include "gm_config.h"
#include "gm_types.h"
#include "gm_io.h"
#include "gm_lanai.h"

#define GM_SLEEP_WOKE 0

#define GM_SLEEP_INTERRUPTED 1


/* Architecture-specific type for the "arch" field of the gm_intance_state_t
   data structure. */


typedef struct gm_arch_sync {
	/* mutex, which will eventually be separated out */
	lock_data_t mu;

	/* fields used to implement a semaphore */
	int wake_cnt;
	simple_lock_data_t _mu;
	short cv;
	int s;						/* for spl */
	int count;
} gm_arch_sync_t;

typedef struct gm_arch_dma_region {
	dma_handle_t dma_handle;
	sg_entry_t sge;
	gm_u32_t sge_cnt;			/* # of sge's */
	void *addr;
	void *alloc_addr;
	unsigned int len;
	unsigned int rlen;
	unsigned int sts;
} gm_arch_dma_region_t;

typedef struct gm_arch_instance_info {
	dev_t dev;

	int id;
	io_handle_t csr_base;
	struct pci_config_hdr *pci_cfg_hdr;
	struct controller *ctlr;

	int is_open;				/* count of outstanding opens */

	/* note: driver doesn't attempt to map into sparse space. if it
	 * can't get dense space at open time, the open fails. this should
	 * be fixed because some alphas can't map the myrinet board into
	 * dense space. can't fix it now because the myrinet software
	 * doesn't know how to use sparse addressing.  */

	int is_dense;				/* if true means driver has mapped the board into dense space */

	/*
	 * Baggage from /dev/none example
	 */

	int sc_openf;				/* Open flag */
	int has_half_opened;
	int sc_count;				/* Count of characters written to device */
	int sc_state;				/* Device state, not currently used */

	/* Interrupt handler ID */

	ihandler_t gm_ihandle;
	ihandler_id_t *hid;
	char myri_addr8[8];			/* full myrinet address */
	unsigned short revision;	/* PCI board revision number */
	gm_arch_sync_t mutex;
} gm_arch_instance_info_t;

typedef struct gm_arch_port_info {
#if GM_COPYX_MODE_REQUIRED
	int mode;
#endif
	int ref_count;
	int ddi_copyxx_context;
} gm_arch_port_info_t;

#if GM_CAN_REGISTER_MEMORY
typedef struct {
	dma_handle_t dma_handle;
} gm_arch_page_lock_t;
#else
typedef char gm_arch_page_lock_t;
#endif

typedef minor_t gm_arch_minor_t;

typedef int gm_arch_ioctl_context_t;

/************
 * Debugging output macros
 ************/

#define GM_ERR(level, args)  do { \
  if (level<=PRINT_LEVEL)  printf args \
} while (0)

#endif							/* _gm_arch_types_h_ */
