/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1998 by Myricom, Inc.                                   *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#if defined HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if defined HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

#include <sys/ioctl.h>


/* #define _IOWR(g,n,t)    _IOC(IOC_INOUT, (g), (n), sizeof(t)) */
/* hmmm largest transfer we can do is 2^^13 */
/* see definition of _IOCPARM_MASK in /usr/include/sys/ioctl.h */

#if 1

/* #define GM_IO(n)	((unsigned int)(_IOC(IOC_INOUT, ('G'), (n), (1<<12)))) */

#define GM_IO(n)	((unsigned int)(_IOWR('G', n, unsigned int)))


#define GM_SET_FLAGS                 GM_IO ( 0)
#define GM_GET_RQST                  GM_IO ( 1)
#define GM_ACCESS_GRANTED            GM_IO ( 2)
#define GM_SLEEP                     GM_IO ( 3)
#define GM_GET_MAPPING_SPECS         ((unsigned int)(_IOWR('G', 4, gm_mapping_specs_t)))
#define GM_GET_LANAI_GLOBALS_PTR     GM_IO ( 5)
#define GM_GET_NODE_ID               ((unsigned int)(_IOWR('G', 6, unsigned)))
#define GM_RECV_QUEUE_UPDATE         GM_IO ( 7)
#define GM_MMAP                      GM_IO ( 8)
#define GM_MAP_CONTROL               GM_IO ( 9)
#define GM_MAP_SPECIAL               GM_IO (10)
#define GM_ENABLE_RAW_RECEIVES       ((unsigned int)(_IO('G', 11)))
#define GM_SET_ROUTE                 ((unsigned int)(_IOWR('G', 12, gm_route_info_t)))
#define GM_GET_UNIQUE_BOARD_ID       ((unsigned int)(_IOC(IOC_INOUT, 'G', 13, 6)))
#define GM_SET_NODE_ID               ((unsigned int)(_IOWR('G', 14, unsigned)))
#define GM_SET_ACCEPTABLE_SIZES_LOW  ((unsigned int)(_IOWR('G', 15, gm_u32_t)))
#define GM_SET_ACCEPTABLE_SIZES_HIGH ((unsigned int)(_IOWR('G', 16, gm_u32_t)))
#define GM_GET_PAGE_LEN		     ((unsigned int)(_IOWR('G', 17, unsigned)))
#define GM_REGISTER_MEMORY	     GM_IO(18)
#define GM_DEREGISTER_MEMORY         GM_IO(19)
#define GM_GET_EEPROM		     ((unsigned int)(_IOC(IOC_INOUT, 'G', 20, 128)))
#define GM_GET_MAX_NODE_ID	     ((unsigned int)(_IOWR('G', 21, unsigned)))
#define GM_SET_MAPPER_LEVEL	     ((unsigned int)(_IOWR('G', 22, gm_s32_t)))
#define GM_NODE_ID_TO_UNIQUE_ID	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 23, 8)))
#define GM_UNIQUE_ID_TO_NODE_ID	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 24, 8)))
#define GM_SET_HOST_NAME	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 25, GM_MAX_HOST_NAME_LEN)))
#define GM_GET_HOST_NAME	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 26, GM_MAX_HOST_NAME_LEN)))
#define GM_HOST_NAME_TO_NODE_ID	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 27, GM_MAX_HOST_NAME_LEN)))
#define GM_NODE_ID_TO_HOST_NAME	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 28, GM_MAX_HOST_NAME_LEN)))
#define GM_SET_UNIQUE_ID	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 29, 14)))
#define GM_GET_ROUTE                 ((unsigned int)(_IOWR('G', 30, gm_route_info_t)))
#define GM_SET_PORT_NUM		     ((unsigned int)(_IOWR('G', 31, unsigned)))
#define GM_SET_REGISTER_MEMORY_LENGTH ((unsigned int)(_IOWR('G', 32, gm_u32_t)))
#define GM_CLEAR_ALL_ROUTES	     ((unsigned int)(_IOWR('G', 35, unsigned int)))
#define GM_GET_KERNEL_BUILD_ID_LEN   ((unsigned int)(_IOWR('G', 36, int)))
#define GM_GET_KERNEL_BUILD_ID       ((unsigned int)(_IOC(IOC_INOUT, 'G', 37, GM_MAX_KERNEL_BUILD_ID_LEN)))
#define GM_GET_GLOBALS		     ((unsigned int)(_IOC(IOC_INOUT, 'G', 38, 8191)))
#define GM_GET_MAX_NODE_ID_INUSE     ((unsigned int)(_IOWR('G', 39, unsigned)))
#define GM_FINISH_MMAP		     ((unsigned int)(_IOWR('G', 40, struct gm_off_len_uvma)))
#define GM_GET_GLOBALS_OFFSET        ((unsigned int)(_IOWR('G', 41, gm_u32_t)))
#define GM_GET_DEV                   ((unsigned int)(_IOWR('G', 42, unsigned)))
#define GM_GET_MAPPER_UNIQUE_ID	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 43, 8)))
#define GM_LINUX_DEBUG_MODULE        GM_IO (44)
#define GM_GET_KTRACE                GM_IO (45)
#define GM_GET_OPENER_PIDS	     ((unsigned int)(_IOC(IOC_INOUT, 'G', 46, GM_NUM_PORTS*sizeof(gm_u32_t))))
#define GM_SET_OPENER_PID            ((unsigned int)(_IOWR('G', 47, gm_u32_t)))
#define GM_REGISTER_MEMORY_BY_STRUCT ((unsigned int)(_IOWR('G', 48, struct gm_off_len_uvma)))
#define GM_DEREGISTER_MEMORY_BY_STRUCT ((unsigned int)(_IOWR('G', 49, struct gm_off_len_uvma)))
#define GM_SET_NODE_TYPE ((unsigned int)(_IOWR('G', 50, gm_u32_t)))
#define GM_GET_NODE_TYPE ((unsigned int)(_IOWR('G', 51, gm_u32_t)))
#define GM_GET_FIRMWARE_STRING ((unsigned int)(_IOC(IOC_INOUT, 'G', 52, GM_MAX_FIRMWARE_STRING_LEN)))
#define GM_COP_WAKEUP                ((unsigned int)(_IOWR('G', 53, unsigned int)))
#define GM_COP_SEND                  ((unsigned int)(_IOWR('G', 54, unsigned int)))
#define GM_COP_RECEIVE               ((unsigned int)(_IOWR('G', 55, unsigned int)))
#define GM_COP_END                   ((unsigned int)(_IOWR('G', 56, unsigned int)))
#define GM_DIRECTCOPY_GET            ((unsigned int)(_IOWR('G', 57, gm_directcopy_t)))
#define GM_GET_GLOBALS_BY_REQUEST    ((unsigned int)(_IOWR('G', 58, struct gm_globals_request)))
#define GM_WRITE_LANAI_REGISTER	     ((unsigned int)(_IOWR('G', 59, gm_lanai_register_access_t)))
#define GM_GET_PAGE_HASH_CACHE_SIZE  ((unsigned int)(_IOWR('G', 60, unsigned int)))
#define GM_SET_ENABLE_NACK_DOWN      ((unsigned int)(_IOWR('G', 61, unsigned int)))

#else
#define GM_IO(n)        _IO('G',(n))
#endif

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
