#ifndef _gmm_h_
#define _gmm_h_

#define GMM_EMULATE_BYTE_DMAS 1

#include "gm_internal.h"
#include "cheat.h"
#include "gm_ether.h"

#define GM_MINIPORT_MAJOR_VERSION 4
#define GM_MINIPORT_MINOR_VERSION 0

#define GMM_NUM_SEND_BUFFERS 10
#define GMM_NUM_RECEIVE_BUFFERS 10
#define GMM_NUM_RECEIVE_BUFFERS_THRESHOLD ((GMM_NUM_RECEIVE_BUFFERS*3)/4)

/*for pools*/
#define GMM_MAX_NDIS_PACKETS (GMM_NUM_RECEIVE_BUFFERS + GMM_NUM_SEND_BUFFERS)
#define GMM_MAX_NDIS_BUFFERS GMM_MAX_NDIS_PACKETS

#define GMM_MAX_PACKETS_PER_SEND GMM_NUM_SEND_BUFFERS /*per send*/

#define GMM_ETHERNET_HEADER_SIZE 14
#define GMM_HEADER_SIZE 2
#define GMM_SLOP (GMM_HEADER_SIZE + GMM_ETHERNET_HEADER_SIZE + 40)

/*#define GMM_MTU 1514*/
#define GMM_MTU (GM_IP_MTU+GMM_SLOP)


#define GMM_VENDOR_DESCRIPTION "GM Miniport"
#define GMM_DRIVER_VERSION 1
#define GMM_WATCHDOG_SECONDS 0
#define GMM_MAX_MULTICAST_ADDRESSES 32 /*0*/ /*todo*/
#define GMM_PORT_NAME "GM Miniport"
#define GMM_MAX_RECEIVES_PER_INTERRUPT GMM_NUM_RECEIVE_BUFFERS

#define GMM_NUM_MAP_REGISTERS (GMM_NUM_SEND_BUFFERS * GM_MAX_ETHERNET_GATHER_CNT)
#define GMM_MAX_BYTES_PER_DMA 4096
#define GMM_SMALLEST_GATHER 128
#define GMM_POLL_MILLISECONDS 5000

typedef struct gmm_Buffer
{
  struct gmm_Buffer*next;

  PNDIS_BUFFER ndisBuffer;
  
  NDIS_PACKET*ntPacket;
  NDIS_PACKET*myPacket;

  char*virtualAddress;
  NDIS_PHYSICAL_ADDRESS physicalAddress;
  ULONG originalLength;
  ULONG length;
  struct gm_port *port;


  ULONG mapRegister;
  unsigned int numNtBuffers; 
  PNDIS_BUFFER ntBuffers[GM_MAX_ETHERNET_GATHER_CNT];
  
}gmm_Buffer;

typedef struct gmm_Queue
{
  gmm_Buffer*head;
  gmm_Buffer*tail;
}gmm_Queue;

typedef struct gmm_Context
{
  NDIS_HANDLE miniportAdapterHandle;
  struct gm_port*port;
  ULONG cacheFillSize;
  NDIS_HANDLE bufferPoolHandle;
  NDIS_HANDLE packetPoolHandle;
  //  NDIS_MINIPORT_TIMER timer;
  
  int flushingSendQueue;
  
  NDIS_SPIN_LOCK receiveQueueSpinLock;
  NDIS_MINIPORT_INTERRUPT interrupt;
  
  gmm_Queue sendFreeQueue;
  gmm_Queue sendPendQueue;
  gmm_Queue sendDoneQueue;

  gmm_Queue receiveFreeQueue;
  gmm_Queue receivePendQueue;
  gmm_Queue receiveDoneQueue;

  int numNdisReceives;

  PNDIS_PACKET firstTxQueue;
  PNDIS_PACKET lastTxQueue;
  UINT numPacketsQueued;

  int sends;
  int receives;
  
  ULONG gmm_numGoodSends;
  ULONG gmm_numGoodReceives;
  ULONG gmm_numBadSends;
  ULONG gmm_numBadReceives;
  ULONG gmm_numNoBuffers;
  ULONG gmm_numBadReceiveAlignments;
  
}gmm_Context;

typedef struct _GMM_RESERVED {
    PNDIS_PACKET next;
} GMM_RESERVED,*PGMM_RESERVED;

#define PGMM_RESERVED_FROM_PACKET(_packet) \
    ((PGMM_RESERVED)((_packet)->MiniportReserved))

#define ENQUEUE_PACKET(_head, _tail, _packet)          \
{                                                      \
  if (!_head)                                          \
  {                                                    \
    _head = _packet;                                   \
  }                                                    \
  else                                                 \
  {                                                    \
    PGMM_RESERVED_FROM_PACKET(_tail)->next = _packet;  \
  }                                                    \
  PGMM_RESERVED_FROM_PACKET(_packet)->next = NULL;     \
  _tail = _packet;                                     \
}

#define DEQUEUE_PACKET(head, tail)                     \
{                                                      \
  PGMM_RESERVED reserved =                             \
    PGMM_RESERVED_FROM_PACKET(head);                   \
  if (!reserved->next)                                 \
  {                                                    \
    tail = NULL;                                       \
  }                                                    \
  head = reserved->next;                               \
}

#ifndef GM_SUCCESS
#define GM_SUCCESS 0
#endif

NDIS_STATUS gmm_SetInformation (NDIS_HANDLE miniportAdapterContext,
				NDIS_OID oid,
				PVOID informationBuffer,
				ULONG informationBufferLength,
				PULONG bytesRead,
				PULONG bytesNeeded);


NDIS_STATUS gmm_QueryInformation (NDIS_HANDLE miniportAdapterContext,
				  NDIS_OID oid,
				  PVOID informationBuffer,
				  ULONG informationBufferLength,
				  PULONG bytesWritten,
				  PULONG bytesNeeded);

BOOLEAN gmm_SendPacket (gmm_Context *context, PNDIS_PACKET packet,
			gmm_Buffer *b);

void gmm_SendPackets (NDIS_HANDLE miniportAdapterContext,
		      PPNDIS_PACKET packets,
		      UINT numPackets);


VOID gmm_ReturnPacket (NDIS_HANDLE miniportAdapterContext,
		       PNDIS_PACKET packet);



NDIS_STATUS gmm_TransferData (OUT PNDIS_PACKET packet,
			      OUT PUINT bytesTransferred,
			      IN NDIS_HANDLE miniportAdapterContext,
			      IN NDIS_HANDLE miniportReceiveContext,
			      IN UINT byteOffset,
			      IN UINT bytesToTransfer);

     
void gmm_queuePut (gmm_Queue*queue, gmm_Buffer*b);
gmm_Buffer*gmm_queueGet (gmm_Queue*queue);
int gmm_allocateQueue (gmm_Context*context, gmm_Queue*queue, int nBuffers, int size, int bufferPadding);
void gmm_freeQueue (gmm_Queue*queue);
void gmm_free (void*p, UINT size);
void*gmm_calloc (UINT size);
void gmm_receiveInterrupt (gmm_Context*context, unsigned length, gm_u16_t csum);
void gmm_sendInterrupt (gmm_Context*context);
int gmm_receiveFeedBuffers (gmm_Context*context);
void gmm_flushSendDoneQueue (gmm_Context*context);
void gmm_flushReceiveDoneQueue (gmm_Context*context);
int gmm_queueEmpty (gmm_Queue*queue);
void gmm_dumpPacket (char*p, int length);
void gmm_dumpPieces (NDIS_PACKET*packet);

#ifdef GMM_ENABLE_INSIST
#define insist(e)							\
do									\
{									\
  if (!(e))								\
    {									\
      DbgPrint ("gm_miniport: assertion failed in file %s, line %d\n",	\
		__FILE__,__LINE__);					\
      goto exception;							\
    }									\
}									\
while (0)
#else
#define insist(e) if(0) goto exception
#endif

#ifdef GMM_ENABLE_PRINT
#define GMM_PRINT(args)							\
do									\
{									\
  DbgPrint ("gm_miniport: ");				\
  DbgPrint args;							\
}									\
while (0)
#define dumpPacket(p,n) gmm_dumpPacket (p,n)
#define dumpPieces(p) gmm_dumpPieces (p)

#else
     
#define GMM_PRINT(args)
#define dumpPacket(p,n)
#define dumpPieces(p)
     
#endif
  
#define GMM_ALWAYS_PRINT(args)						\
do									\
{									\
  DbgPrint ("gm_miniport: ");						\
  DbgPrint args;							\
}									\
while (0)


#endif /*_gmm_h_*/
