#ifndef _gm_arch_types_h_		/* -*-c-*- */
#define _gm_arch_types_h_

/**********************************************************************
 * This file architecture-specific types and macros needed by gm_impl.h
 **********************************************************************/

#include "gm_internal.h"
#include "gm_lanai.h"

/* Architecture-specific type for the "arch" field of the gm_intance_state_t
   data structure. */

typedef struct gm_arch_dma_region
{
  void *orig_addr;
  void *addr;
  PHYSICAL_ADDRESS phys;
  ULONG len;
  ULONG iterator_offset;
  ULONG flags;
  struct gm_instance_state *is;
} gm_arch_dma_region_t;

typedef struct gm_arch_instance_info  
{
  gm_u64_t NdisAdapterHandleAsU64;

  PDRIVER_OBJECT	driver_object;
  
  /* board location, from scanning in DriverEntry */

  ULONG			bus_number;
  ULONG			slot_number;

  /* Device used to report resources (and used for nothing else) */

  PDEVICE_OBJECT	resource_device;

  /* interrupt resources from gm_report_resources() */

  ULONG			interrupt_level;
  ULONG			interrupt_vector;
  ULONG			interrupt_affinity;

  /* board resources from gm_report_resources() */

  PHYSICAL_ADDRESS	board_phys_addr;
  ULONG			board_phys_len;

  /* board resources from gm_report_resources() */

  ULONG			dma_channel;
  ULONG			dma_port;
  
  /* Interrupt info */

  ULONG			translated_interrupt_vector;
  KSPIN_LOCK		intr_spin_lock;
  PKINTERRUPT		intr_obj;
  KIRQL			irql;
  KAFFINITY		affinity;
  KDPC			dpc_for_isr;
  
  /* port that last asked to pause the ifc */

  struct gm_port_state	*pause_port;

  /* Utility Mdl for safely pinning single pages. */

  PMDL			utility_mdl;
  ULONG			utility_mdl_size;

  /* Table of pointer to MDL for each page of registered memory in the
     page hash table.  Each entry in this table corresponds to the bin
     with the same index in the page_hash. */

  char			hostname[GM_MAX_HOST_NAME_LEN+1];

  /* DMA Adapter object */

#if GM_OS_NT4
  PADAPTER_OBJECT	dma_adapter;
  ULONG			dma_num_map_regs;
#elif GM_OS_WIN2K
  PDEVICE_OBJECT        pdo;
  PDMA_ADAPTER          io_dma_adapter;
  ULONG                 io_dma_num_map_regs;
#else
#error unknown OS
#endif

  /* Timer object for gm_spin() */
  FAST_MUTEX		spin_fast_mutex;
  KTIMER		spin_timer;

  /* Fields for holding open the clone device */

  PFILE_OBJECT clone_device_file_ptr;

  PDEVICE_OBJECT clone_device_object_ptr;

} gm_arch_instance_info_t;

typedef struct gm_arch_port_info
{
  PDEVICE_OBJECT device_object;
  UNICODE_STRING nt_device_name;
  UNICODE_STRING win32_device_name;
  LIST_ENTRY sleep_q_root;
  LIST_ENTRY mapping_list;
  int sleep_cnt;
  int is_clone_device;
  struct gm_port_state *next_clone;
} gm_arch_port_info_t;

/************
 * GM synchronization types
 ************/

typedef struct gm_arch_sync
{
  FAST_MUTEX mu;

  KSEMAPHORE sem;
  KIRQL irql;
  LIST_ENTRY q;
} gm_arch_sync_t;

/************
 * Architecture-specific handles.
 ************/

typedef PMDL gm_arch_page_lock_t;
typedef long gm_arch_minor_t;

#endif /* _gm_solaris_h_ */
