#ifndef _gm_arch_h_		/* -*-c-*- */
#define _gm_arch_h_

/**********************************************************************
 * This file architecture-specific marcros and inline functions
 * required by gm.c and gm_arch.c. See gm_arch_types.h for typedefs.
 **********************************************************************/

/************************************************************************
 * Items in this section are not required by gm.c, but needed by the
 * implementations of the functions required by gm.c.
 ************************************************************************/

#include <ntddk.h>
#include <ndis.h>
/*
#include <osrddk.h>
*/
#include <stdarg.h>

#include "gm_impl.h"

#define PCI_SLOTS       32
#define PCI_BUSSES	256

/* Values of flags passed to dma_region_alloc() to indicate the type
   of receive buffer to allocate */

#define GM_ARCH_DMA_READ	0x1
#define GM_ARCH_DMA_WRITE	0x2
#define GM_ARCH_DMA_CONTIGUOUS	0x4
#define GM_ARCH_DMA_RDWR	(GM_ARCH_DMA_READ | GM_ARCH_DMA_WRITE)
#define GM_ARCH_DMA_CONSISTENT	0x8

/* Return values for gm_intr() to indicate whether the interrupt was
   claimed. */

#define GM_ARCH_INTR_CLAIMED	TRUE
#define GM_ARCH_INTR_UNCLAIMED	FALSE

/* command passed to gm_sync_dma_region() to indicate the direction of
   the sync. */

#define GM_ARCH_SYNC_FOR_DEVICE	0x1
#define GM_ARCH_SYNC_FOR_CPU	0x2

#if GM_BC_DRIVER
#define GM_BC_PAGE_LEN 8192
#endif

enum gm_arch_sleep_status 
{
  GM_SLEEP_WOKE, GM_SLEEP_INTERRUPTED, GM_SLEEP_TIMED_OUT
};

/************************************************************************
 * NT event logging
 ************************************************************************/

VOID gm_nt_info (char *fmt, ...);
VOID gm_nt_note (char *fmt, ...);
VOID gm_nt_warn (char *fmt, ...);
VOID gm_nt_panic (char *fmt, ...);
VOID gm_nt_info (char *fmt, ...);

/************************************************************************
 * Required inline functions/macros
 ************************************************************************/

/************
 * Debugging output macros
 ************/

#define GM_ARCH_PRINT(args) DbgPrint args

#define GM_ARCH_INFO(args) do {						\
  DbgPrint args;							\
  gm_nt_info args;							\
} while (0)

#define GM_ARCH_NOTE(args) do {						\
  DbgPrint args;							\
  gm_nt_note args;							\
} while (0)

#define GM_ARCH_WARN(args) do {						\
  DbgPrint args;							\
  gm_nt_warn args;							\
} while (0)

#define GM_ARCH_PANIC(args) do {					\
  DbgPrint args;							\
  gm_nt_panic args;							\
} while (0)

#endif /* _gm_arch_h_ */
