/*
 *	linux/mm/mlock.c
 *
 *  (C) Copyright 1995 Linus Torvalds
 *  Modifications 1998 Loic Prylli
 * this file is derived from the linux/mm/mlock.c file remove the
   newflags argument to the fixup_xxx functions make the fixup
   functions returned the vm struct to change (or NULL) instead of an
   error code
 */
#if GM_LINUX_FULL_MM
#include <linux/stat.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/shm.h>
#include <linux/errno.h>
#include <linux/mman.h>
#include <linux/string.h>
#include <linux/malloc.h>

#include <asm/segment.h>
#include <asm/system.h>
#include <asm/pgtable.h>

#include "gm_internal.h"


static inline struct vm_area_struct *mlock_fixup_all(struct vm_area_struct * vma)
{
  return vma;
}

static inline struct vm_area_struct *mlock_fixup_start(struct vm_area_struct * vma,
                                    unsigned long end)
{
	struct vm_area_struct * n;

	n = (struct vm_area_struct *) kmalloc(sizeof(struct vm_area_struct), GFP_KERNEL);
	if (!n)
		return 0;
	*n = *vma;
	vma->vm_start = end;
	n->vm_end = end;
	vma->vm_offset += vma->vm_start - n->vm_start;
	if (n->vm_inode)
		n->vm_inode->i_count++;
	if (n->vm_ops && n->vm_ops->open)
		n->vm_ops->open(n);
	gm_insert_vm_struct(gm_current->mm, n);
	return n;
}

static inline struct vm_area_struct  *mlock_fixup_end(struct vm_area_struct * vma,
	unsigned long start)
{
	struct vm_area_struct * n;

	n = (struct vm_area_struct *) kmalloc(sizeof(struct vm_area_struct), GFP_KERNEL);
	if (!n)
          return 0;
	*n = *vma;
	vma->vm_end = start;
	n->vm_start = start;
	n->vm_offset += n->vm_start - vma->vm_start;
	if (n->vm_inode)
		n->vm_inode->i_count++;
	if (n->vm_ops && n->vm_ops->open)
		n->vm_ops->open(n);
	gm_insert_vm_struct(gm_current->mm, n);
	return n;
}

static inline struct vm_area_struct *mlock_fixup_middle(struct vm_area_struct * vma,
	unsigned long start, unsigned long end)
{
	struct vm_area_struct * left, * right;

	left = (struct vm_area_struct *) kmalloc(sizeof(struct vm_area_struct), GFP_KERNEL);
	if (!left)
		return 0;
	right = (struct vm_area_struct *) kmalloc(sizeof(struct vm_area_struct), GFP_KERNEL);
	if (!right) {
		kfree(left);
		return 0;
	}
	*left = *vma;
	*right = *vma;
	left->vm_end = start;
	vma->vm_start = start;
	vma->vm_end = end;
	right->vm_start = end;
	vma->vm_offset += vma->vm_start - left->vm_start;
	right->vm_offset += right->vm_start - left->vm_start;
	if (vma->vm_inode)
		vma->vm_inode->i_count += 2;
	if (vma->vm_ops && vma->vm_ops->open) {
		vma->vm_ops->open(left);
		vma->vm_ops->open(right);
	}
	gm_insert_vm_struct(gm_current->mm, left);
	gm_insert_vm_struct(gm_current->mm, right);
	return vma;
}

struct vm_area_struct *gm_vm_fixup(struct vm_area_struct * vma, 
                                       unsigned long start, unsigned long end)
{
	struct vm_area_struct *ret;

	if (start == vma->vm_start) {
		if (end == vma->vm_end)
			ret = mlock_fixup_all(vma);
		else
			ret = mlock_fixup_start(vma, end);
	} else {
		if (end == vma->vm_end)
			ret = mlock_fixup_end(vma, start);
		else
			ret = mlock_fixup_middle(vma, start, end);
	}
	return ret;
}

#endif
