#!/usr/bin/perl

# extract from gm/include/gm_io.h the ioctls numbers for inclusion if arch/sparc64/kernel/ioctl32.h
# use with cd $HOME/GM/gm; perl -w drivers/linux/sparc32.pl < $HOME/GM/gm/include/gm_io.h > include/gm_sparc32_io.h

$line = 0;

while (<>) {
  $line++;

  if (/\#define\s+GM_IO([^_].*)$/) {
	
    $1 eq "(command) (('G' << 8) + (command))" or die "GM_IO is defined to $1\n";
    $gmioseen = 1;
  }
  if (/\#define\s+GM_IO_NEITHER(.*)$/) {
    $1 eq '(command) GM_IO (command)' or die "GM_IO is defined to $1\n";
    $gmnioseen = 1;
  }
  if (/\#ifndef GM_SET_FLAGS/) {
    $gmnioseen && $gmioseen or die "did not find GM_IO and GM_NEITHER_IO definition";
    $_ = <>;
    while (<>) {
      if (/\#endif/) {
        exit 0;
      }
      #/^\s*(\w+)\s*=\s*GM_IO(?:_NEITHER)?\s+\(\s*(\d+)\),\s*$/
       /\#define\s+(\w+)\s+GM_IO(?:_NEITHER)?\s+\(\s*(\d+)\)/ 	
        or die "unexpected line ($line):'$_'\n";
      my ($macro,$value) = ($1,$2);
    $value = (ord('G') << 8) + $value;
    print "#define $macro $value\n";
    print "case $macro:\n";
    }
  }
}

die "did not found the definitions\n";


  
  
