
#include "linux20.h"

#ifdef LINUX_20

long interruptible_sleep_on_timeout(struct wait_queue ** p, long timeout)
{
  long ret;
  current->timeout = jiffies + timeout;
  interruptible_sleep_on(p);
  ret = current->timeout - jiffies;
  current->timeout = 0;
  return ret > 0 ? ret : 0;
}

long sleep_on_timeout(struct wait_queue ** p, long timeout)
{
  unsigned long mask = current->blocked;
  current->blocked = ~0;
  timeout = interruptible_sleep_on_timeout(p,timeout);
  current->blocked = mask;
  return timeout;
}

long schedule_timeout(signed long timeout)
{
	unsigned long expire;
        long mask;

	switch (timeout)
	{
	case LONG_MAX:
		/*
		 * These two special cases are useful to be comfortable
		 * in the caller. Nothing more. We could take
		 * MAX_SCHEDULE_TIMEOUT from one of the negative value
		 * but I' d like to return a valid offset (>=0) to allow
		 * the caller to do everything it want with the retval.
		 */
		schedule();
		goto out;
	default:
		/*
		 * Another bit of PARANOID. Note that the retval will be
		 * 0 since no piece of kernel is supposed to do a check
		 * for a negative retval of schedule_timeout() (since it
		 * should never happens anyway). You just have the printk()
		 * that will tell you if something is gone wrong and where.
		 */
		if (timeout < 0)
		{
			printk(KERN_ERR "schedule_timeout: wrong timeout "
			       "value %lx from %p\n", timeout,
			       __builtin_return_address(0));
			goto out;
		}
	}

	expire = timeout + jiffies;

	current->timeout = expire;

        /* simulate the behaviour of TASK_UNINTERRUPTIBLE by manually masking the signals,
           bu set current to TASK_INTERRUPTIBLE or the timeout will be ignored */
        mask = current->blocked;

        if (current->state == TASK_UNINTERRUPTIBLE) {
          current->blocked = ~0;
          current->state = TASK_INTERRUPTIBLE;
        }

	schedule();

        current->blocked = mask;

	timeout = expire - jiffies;

 out:
	return timeout < 0 ? 0 : timeout;
}


#ifdef __i386__

#include <asm/page.h>
#include <asm/pgtable.h>

void* v22_ioremap_flags(long iobase,long size,long flags) {
  int tmp;
  void *ptr = vremap(iobase,size);
  
  if (!ptr)
    return 0;

  /* in intel 2.0 the call above is a vremap, page may be cached */
  /*we need to remap them uncached */
  if (flags) {
    tmp  = remap_page_range((long)ptr,
                            iobase,
                            size,
                            __pgprot(pgprot_val(PAGE_KERNEL)|flags));
    
    if (tmp) {
      printk(KERN_ERR "v22_ioremap:error while remapping:%d\n",tmp);
      vfree(ptr);
      return 0;
    }
  }
  printk(KERN_NOTICE "v22_ioremap:mapped PCI mem space 0x%lx at 0x%p\n",iobase,ptr);
  return ptr;
}

#endif


#if GM_SUPPORT_PCI

v22_pci_dev *
v22_pci_find_device(unsigned int vendor, unsigned int device, v22_pci_dev *from)
{
  int ret;
  unsigned char bus;
  unsigned char devfn;
  static v22_pci_dev adev[V22_MAX_FIND_DEVICE];
  static int found;
  unsigned index;

  if (!from) {
    printk(KERN_WARNING "Using 2.0 compatibility hack for pci_find_device\n");
    index = 0;
  } else
    index = from->index + 1;

  if (index < 0 || index >= V22_MAX_FIND_DEVICE ) {
    printk(KERN_ERR "error in v22_pci_find_device:from=NULL,index=%d\n",from->index);
    return 0;
  }
  ret = pcibios_find_device(vendor,device,index,&bus,&devfn);
  if (found < V22_MAX_FIND_DEVICE && ret == PCIBIOS_SUCCESSFUL) {
    int i;
    unsigned char irq;
    from = adev+found;
    found += 1;
    from->index = index;
    pcibios_read_config_byte(bus,devfn,PCI_INTERRUPT_LINE,&irq);
    from->busnum = bus;
    from->bus = &from->busnum;
    from->devfn = devfn;
    from->irq = irq;
    for (i=0;i<6;i++) {
      unsigned int base;
      int space;
      pcibios_read_config_dword(from->busnum,from->devfn,PCI_BASE_ADDRESS_0+4*i,&base);
      space = base & PCI_BASE_ADDRESS_SPACE;
      if (space) {
        from->base_address[i] = (base & PCI_BASE_ADDRESS_IO_MASK)|1;
      } else {
        int type = base & PCI_BASE_ADDRESS_MEM_TYPE_64;
#if defined __i386__ || defined __alpha__
        from->base_address[i] = base & PCI_BASE_ADDRESS_MEM_MASK;
        if (i==0) GM_PRINT (GM_PRINT_LEVEL >= 2,("set base_address[0] to 0x%lx\n",from->base_address[0]));
#else
#error do not know base_address v22 convention for your arch
#endif
        if (type) {
          from->base_address[i++] = 0;
        }
      }
    }
    return from;
  } else 
    return 0;
}

#endif /* GM_SUPPORT_PCI */

int signal_pending(struct task_struct *p)
{
  return p->signal & ~ p->blocked;
}


struct task_struct * v22_get_current(void)
{
  return current;
}

#else

#if defined __powerpc__

/* working around a bug in the powerpc ioremap implementation */
void* v22_ioremap(long physbase,long size) {
  int tmp;

  void *ptr = vmalloc(size);
  if (!ptr)
    return 0;

#if 1
  /* the ioremap will give the same address than  vmalloc, so the 
     pgdir table will have been properly initialized */
  vfree(ptr);
  return ioremap(physbase,size);
#else
  tmp  = remap_page_range((long)ptr,
			  physbase,
			  size,
			  PAGE_KERNEL_CI);
  if (tmp) {
    vfree(ptr);
    return 0;
  }
  return ptr;
#endif

}

#endif

#if LINUX_XX < 24
#if GM_SUPPORT_PCI
int pci_module_init(struct pci_driver *drv)
{
	int i = 0;
	struct v22_pci_dev *pcidev = 0;
	const struct pci_device_id *tbl;
	for (tbl = drv->id_table;tbl->vendor;tbl++) {
	  printk("searching for pcidev %x %x\n",tbl->vendor,tbl->device);
		pcidev = NULL;
		do {
			pcidev = pci_find_device(tbl->vendor, tbl->device, pcidev);
			if (pcidev && drv->probe(pcidev,drv->id_table) == 0)
				drv->devs[i++] = pcidev;
			if (i == VXX_MAX_DEV_PER_DRIVER)
				return 0;
		} while (pcidev);
	}
	return i ? 0 : -ENODEV;
}

void pci_unregister_driver(struct pci_driver *drv)
{
	struct v22_pci_dev *ppdev = 0;
	int i;
	for (i=0;i < VXX_MAX_DEV_PER_DRIVER && drv->devs[i];i++) {
		if (drv->remove)
			drv->remove(drv->devs[i]);
		drv->devs[i] = NULL;
	}
}
#endif /*GM_SUPPORT_PCI */

struct net_device * v24_dev_alloc(char *s,int *err, int num)
{
  struct device *dev = kmalloc(sizeof(*dev)+strlen(s)+2,GFP_KERNEL);
  if (!dev)
    *err = -ENOMEM;
  else {
    memset(dev,0,sizeof(*dev));
    dev->name = (char*)(dev+1);
    sprintf(dev->name,s,num);
  }
  return dev;
}

#endif

#endif
