
/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_linux_h_
#define _gm_linux_h_

/**********************************************************************
 * This file architecture-specific marcros and inline functions
 * required by gm.c and gm_arch.c. See gm_arch_types.h for typedefs.
 **********************************************************************/

/************************************************************************
 * Items in this section are not required by gm.c, but needed by the
 * implementations of the functions required by gm.c.
 ************************************************************************/

#include "gm_arch_types.h"
#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_impl.h"
#include "gm_internal.h"
#include "gm_lanai.h"

/*
 * this is hardcoded in the makefile
 */
#define GM_MAJOR 41


/* variables to tune */
#define GM_ARCH_MAX_MINOR 256
#define GM_ARCH_MAX_INSTANCE 16

#ifdef __alpha__
#define GM_BC_PAGE_LEN 8192
#elif __intel__
#define GM_BC_PAGE_LEN 4096
#endif


/* others */



extern void *gm_instancep;
extern void *gm_minorp;

extern unsigned gm_control_program_4k_length;
extern unsigned gm_control_program_8k_length;
extern char gm_control_program_4k[];
extern char gm_control_program_8k[];

/* Values of flags passed to
   dma_region_alloc() to indicate the
   type of receive buffer to allocate */

#define GM_ARCH_DMA_READ	0x10
#define GM_ARCH_DMA_WRITE	0x20
#define GM_ARCH_DMA_RDWR	(GM_ARCH_DMA_READ | GM_ARCH_DMA_WRITE)
#define GM_ARCH_DMA_CONSISTENT  0x40
#define GM_ARCH_DMA_STREAMING   0x80
#define GM_ARCH_DMA_CONTIGUOUS  0x100

#define GM_ARCH_INTR_CLAIMED         1
#define GM_ARCH_INTR_UNCLAIMED       2
#define GM_ARCH_SYNC_FOR_DEVICE      3
#define GM_ARCH_SYNC_FOR_CPU         4

#define GM_WOKE                      8
#define GM_SLEEP_TIMED_OUT           16
/* #define GM_INTERRUPTED               32 */

/************
 * Error notification values, used as return values for most driver functions.
 ************/
  
#define GM_EACCES		EACCES
#define GM_EBUSY		EBUSY
#define GM_EFAULT       	EFAULT
#define GM_EINTR		EINTR
#define GM_EINVAL		EINVAL
#define GM_ENOMEM		ENOMEM
#define GM_ENOTTY		ENOTTY
#define GM_EPERM		EPERM
#define GM_EPROTO		EPROTO
#define GM_EUNATCH		EUNATCH
     
/************
 * Debugging output macros
 ************/



void gm_linux_printk (const char *format, ...);
void gm_linux_print (const char *format, ...);
#if 0
void gm_linux_warn  (const char *format, ...);
void gm_linux_panic (const char *format, ...);
void gm_linux_note  (const char *format, ...);
#endif

#if GM_DEBUG
extern int gm_print_level;
#include "gm_debug.h"

#undef GM_PRINT_LEVEL
#define GM_PRINT_LEVEL gm_print_level
#endif

#ifndef __GNUC__
#error gcc is required for this driver
#endif

#define GM_ARCH_INFO(args) gm_linux_info args
#define GM_ARCH_NOTE(args) gm_linux_note args
#define GM_ARCH_PANIC(args) gm_linux_panic args
#define GM_ARCH_PRINT(args) gm_linux_print args
#define GM_ARCH_WARN(args) gm_linux_warn args

/* PAGE_OFFSET should be the first physical page of memory, that
   should works even if memory does not begin at physical address 0 */
#define MEM_WIN_PCI_OFFSET (gm_virt_to_bus((void*)PAGE_OFFSET))
#define GM_LINUX_PAGE_ZERO __pa((void*)PAGE_OFFSET)

#define GM_LINUX_HIGH_MEM __pa((void*)high_memory)

#if defined(__i386__) && (defined(CONFIG_BIGMEM) || defined(CONFIG_HIGHMEM))
#define GM_LINUX_HIGH_MEM_THRESHOLD 0xf0000000
#else
#define GM_LINUX_HIGH_MEM_THRESHOLD GM_LINUX_HIGH_MEM
#endif

static inline
int
gm_linux_phys_ok (unsigned long phys)
{
#if defined (__ia64__)
  /* the ia64 has a 2 gig hole in its physical memory map */
  return ( phys >= GM_LINUX_PAGE_ZERO && phys < GM_LINUX_HIGH_MEM_THRESHOLD &&
	   ( phys < 0x80000000 || phys >= 0x100000000 ));
#else
  /* Put constant int var to prevent "result of comparison is always
     1" warning */
  static unsigned long gm_linux_page_zero;
  
  gm_linux_page_zero = GM_LINUX_PAGE_ZERO;
  return phys >= gm_linux_page_zero && phys < GM_LINUX_HIGH_MEM_THRESHOLD;
#endif
}

static inline
struct page *
GM_PHYS_TO_PAGE (unsigned long phys)
{
  gm_assert (gm_linux_phys_ok (phys));
  return virt_to_page (__va (phys));
}

#if GM_LINUX_FULL_MM

struct vm_area_struct *gm_vm_fixup(struct vm_area_struct * vma, 
                                       unsigned long start, unsigned long end);

void gm_linux_unreg_page(gm_arch_page_lock_t *lock);
int gm_linux_reg_page(gm_arch_page_lock_t *lock,unsigned long addr);
extern int gm_full_mm;
#endif

#ifdef __alpha__
int gm_alpha_init(void);
#endif

/****************
 * GM_ARCH_RECV_QUEUE_UPDATE
 ****************/

/* Make sure that any DMAs into the receive queue are flushed.  That
   is, if such an event has been DMAd, then after this macro is
   invoked, then the next poll of the receive queue will see a receive
   event. */

static inline
void
_GM_ARCH_RECV_QUEUE_UPDATE (struct gm_port *p)
{
  GM_PARAMETER_MAY_BE_UNUSED (p);

#if GM_CPU_sparc64
  flush_cache_all ();
#endif
}

#endif /* _gm_linux_h_ */
