

#if GM_NEED_MODVERSIONS
#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#endif                          /*GM_NEED_MODVERSIONS */

#include <asm/hwrpb.h>

#include "gm_arch.h"

unsigned long (*gm_virt_to_bus)(void*addr);

#include <asm/io.h>

#if LINUX_XX >= 22 && !defined CONFIG_ALPHA_GENERIC
#error under Linux 2.2.x, the Alpha module should with compiled with 'Generic' headers
#endif

#include <asm/machvec.h>

#ifdef LINUX_22

#include <asm/core_pyxis.h>

static int is_pyxis;

int gm_alpha_init(void)
{
  gm_virt_to_bus = alpha_mv.mv_virt_to_bus;
  if (strcmp(alpha_mv.vector_name,"LX164") == 0 ||
      strcmp(alpha_mv.vector_name,"Miata") == 0)
      {
/*
	printk("enabling pyxis BW space\n");
*/
	is_pyxis = 1;
      }
  return 0;
}

unsigned long v22_dense_mem(unsigned long a)
{
  if (is_pyxis)
    return PYXIS_BW_MEM;
  else
    return dense_mem(a);
}


#elif defined LINUX_20

static unsigned long GM_PHYS_PCI_OFFSET;

unsigned long (*gm_virt_to_bus)(void*addr);

unsigned long v22_dense_mem(unsigned long a) {
  return GM_PHYS_PCI_OFFSET+IDENT_ADDR;
}


#define VIRT_TO_BUS(type) unsigned gm_##type##_virt_to_bus(void *addr);\
 extern unsigned long gm_##type##_pci_offset;

VIRT_TO_BUS(lca)
VIRT_TO_BUS(cia)
VIRT_TO_BUS(apecs)
VIRT_TO_BUS(pyxis)
VIRT_TO_BUS(t2v4)
VIRT_TO_BUS(t2v5)


static struct gm_alpha_archs {
	char *name;
	long type;
	long variantmask;
	long cpumask;
	unsigned long *pcioffset;
	unsigned (*virt2bus) (void *);
} axp_supported[] = {

	{
		"Avanti", ST_DEC_2100_A50, 0, 0, &gm_apecs_pci_offset, gm_apecs_virt_to_bus
	},
/* xl is a variation of the apecs, will implement it if needed */
#if 0
	{
		"Xl", ST_DEC_XL, 0, 0, &gm_xl_pci_offset, gm_xl_virt_to_bus
	},
#endif
/* how can we differentiare xlt from alcor, maybe test for EISA_bus? Or maybe it is just an alcor NT only machine? */
	{
		"Xlt", ST_DEC_ALCOR, 0x10000, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"Cabriolet", ST_DEC_EB64P, 0x4, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"EB66", ST_DEC_EB66, 0x3, 0, &gm_lca_pci_offset, gm_lca_virt_to_bus
	},
	{
		"EB66P", ST_DEC_EB66, 0x4, 0, &gm_lca_pci_offset, gm_lca_virt_to_bus
	},
	{
		"EB64P", ST_DEC_EB64P, 0, 0, &gm_apecs_pci_offset, gm_apecs_virt_to_bus
	},
	{
		"EB164", ST_DEC_EB164, 0x7, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"PC164", ST_DEC_EB164, 0xf8, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"LX164", ST_DEC_EB164, 0xf00, 0, &gm_pyxis_pci_offset, gm_pyxis_virt_to_bus
	},
	{
		"SX164", ST_DEC_EB164, 0xf000, 0, &gm_pyxis_pci_offset, gm_pyxis_virt_to_bus
	},
	{
		"NONAME", ST_DEC_AXPPCI_33, 0, 0, &gm_lca_pci_offset, gm_lca_virt_to_bus
	},
	{
		"TAKARA", ST_DEC_TAKARA, 0, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"Mikasa/ev4", ST_DEC_1000, 0, 0x26, &gm_apecs_pci_offset, gm_apecs_virt_to_bus
	},
	{
		"Mikasa/ev5", ST_DEC_1000, 0, 0x90, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"Noritake/ev4", ST_DEC_NORITAKE, 0, 0x26, &gm_apecs_pci_offset, gm_apecs_virt_to_bus
	},
	{
		"Noritake/ev5", ST_DEC_NORITAKE, 0, 0x90, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"Alcor", ST_DEC_ALCOR, 0x7, 0, &gm_cia_pci_offset, gm_cia_virt_to_bus
	},
	{
		"Miata", ST_DEC_MIATA, 0, 0, &gm_pyxis_pci_offset, gm_pyxis_virt_to_bus
	},
	{
		"Sable/ev4", ST_DEC_2100_A500, 0, 0x26, &gm_t2v4_pci_offset, gm_t2v4_virt_to_bus
	},
	{
		"Sable/ev5", ST_DEC_2100_A500, 0, 0x90, &gm_t2v5_pci_offset, gm_t2v5_virt_to_bus
	},
	{
		"Book1", ST_DEC_BURNS, 0, 0, &gm_lca_pci_offset, gm_lca_virt_to_bus
	},
	{
		"Ruffian", ST_DTI_RUFFIAN, 0, 0, &gm_pyxis_pci_offset, gm_pyxis_virt_to_bus
	},
	{
		"Platform2000", -1, 0, 0, 0, 0
	},
	{
		0,
	}
};


extern struct hwrpb_struct *hwrpb;
static void get_sysnames(long type, long variation, char **type_name, char **variation_name);

#define VARNUM(a) (((a)>> 10)& 0x3f)




int gm_alpha_init(void)
{
  struct gm_alpha_archs *a;
  struct percpu_struct *cpu = (struct percpu_struct *) ((char *) hwrpb + hwrpb->processor_offset);
  for (a = axp_supported; a->name; a++) {
    if (a->type == hwrpb->sys_type &&
        (a->variantmask == 0 ||
         (a->variantmask & (1 << (VARNUM(hwrpb->sys_variation) & 31)))) &&
        (a->cpumask == 0 || (a->cpumask & (1 << cpu->type)))) {
      GM_PHYS_PCI_OFFSET = *a->pcioffset;
      GM_INFO (("Identified your alpha arch: %s  - pci_offset = 0x%lx\n",
		a->name, GM_PHYS_PCI_OFFSET));
      gm_virt_to_bus = *a->virt2bus;
      break;
    }
  }
  if (!GM_PHYS_PCI_OFFSET || !gm_virt_to_bus) {
    char *sys_name, *sys_var;
    get_sysnames(hwrpb->sys_type, hwrpb->sys_variation,
						 &sys_name, &sys_var);
    GM_NOTE (("Sorry the module does not support your type of Alpha computer\n"
	      "    PCI_OFFSET = 0x%x  virt_to_bus = %p\n"
	      "    your hw struct is known as (%ld,%ld) = family %s, model %s\n"
	      GM_PHYS_PCI_OFFSET, gm_virt_to_bus, hwrpb->sys_type,
	      VARNUM(hwrpb->sys_variation), sys_name, sys_var));
    return 1;
  }
  return 0;
}


/* stolen from arch/alpha/setup.c */

#define N(a)	(sizeof(a)/sizeof(a[0]))

static void
get_sysnames(long type, long variation,
			 char **type_name, char **variation_name)
{
	static char *sys_unknown = "Unknown";
	static char *systype_names[] =
	{
		"0",
		"ADU", "Cobra", "Ruby", "Flamingo", "Mannequin", "Jensen",
		"Pelican", "Morgan", "Sable", "Medulla", "Noname",
		"Turbolaser", "Avanti", "14", "Alcor", "Tradewind",
		"Mikasa", "EB64", "EB66", "EB64+", "AlphaBook1",
		"Rawhide", "K2", "Lynx", "XL", "EB164", "Noritake",
		"Cortex", "29", "Miata", "XXM", "Takara", "Yukon",
		"Tsunami", "Wildfire", "CUSCO"
	};

	static char *unofficial_names[] =
	{
		"100",
		"Ruffian"
	};

	static char *eb164_names[] =
	{"EB164", "PC164", "LX164", "SX164"};
	static int eb164_indices[] =
	{0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3};

	static char *alcor_names[] =
	{"Alcor", "Maverick", "Bret"};
	static int alcor_indices[] =
	{0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2};

	static char *eb64p_names[] =
	{"EB64+", "Cabriolet", "AlphaPCI64"};
	static int eb64p_indices[] =
	{0, 0, 1.2};

	static char *eb66_names[] =
	{"EB66", "EB66+"};
	static int eb66_indices[] =
	{0, 0, 1};

	static char *rawhide_names[] =
	{"Dodge", "Wrangler", "Durango",
	 "Tincup", "DaVinci"};
	static int rawhide_indices[] =
	{0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4};

	long member;


	/* restore real CABRIO and EB66+ family names, ie EB64+ and EB66 */
	if (type < 0)
		type = -type;

	/* if not in the tables, make it UNKNOWN */
	/* else set type name to family */
	if (type < N(systype_names)) {
		*type_name = systype_names[type];
	}
	else if ((type > ST_UNOFFICIAL_BIAS) &&
			 (type - ST_UNOFFICIAL_BIAS) < N(unofficial_names)) {
		*type_name = unofficial_names[type - ST_UNOFFICIAL_BIAS];
	}
	else {
		*type_name = sys_unknown;
		*variation_name = sys_unknown;
		return;
	}

	/* set variation to "0"; if variation is zero, done */
	*variation_name = systype_names[0];
	if (variation == 0) {
		return;
	}

	member = (variation >> 10) & 0x3f;	/* member ID is a bit-field */

	switch (type) {				/* select by family */
	 default:					/* default to variation "0" ????FIXME???? */
		 break;
	 case ST_DEC_EB164:
		 if (member < N(eb164_indices))
			 *variation_name = eb164_names[eb164_indices[member]];
		 break;
	 case ST_DEC_ALCOR:
		 if (member < N(alcor_indices))
			 *variation_name = alcor_names[alcor_indices[member]];
		 break;
	 case ST_DEC_EB64P:
		 if (member < N(eb64p_indices))
			 *variation_name = eb64p_names[eb64p_indices[member]];
		 break;
	 case ST_DEC_EB66:
		 if (member < N(eb66_indices))
			 *variation_name = eb66_names[eb66_indices[member]];
		 break;
	 case ST_DEC_RAWHIDE:
		 if (member < N(rawhide_indices))
			 *variation_name = rawhide_names[rawhide_indices[member]];
		 break;
	}							/* end family switch */
	return;
}



#else

int gm_alpha_init(void)
{
  gm_virt_to_bus = virt_to_bus;
}

#endif

