/*
  $Id: gx.h,v 1.4 2000/07/10 19:08:23 maxstern Exp $

  nasty ifnet driver thing
*/

#ifndef gx_h
#define gx_h

#include "gm_internal.h"
#include "gm_ether.h"


#define GX_SLOP 16
#define GX_GRAIN 8
#define GX_BUFFER_SIZE (GM_ETHERNET_MTU + GX_SLOP)
#if maxstern
#define GX_NUM_SEND_BUFFERS    4
#define GX_NUM_RECEIVE_BUFFERS 8
#else
#define GX_NUM_SEND_BUFFERS (GM_NUM_SEND_TOKENS * 4)
#define GX_NUM_RECEIVE_BUFFERS (GM_NUM_ETHERNET_RECV_TOKENS * 4)
#endif
#define GX_MIN_RECEIVE_BUFFERS 2
#define GX_MIN_GATHER_LENGTH 0
#define GX_ROUND_POINTER(p)(char*)(((((unsigned long long)(p)) + (GX_GRAIN - 1)) & ~(GX_GRAIN - 1)))
#define GX_ROUND_INT(p)(long int)(((((unsigned long)(p)) + (GX_GRAIN - 1)) & ~(GX_GRAIN - 1)))
#define GX_ALIGNED(p)(!((p) & GX_GRAIN - 1))
#define GX_NAME "myri"
#define GX_NAME_LENGTH 71
#define GX_MAX_DEVICES 16
#define GX_LOCK  0x1000

#define GX_ETHERNET_HEADER_LENGTH (sizeof (gx_EthernetHeader))
#define GX_GM_HEADER_LENGTH 2
#define GX_HEADER_SIZE (sizeof (gx_Header))

#define GX_ALIGN(val,n) (((val)%(n))?((val)+((n)-((val)%(n)))):(val))

typedef struct arpMsg 
  {
     short         hwtype;               /* 00-01 */
     short         protocol_type;	 /* 02-03 */
     unsigned char hlen;		 /* 04    */
     unsigned char plen;		 /* 05    */
     short         operation;		 /* 06-07 */
     unsigned char sender_ha[6];	 /* 08-0d */
     unsigned char sender_ip[4];	 /* 0e-11 */
     unsigned char target_ha[6];	 /* 12-17 */
     unsigned char target_ip[4];	 /* 18-1b */
  } arpMsg_t;



typedef struct gx_Header
{
  struct ifheader _ifheader;
  short gmheader;
  struct ether_header _ether_header;
}gx_Header;

/*queues*/
typedef struct gx_Item
{
  struct gx_Item   *next;
  struct gx_Device *device;
  
  struct mbuf      *m;
  int              size;
  int              osize;
  unsigned         pgcnt;
  char             *aa;
  char             *va;
  gm_dp_t          pa;
  pciio_dmamap_t   map;
  int              refs;
}gx_Item;

typedef struct gx_Queue
{
  int     size;
  gx_Item *head;
  gx_Item *tail;
}gx_Queue;

int gx_isEmpty (gx_Queue*q);
int gx_put (gx_Queue*q, gx_Item*p);
gx_Item*gx_get (gx_Queue*q);

typedef struct gx_Device
{
  struct arpcom  _arpcom;
  vertex_hdl_t   vertex;
  
  struct gm_port *gmPort;
  char           address[6];  
  char           name[GX_NAME_LENGTH];  
  int            unit;
  unsigned int   flags;
  int            forceAlignment;
  int            opened;
  
  gx_Queue       freeSends,
                 freeReceives,
                 pendingSends,
                 pendingReceives;
}gx_Device;

/* values for gx_Device.flags: */
#define GX_DEV_A64_DMA 0x01

#define ifptogx(ifp)((gx_Device*)ifp)
#define gxtoifp(d)(&d->_arpcom.ac_if)

#if defined (INSIST)

#define gx_insist(e) do { \
                    if (!(e)) { \
                      GM_WARN (("assertion failed in file %s, line %d\n", \
                                __FILE__,__LINE__)); \
                      goto exception; \
                    } \
                  } while (0)

#else
#define gx_insist(e) do {if (0) goto exception;} while (0);

#endif




#endif /*gx_h*/
