/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/*
 $Id: gm_arch_types.h,v 1.21 2000/12/20 23:54:31 maxstern Exp $
 */

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

/**********************************************************************
 * This file defines the IRIX-specific types and macros needed by gm_impl.h
 *
 * With Glenn's concurrence, I have moved all #defines to gm_arch.h which
 * are not needed by gm_impl.h.
 *
 * NOTE: For a Table of Contents of this subdirectory, see README_TOC.
 **********************************************************************/

/************************************************************************
 * The following #include's are only those directly needed to support
 * the definitions in this header file.  For more information on this
 * practice, see "README.manifesto" in this subdirectory.
 ************************************************************************/

/*
 *                          IRIX system header files
 */
#include <assert.h>
#include <fcntl.h>

#include <ksys/ddmap.h>

#include <sys/buf.h>       /* for buf_t                               */
#include <sys/cmn_err.h>
#include <sys/conf.h>
#include <sys/cred.h>
#include <sys/debug.h>
#include <sys/file.h>
#include <sys/iobus.h>     /* needed for intr_func_t et al.           */
#include <sys/ksynch.h>
#include <sys/open.h>
#include <sys/sema.h>      /* needed for kmutex_t, kcondvar_t, etc.   */
#include <sys/stat.h>
#include <sys/types.h>     /* IRIX's declarations - basic             */

#include <sys/PCI/pciio.h> /* needed for pciio stuff                  */

#include <netinet/in.h>

/* The IRIX man page intro(D5) says this header file "must always be   */
/* the last header file included":                                     */
#include <sys/ddi.h>       /* DDI driver stuff                         */

/*
 *                          GM header files
 */
#include "gm_config.h"
#include "gm_internal.h"
#include "gm_io.h"
#include "gm_lanai.h"
#include "gm_types.h"

#ifndef _KERNEL
#define KERNEL
#define _KERNEL
#endif


/* defines needed below                                                */

/* The following define enables the use of "dead reckoning" rather than
 * repeated calls to pciio_dmamap_addr() to derive DMA addresses for pages
 * other than the first one of a given DMA area.  This has been shown to
 * work on IP27 (Origin) architecture, and necessary in that without it
 * the IRIX infrastructure issues a Kernel WARNING for each repetition of
 * the function call.
 */
#define GM_IRIX_MINIMIZE_PCIMAP_ADDR_CALLS 1

#if GM_IRIX_MINIMIZE_PCIMAP_ADDR_CALLS
#define GM_IRIX_MAKE_DMA_TEMPLATE(dma_addr) (dma_addr & 0xff80000000000000)
#endif

/* See additional related defines in gm_arch_local.h and gm_arch_io.h:       */
#define GM_IRIX_CLONE_NAME_SZ 8        /* big enough to hold "gm999999"      */
#define GM_IRIX_PCLONE_NAME_SZ 9       /* big enough to hold "gmp999999"     */
#define GM_IRIX_MAX_CLONE_NUM 999999   /* applies to CLONE and PCLONE        */


/* Architecture-specific types needed by gm_impl.h.                    */

/*
 *  gm_arch_sync_t declares the architecture-specific synchronization data
 *  structure.  It is incorporated into the structure gm_arch_instance_info_t
 *  as field 'spin_sync', and is also used directly in gm_instance_state_t and
 *  in gm_port_state_t and gm_page_hash_table_t.
 */
#define GM_IRIX_SYNC_USAGE_LEN 24

typedef struct gm_arch_sync
{
   /* simple mutex, which will eventually be separated out              */
   mutex_t  simple_mu;          /* used for simple mutual exclusion */

   /* fields used to implement a semaphore                              */
   mutex_t  outer_mu;           /* ensures only one sleeper at a time */
   mutex_t  inner_mu;           /* used to guard wake_cnt & sleeps    */
   sv_t     sv;                 /* synchronization variable           */
   int      wake_cnt;  	        /* used to handle premature wake      */

/* Following fields for debugging only                                */
   int      status;
   int      sim_mu_entry_cnt;
   int      sim_mu_exit_cnt;
   char     usage[GM_IRIX_SYNC_USAGE_LEN];
} gm_arch_sync_t;
/*  Values for status field above; used only if debugging */
#define GM_ARCH_SYNC_STATUS_INITIAL            0
#define GM_ARCH_SYNC_STATUS_ASLEEP             1
#define GM_ARCH_SYNC_STATUS_WAKED_B4_WAIT      2
#define GM_ARCH_SYNC_STATUS_WAKED_BY_SIGNAL    3
#define GM_ARCH_SYNC_STATUS_WAKED_BY_INTERRUPT 4
#define GM_ARCH_SYNC_STATUS_WAKED_BY_TIMEOUT   5

/* NOTE: When I first coded this debugger, I for some reason coded the
 *       second parameter of the MUTEX_LOCK() macro as PZERO.  However,
 *       the man page as well as the sample driver in the DDPG say that
 *       that parameter should be -1.  I have changed it as of gm-1.4pre4.
 *                                                        - Max 2000/08/29
 */
#define GM_IRIX_MUTEX_PRIO -1


/*
 *  gm_arch_dma_region_t is the architecture-specific dma-information data
 *  structure.  It is used in many places, including gm_instance_state_t,
 *  gm_port_state_t and gm_page_hash_table_t.
 */
typedef struct gm_arch_dma_region
{
   vertex_hdl_t    dma_vhdl;    /* hardware vertex handle      */
   pciio_dmamap_t  dmamap;      /* allocated map object        */
   gm_size_t       region_len;  /* allocated length            */
   unsigned        last_pg_len; /* (0<last_pg_len<=GM_PAGE_LEN) */
   gm_u32_t        alloc_flags; /* flags used when allocated   */
   paddr_t         kmem_addr;   /* kernel memory address pg 0  */
   paddr_t         phys_addr;   /* phys mem addr when alloc'd  */
   unsigned long   cur_page;    /* current page number, of     */
   unsigned long   pages;       /*   this total page count     */
   gm_dp_t         dma_addr_p0; /* dma address of page 0       */
#if GM_IRIX_MINIMIZE_PCIMAP_ADDR_CALLS
   iopaddr_t       dma_template; /* for forming DMA addresses  */
#endif
   gm_u8_t         map_active;  /* 1 ==> DMA is active for map */
   gm_u8_t         dma_asize;   /* Num. of bits in a dma_addr  */
		   /* (_NOT_ necessarily == 8*sizeof(gm_dp_t)) */
} gm_arch_dma_region_t;


/*
 *  gm_arch_instance_info_t is the per-instance architecture-specific data
 *  structure.  It is incorporated into the structure gm_instance_state_t
 *  as field 'arch'.
 *
 *  NOTE: Great care must be taken with respect to any pointer saved in this
 *        structure at <pfx>attach() time.  Many such pointers become
 *        invalid if/when the driver is reloaded.  A specific example of such
 *        an invalid pointer that we learned the hard way was a device_desc_t,
 *        which is a pointer to the IRIX kernel's device descriptor table.
 *        The pciio_piomap_t, however, seems to be safe, both empirically
 *        (it works OK in the presence of reload), and prescriptively (the
 *        example PCI driver shown in SGI's documentation saves this pointer
 *        at attach() time).
 */
typedef struct gm_arch_instance_info  
{
   int                 controller_susp,   /* controller number               */
                       controller;
   dev_t               conn_devt,         /* Old-style device id             */
                       nonpriv_devt,      /* device id for nonpriv clone     */
                       priv_devt;	  /* Device id for privileged clone  */
   vertex_hdl_t        conn,              /* Connection vertex               */
                       pci_acc_vhdl,      /* for accessing PCI & DMA space   */
                       nonpriv_vhdl,      /* for the non-privileged "clone"  */
                       priv_vhdl;	  /* for the privileged "clone"      */
   pciio_piomap_t      piomap;            /* ==> IO space map                */
   unsigned char       kernel_abi;        /* ABI code                        */
   /* interrupt state */
   pciio_intr_t        intr_obj;          /* interrupt "object"              */
   intr_func_t         ihandlr;           /* ==> Interrupt handler           */
   gm_s8_t             ehandlr_registered, /* error handler has been reg'd   */
                       interrupts_enabled, /* gm_enable_interrupts() success */
                       gm_instance_init;  /* gm_instance_init() success      */
   gm_arch_sync_t      device_lock;
   char                clone_edge_name[GM_IRIX_CLONE_NAME_SZ];
   char                p_clone_edge_name[GM_IRIX_PCLONE_NAME_SZ];
   struct gm_hash *gm_irix_page_lock_hash;
   gm_arch_sync_t *gm_irix_page_lock_hash_sync;

} gm_arch_instance_info_t;



/*
 *  gm_arch_port_info_t is the architecture-specific port information data
 *  structure.  It is incorporated into the structure gm_port_state_t as
 *  field 'arch'.
 *
 *  NOTE: The function typedefs below contain refs to "struct gm_port_state".
 *        The compiler will WARN that this declaration is not visible outside
 *        the function.  This struct is defined in gm_impl.h, which contains
 *        "#include gm_arch_types.h" at its top, so the compiler warning is
 *        unavoidable; for the same reason, the type name gm_port_state_t
 *        can't be used here either (doing so would cause a compiler ERROR).
 *
 *        Just be careful to keep the function definitions correct if this
 *        struct or the interface changes.
 */

struct gm_port_state;

typedef gm_status_t (gm_irix_u_func_t)(struct gm_port_state *);

typedef gm_status_t (gm_irix_io_func_t)
                                    (struct gm_port_state *, int, void *, int);

typedef gm_status_t (gm_irix_map_func_t)
                         (struct gm_port_state *, vhandl_t *, off_t, int, int);


typedef struct gm_arch_port_info
{
#if GM_COPYX_MODE_REQUIRED
   int                mode;
#endif
   dev_t              dev;             /* device id for this open            */
   vertex_hdl_t       vhdl;            /* vertex handle for this port        */
   int                ddi_copyxx_context;
   minor_t            irix_minor;      /* IRIX minor number for device       */
   char               is_master_pstate; /* GM_TRUE ==> this is clone master  */
   gm_irix_u_func_t   *open_func;
   gm_irix_map_func_t *mmap_func;
   gm_irix_u_func_t   *umap_func;
   gm_irix_io_func_t  *ioct_func;
   gm_irix_u_func_t   *clos_func;
   char               edge_name[GM_IRIX_EDGE_NAME_MAX_SZ+1];
} gm_arch_port_info_t;



#if GM_CAN_REGISTER_MEMORY
/*
 *  gm_irix_page_info_t contains call-specific information about
 *   "pinned" user DMA memory.
 */
typedef struct gm_irix_page_info
{
   struct gm_instance_state *is;
   gm_up_t             uva;          /* User Virtual Address        */
   pid_t               upid;	     /* User pid of locking process */
   int                 cookie;       /* Identifies the fast_dma     */
   int                 fast_flags;   /* Flags used with fast_dma    */
   paddr_t             physaddr;     /* Page physical address       */
   pciio_dmamap_t      map;          /* Allocated map object        */
   iopaddr_t           dma_addr;     /* DMA address for this page   */
   struct gm_irix_page_info *next;
   struct gm_irix_page_info *prev;
   void *              lock;
} gm_irix_page_info_t;

/*
 * data structure used by the fast_undma callback function
 * 
 */

typedef struct gm_irix_fastdma_info
{
   gm_up_t             uva;          /* User Virtual Address        */
   int                 cookie;       /* Identifies the fast_dma     */
   int                 fast_flags;   /* Flags used with fast_dma    */
} gm_irix_fastdma_info_t;

/*
 *  gm_arch_page_lock_t represents a page of "pinned" user DMA memory.
 */

#define GM_IRIX_MAX_REFCNT 1024

typedef struct 
{
   gm_irix_page_info_t *page_info;  /* ==> All info needed to unlock */

} gm_arch_page_lock_t;

#else
typedef char gm_arch_page_lock_t;
#endif



/*
 *  gm_arch_minor_t is the minor number type, used in gm_instance_state_t
 *  and gm_port_state_t.
 */
typedef minor_t gm_arch_minor_t;



/*
 *  gm_arch_ioctl_context_t is ???
 *  ////// I haven't figured this one out yet, either //////.
 */
typedef int     gm_arch_ioctl_context_t;


#endif /* _gm_arch_types_h_ */
