/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/*
 $Id: gm_arch_local.h,v 1.24 2000/12/07 22:39:54 maxstern Exp $
 */

#ifndef _gm_arch_local_h_
#define _gm_arch_local_h_


/**********************************************************************
 * This file defines the module-global macros and inline functions used
 * only within, and shared by, gm_arch.c and gm_irix.c.
 *
 * Exception:  macros whose scope is very local (used only in one function
 * or a closely-related group of functions within one source module) are
 * defined in the .c file itself, near where they are used.
 * 
 * This driver supports IRIX 6.5 *only*.  The "bible" for IRIX 6.5
 * device driver implementation is "IRIX Device Driver Programmer's
 * Guide," SGI Document Number 007-0911-110.
 *
 * NOTE: For a Table of Contents of this subdirectory, see README_TOC.
 **********************************************************************/

/************************************************************************
 * IMPORTANT NOTE regarding globally-visible ("external linkage") names:
 * 
 * By Myricom development convention, all entry names internal to the
 * GM driver, as well as those exported as part of the GM API, are
 * distinguished by the prefix "gm_".
 *
 * On the other hand, by SGI driver convention, names which specifically
 * interface each driver to the IRIX kernel have the form <pfx><fname>,
 * where <pfx> is a "driver prefix" (e.g. "scsi_") uniquely identifying
 * the driver, and <fname> is one of a predetermined set of data or
 * function names, such as "devflag" or "attach".  Each installed driver
 * declares its unique value of <pfx> to IRIX by a specification in the
 * system file /var/sysgen/master.d/<drivername>.
 * 
 * For documentation of SGI's naming conventions, see "Entry Point Naming
 * and lboot" in the section, "Summary of Driver Structure" in the
 * chapter "Structure of a Kernel-Level Driver" in the Programmer's Guide.
 * The predefined entry names are summarized alphabetically in two tables:
 * "Entry Points in Alphabetic Order" in the aforementioned chapter, and
 * "Driver Exported Names" in an appendix of the that name.
 *
 * Note that in the myrinet (pre-GM) driver which supports IRIX 6.4,
 * we used "myri_" as the driver prefix.
 *
 * With all this in mind, we approached the selection of a driver prefix
 * for the IRIX 6.5 GM driver.  We didn't want to use "gm_", mainly
 * because this would cause name clashes with exported names of the GM
 * API, such as gm_init and gm_open.  We didn't want to use "myri_",
 * because we wanted the new GM driver to be clearly distinguishable
 * from the old myrinet driver.
 *
 * For now, we have chosen "myrigm_", with the understanding that we
 * may need to revisit this question in the future.  Therefore, we are
 * using a set of macros, based on the suggestions in the "Entry Point
 * Naming and lboot" manual section mentioned above, to declare the
 * prefix and all the names derived from it.  If we decide to change
 * the prefix, only two modifications will be needed: the definition of
 * macro GM_PREFIX_NAME, and the specification in /var/sysgen/master.d/gm
 * (is "gm" the correct file name???).
 **********************************************************************/


/************************************************************************
 * The following #include's are only those directly needed to support
 * the definitions in this header file.  For more information on this
 * practice, see "README.manifesto" in this subdirectory.
 ************************************************************************/

#include <sys/types.h>     /* needed for hwgraph.h         */
#include <sys/hwgraph.h>   /* for device_info_get, etc.    */

#include "gm_cpp.h"
#include "gm_impl.h"       /* for gm_instance_state_t      */
#include "gm_debug.h"      /* for GM_STATIC                */
#include "gm_debug_instance_state.h"


/**********************************************************************
 *
 * Set this flag to 1 to enable the use of A64 DMA for A64-capable cards
 *
 **********************************************************************/

#define GM_IRIX_64BIT_DP_READY 1

/* Macro derived from the above:
 *   Returns 1 if this instance 'is' will use A64 DMA
 *   Returns 0 otherwise
 */
#if GM_IRIX_64BIT_DP_READY
#define GM_IRIX_INST_USE_A64DMA(is) (is->flags & GM_INSTANCE_64BIT_DMA_ADDR_OK)
#else
#define GM_IRIX_INST_USE_A64DMA(is) 0
#endif


/**********************************************************************
 * 
 * Set this flag to 1 to enable the use of the ifnet interface
 *
 * See also the definition of DRIVER_SRCS in make-os.in
 *
 **********************************************************************/

#define GM_IRIX_IFNET_READY 1

/**********************************************************************
 * 
 * Debugging stuff
 *
 * NOTE: Turning any of these DEBUG or DISPLAY flags on without having
 *       GM_DEBUG set is likely to cause compile-time diagnostics, and
 *       as a rule is a futile exercise.  GM_DEBUG is required to make
 *       these flags function correctly.
 *
 **********************************************************************/

/* Turn this on to cause no more than <n> instances to be initialized */
#define GM_IRIX_INSTANCE_LIMIT 0   /* (<n> == 0) ==> initialize all of them */

/* Turn this on to enable debugging of the device-hash algorithms */
#define GM_IRIX_DEBUG_DEVHASH 0

/* Turn this on to enable debugging of the device-naming algorithm */
#define GM_IRIX_DEBUG_DEVNAME 0

/* Turn this on to enable debugging of DMA maps */
#define GM_IRIX_DEBUG_DMAMAPS 0

/* Turn this on to enable ifnet debugging */
#define GM_IRIX_DEBUG_IP 0

/* Turn this on to enable "poor man's memory leak detection" */
#define GM_IRIX_DEBUG_MEMLEAKS 1

/* Turn this on to enable debugging of mem allocs and frees */
#define GM_IRIX_DEBUG_MEMORY 0

/* Turn this on to enable debugging of mutexes */
#define GM_IRIX_DEBUG_MUTEX 0

/* Turn this on to enable PIO debugging */
#define GM_IRIX_DEBUG_PIO 0

/* Turn this on to enable sync debugging */
#define GM_IRIX_DEBUG_SYNC 0

/* Turn this on to enable sleep/wake debugging */
#define GM_IRIX_DEBUG_WAKE 0

/* Turn this on to enable display of values from the config space */
#define GM_IRIX_DISPLAY_CONFIG_VALUES    0

/* Turn this on to enable display of the IRIX device descriptor */
#define GM_IRIX_DISPLAY_DEV_DESC         0

/* Turn this on to enable display of the IRIX 'devt' */
#define GM_IRIX_DISPLAY_DEVT             0

/* Turn this on to enable display of global values at startup */
#define GM_IRIX_DISPLAY_GLOBAL_PARMS     GM_DEBUG

/* Turn this on to enable display of the IRIX interrupt handle */
#define GM_IRIX_DISPLAY_INTERRUPT_HANDLE 0

/* Turn this on to enable display of the IRIX device inventory data */
#define GM_IRIX_DISPLAY_INVENTORY        0

/* Turn this on to enable display of the special SET_PORT_NUM args struct */
#define GM_IRIX_DISPLAY_SETPN_ARGS       0

/* Turn this on to enable display of the IRIX vertex handle */
#define GM_IRIX_REPORT_VHANDL            0

/* Determine whether to use the "monster debug buffer".  The reason for
 * this buffer is that there is a bug in cmn_err processing on the Octane,
 * which causes chunks of output to be lost -- it never finds its way
 * to the console.  We back up the debugging printouts by saving them in
 * the monster buffer, which is then available -- either in a crash dump
 * or in a running system -- to icrash.
 *
 * It appears that the bug referred to here affects only the Octane, and
 * not the Origin family.
 */
#ifdef IP30
/* DO THIS FOR OCTANE ONLY */
#if GM_DEBUG || (GM_PRINT_LEVEL > 0)
#define GM_IRIX_USE_MONSTER 1
#else
#define GM_IRIX_USE_MONSTER 0
#endif
#else
#define GM_IRIX_USE_MONSTER 0
#endif

#if GM_IRIX_DISPLAY_DEV_DESC
GM_STATIC void gm_irix_display_dev_desc(device_desc_t       the_desc, 
                                        gm_instance_state_t *the_is,
                                        char                *the_comment);
#endif
#if GM_IRIX_DISPLAY_CONFIG_VALUES
GM_STATIC void gm_irix_display_config_values(gm_pci_config_t *cfg_data,
                                             char            *the_comment);
GM_STATIC void gm_irix_display_config_space(gm_instance_state_t *the_is,
                                            char                *the_comment);
#endif
#if GM_DEBUG_INSTANCE_STATE
GM_STATIC void gm_irix_display_instance_values(gm_instance_state_t *the_is,
                                               char              *the_comment);
#endif
#if GM_IRIX_DISPLAY_INTERRUPT_HANDLE
GM_STATIC void gm_irix_display_interrupt_handle(pciio_intr_t the_handle,
                                                char         *the_comment);
#endif
#if GM_IRIX_DISPLAY_DEVT
GM_STATIC void gm_irix_parse_devt(dev_t the_devt);
#endif
#if GM_IRIX_DISPLAY_INVENTORY
GM_STATIC void gm_irix_displ_invent(dev_t the_devt, char *the_comment);
#endif
#if GM_IRIX_DISPLAY_SETPN_ARGS
GM_STATIC void gm_irix_display_setpn_args(gm_irix_set_port_num_arg_t *the_args,
                                          char                   *the_comment);
#endif

#if GM_IRIX_REPORT_VHANDL
#define GM_IRIX_VHANDL_DISP(v) \
   GM_PRINT (1, ("- virtual resource id = 0x%x\n", v_gethandle(v)));
#else
#define GM_IRIX_VHANDL_DISP(v)
#endif

/**********************************************************************
 * 
 * Well-known names stuff
 *
 **********************************************************************/

/*
 * The following macros localize the definition of our driver prefix (see
 * IMPORTANT NOTE in the prolog above) in one place: the GM_PREFIX_NAME macro.
 * This definition can then be used:
 *   - as part of function names, e.g. <pfx>open(), <pfx>init().
 *   - as a character literal, as in pciio_driver_register(..."prefix")
 *   - automatically as part of other macros, for example debug displays
 *
 * To change our driver prefix, modify the definition of GM_PREFIX_NAME,
 * replacing 'myrigm_' with the new prefix; and change the specification
 * in /var/sysgen/master.d.
 *
 * We also define the "hwgraph path name" here, although it is not necessary
 * for this string to have any specific relationship to the prefix.  This is
 * the name that is used in the hwgraph, e.g., /dev/myrigm/...
 */
#define GM_PREFIX_NAME(name) myrigm_ ## name
#define GM_PREFIX_ONLY GM_PREFIX_NAME( )
#define GM_PREFIX_STRING GM_SUB_N_STRINGIFY(GM_PREFIX_ONLY)

#define GM_PFXNM_ATTACH   GM_PREFIX_NAME(attach)
#define GM_PFXNM_CLOSE    GM_PREFIX_NAME(close)
#define GM_PFXNM_DETACH   GM_PREFIX_NAME(detach)
#define GM_PFXNM_DEVFLAG  GM_PREFIX_NAME(devflag)
#define GM_PFXNM_INIT     GM_PREFIX_NAME(init)
#define GM_PFXNM_IOCTL    GM_PREFIX_NAME(ioctl)
#define GM_PFXNM_MAP      GM_PREFIX_NAME(map)
#define GM_PFXNM_MVERSION GM_PREFIX_NAME(mversion)
#define GM_PFXNM_OPEN     GM_PREFIX_NAME(open)
#define GM_PFXNM_REG      GM_PREFIX_NAME(reg)
#define GM_PFXNM_UNLOAD   GM_PREFIX_NAME(unload)
#define GM_PFXNM_UNMAP    GM_PREFIX_NAME(unmap)
#define GM_PFXNM_UNREG    GM_PREFIX_NAME(unreg)


/*
 * GM_TRACE doesn't give satisfactory results with the IRIX C compiler,
 * because __FUNCTION__ is not defined.  So, for the GM_FNAME functions,
 * we use the following macros instead of START, NOT_IMP, and RETURN.
 * The level of 5 matches the level used in GM_TRACE.
 */

#define GM_FNAME_STR GM_SUB_N_STRINGIFY(GM_FNAME)

#define GM_ANNOUNCE_FNAME_ENTRY(pl) \
GM_PRINT (GM_PRINT_LEVEL >= pl, ("Function " GM_FNAME_STR " entered\n"))

#define GM_ANNOUNCE_FNAME_NOT_IMP() \
GM_PRINT (1, ("Yikes: " GM_FNAME_STR " not implemented yet\n"))

#define GM_ANNOUNCE_FNAME_EXIT(pl) \
GM_PRINT (GM_PRINT_LEVEL >= pl, ("Function " GM_FNAME_STR " exiting\n"))

#define GM_ANNOUNCE_FNAME_RETURN(pl, val) do { \
   GM_PRINT (GM_PRINT_LEVEL >= pl, \
             ("Function " GM_FNAME_STR " returning %d (0x%x)\n",val,val)); \
   return val; \
} while (0)


/* Macros to define the hwgraph path names to the myricard                   */
/*
 * NOTES:
 *   //////
 * * The number used in the clone name and privileged clone name is the
 *   instance number, which is the controller number assigned by ioconfig.
 *   This number is not likely to increase beyond the limit shown below,
 *   and it is also configurable by the sysadmin.  Bulletproofing this
 *   number would be nice but is low priority.
 *
 * * On the other hand, the numbers used in the "device name" (see also
 *   GM_IRIX_OPEN_NAME_MAX_SZ, defined in gm_arch_io.h) is going to
 *   increase monotonically every time the given card is opened again and
 *   a new port_state is created.  Therefore, this is an interim solution;
 *   before delivery of the driver, a number allocation scheme similar to
 *   GM's minor number scheme needs to be implemented, with safeguards
 *   preventing the number's increasing beyond a set limit on number of
 *   decimal digits.   //////
 *
 *  NOTE: Additional related defines are found in gm.h and gm_arch_types.h.
 *
 *  NOTE: the *_SZ values are the maximum *name* lengths, not the maximum
 *        *string variable* lengths; the latter are one greater than the
 *        former, when the ending \0 character is taken into account.
 */
#define GM_IRIX_NONP_HWNAME "myrinet"
#define GM_IRIX_PRIV_HWNAME "myrinetp"
#define GM_IRIX_DEV_NAME    "myrinet%u"
#define GM_IRIX_DEVNAME_SZ 13          /* big enough to hold "myrinet999999" */
#define GM_IRIX_MAX_DEV_NUM 999999
#define GM_IRIX_CLONE_NAME  "gm%u"
#define GM_IRIX_PCLONE_NAME "gmp%u"
#define GM_IRIX_EDGE_NAME "gm%um%u"       /* see GM_IRIX_EDGE_NAME_MAX_SZ    */
#define GM_IRIX_OPEN_NAME "/hw/gm%um%u"   /* see GM_IRIX_OPEN_NAME_MAX_SZ   */


/* 1K pages = 16MB */
/* NOTE:  The intent of this define would be to allow us to guard against
 *        allocating more buffer pages (= dma regions?) than the OS's
 *        limit on such allocations.  Linux actually does this, but as far as
 *        we know, IRIX defines no such limit.  We keep this definition here
 *        for now, even though it's unused, as a placeholder and a reminder.
 */
#define GM_MAX_BUFFER_PAGES (1*1024)


/* 
 * Defined STS bits for a DMA region.
 *
 * README.porting description of gm_arch_dma_region_status() sez:
 * "For PCI interfaces, return 0xf."
 */
#define GM_STS_BITS 0xf



/* Macros to convert seconds to microseconds etc.  */
/* These could usefully be moved to gm_internal.h or even to gm_types.h */
#define GM_MILLION          1000000
#define GM_SEC_TO_USEC(sec) ((sec) * GM_MILLION)



/* Macros to get and set instance_state, given vertex handle or dev_t
 *
 * NOTE:  In SGI's manuals, some example device drivers are shown using
 *        functions hwgraph_fastinfo_get() and hwgraph_fastinfo_set(),
 *        rather than device_info_get() and device_info_set().  In response
 *        to my inquiry, Jim Miller at SGI confirmed that the latter functions
 *        are preferred.  See email correspondence of December 15-16, 1999;
 *        reference SGI call id 991215J1.
 *
 * NOTE:  In IRIX 6.5, the system types 'dev_t' and 'vertex_hdl_t' are
 *        interchangeable.  The file <sys/types.h> contains this declaration:
 *
 *           typedef dev_t    vertex_hdl_t;
 *
 *        Moreover, the file <sys/hwgraph.h> contains macros 'vhdl_to_dev'
 *        and 'dev_to_vhdl' which simply cast each type into the other.
 *        Rather than rely on the typedef, we utilize the aforesaid macros
 *        here, on the principle of information hiding, making this more
 *        forward-compatible in case the exact equivalence of the two types
 *        should change at some future time.
 *
 *        The macros defined below should always be used to set and retrieve
 *        the instance state.  Observe that the device_info_{s,g}et()
 *        function declarations in <sys/hwgraph.h> formally declare their
 *        input parameter to be of type 'dev_t'.
 */

#define GM_IRIX_INSTANCE_GET_VH(vh,is)                                    \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_get(0x%x)\n", (vhdl_to_dev(vh))) ); \
   is = ((gm_instance_state_t *)device_info_get(vhdl_to_dev(vh)))

#define GM_IRIX_INSTANCE_GET_DV(dv,is)                                 \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_get(0x%x)\n", (dv)) );           \
   is = ((gm_instance_state_t *)device_info_get(dv))

#define GM_IRIX_INSTANCE_SET_VH(vh,is)                                 \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_set(0x%x, %p)\n",                \
                 (vhdl_to_dev(vh)), (is)) );                           \
   device_info_set((vhdl_to_dev(vh)), (void *)(is))

#define GM_IRIX_INSTANCE_SET_DV(dv,is)                                 \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_set(0x%x, %p)\n", (dv), (is)) ); \
   device_info_set((dv), (void *)(is))

#define GM_IRIX_INSTANCE_UNSET_VH(vh)                                        \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_set(0x%x, 0)\n", (vhdl_to_dev(vh))) ); \
   device_info_set((vhdl_to_dev(vh)), (void *)0)

#define GM_IRIX_INSTANCE_UNSET_DV(dv)                                  \
   GM_PRINT (GM_PRINT_LEVEL >= 6, ("Calling device_info_set(0x%x, 0)\n", (dv)) );        \
   device_info_set((dv),(void *)0)



/* Declarations for external data and functions                    */

#if GM_CAN_REGISTER_MEMORY
extern void gm_irix_setup_memory_registration(void);
extern void gm_irix_teardown_mem_registration(void);
#endif

#if GM_IRIX_DEBUG_MEMLEAKS
/* poor man's resource ("memory") leak detection */
struct gm_irix_mld
{                         /* TALLY OF:                                 */
int kernel_alloc_cnt,	  /* gm_arch_kernel_malloc() calls handled     */
    kernel_free_cnt;	  /* gm_arch_kernel_free() calls handled       */
int kmalloc_cnt,	  /* kmem_[z]alloc() calls we made             */
    kmfree_cnt;		  /* kmem_free() calls we made                 */
int dma_alloc_cnt,	  /* gm_arch_dma_region_alloc() calls handled  */
    dma_free_cnt;	  /* gm_arch_dma_region_free() calls handled   */
int dmamap_alloc_cnt,	  /* pciio_dmamap_alloc() calls we made        */
    dmamap_free_cnt;	  /* pciio_dmamap_free() calls we made         */
int ifn_dmamap_alloc_cnt, /* pages allocated for DMA by ifnet driver   */
    ifn_dmamap_free_cnt;  /* DMA pages freed by ifnet driver           */
int dma_pg_alloc_cnt,	  /* pages allocated for DMA by GM             */
    dma_pg_free_cnt;	  /* DMA pages freed by GM                     */
int ifn_dma_pg_alloc_cnt, /* pages allocated for DMA by ifnet driver   */
    ifn_dma_pg_free_cnt;  /* DMA pages freed by ifnet driver           */
int user_lock_cnt,	  /* user pages locked (registered)            */
    user_unlock_cnt;	  /* user pages unlocked (deregistered)        */
int vertex_add_cnt;	  /* hwgraph vertexes added                    */
int edge_add_cnt,	  /* hwgraph edges added                       */
    edge_remove_cnt;	  /* hwgraph edges removed                     */
int minor_alloc_cnt,	  /* successful calls to gm_minor_alloc()      */
    minor_free_cnt;	  /* calls to gm_minor_free()                  */
int pstate_close_cnt;	  /* calls to gm_port_state_close()            */
};

extern struct gm_irix_mld gm_irix_mld_struct;
#endif

extern mutex_t  gm_irix_print_mu; /* mutex to guard printing granularity */
extern int      gm_need_kvtophys_analysis; /* to do analysis just once */

void * gm_irix_kmemalloc  (size_t memsize, int flags);
void * gm_irix_kmemzalloc (size_t memsize, int flags);
void   gm_irix_kmemfree   (void *mem, size_t memsize);

extern int  gm_irix_localize_status (gm_status_t status);

#if GM_IRIX_DEBUG_MEMLEAKS
void   gm_irix_memleak_report(char *the_comment);
#endif

#if GM_IRIX_USE_MONSTER
#define GM_MONSTER_DEBUG_BUF_SIZ 524288
#define GM_MONSTER_TAG_SIZ         1024
#define GM_MONSTER_LINESIZ          192

extern char          gm_monster_debug_buf[GM_MONSTER_DEBUG_BUF_SIZ +
                                          GM_MONSTER_TAG_SIZ];
extern char          *gm_monster_current;
extern unsigned int  gm_monster_offset;
extern unsigned int  gm_monster_wrap_tally;

extern void gm_irix_cmn_err_start  (int, char *);
extern void gm_irix_cmn_err_finish(int, char *, va_list);
#else
#define gm_irix_cmn_err_start   cmn_err
#define gm_irix_cmn_err_finish icmn_err
#endif 

extern void gm_irix_programmed_panic(char *the_comment);

extern int  gm_irix_area_is_0(u_char * cptr, int len);
extern int  gm_irix_hexdump(u_char * cptr, int len);

#endif /* _gm_arch_local_h_ */
