/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* This file and the corresponding C file implement an object oriented
   interface to the interface-type-specific functionality of an
   instance. */

#ifndef _gm_instance_h_
#define _gm_instance_h_

#include "gm_impl.h"

typedef struct gm_resource_location
{
  gm_u32_t offset;
  gm_u32_t length;
} gm_resource_location_t;

enum gm_resource_type
{
  GM_MEMORY_REGION,
  GM_EEPROM_REGION,
  GM_SPECIAL_REGS_REGION,
  GM_CONTROL_REGS_REGION
};

gm_status_t gm_map_io_spaces (gm_instance_state_t *is);
void gm_unmap_io_spaces (gm_instance_state_t *is);
gm_status_t gm_init_instance_functions (gm_instance_state_t *is);
gm_status_t gm_load_mcp (gm_instance_state_t *is);
void gm_unload_mcp (gm_instance_state_t *is);
#if 0
gm_status_t gm_ifc_init (gm_instance_state_t *is, gm_u32_t unit,
			 enum gm_ifc_type type);
void gm_ifc_finalize (gm_instance_state_t *is);
#endif
gm_u32_t gm_pci_board_span (gm_instance_state_t * is);

#endif /* _gm_instance_h_ */
