/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/*
  gb.h
  header file for gm ifnet driver for freebsd
  finucane@myri.com
*/

#ifndef gb_h
#define gb_h

/*#include "bpf.h"*/

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/sockio.h>
#include <sys/mbuf.h>
#include <sys/malloc.h>
#include <sys/kernel.h>
#include <sys/socket.h>

#include <net/if.h>
#include <net/if_arp.h>
#include <net/ethernet.h>
#include <net/if_dl.h>
#include <net/if_media.h>

#include <netinet/in.h>
#include <netinet/in_var.h>


#if NBPF > 0
#include <net/bpf.h>
#endif

/*#include "opt_bdg.h"*/

#include <vm/vm.h>              /* for vtophys */
#include <vm/pmap.h>            /* for vtophys */
#include <machine/clock.h>      /* for DELAY */
#include <machine/bus_memio.h>
#include <machine/bus_pio.h>
#include <machine/bus.h>
#include <machine/resource.h>
#include <sys/bus.h>
#include <sys/rman.h>

#include <pci/pcireg.h>
#include <pci/pcivar.h>

#include "gm_internal.h"
#include "gm_ether.h"
#include "gm_debug_lanai_dma.h"
  

#define GB_SLOP 16
#define GB_GRAIN 8
#define GB_BUFFER_SIZE (GM_ETHERNET_MTU + GB_SLOP)
#define GB_NUM_SEND_BUFFERS (GM_NUM_SEND_TOKENS * 4)
#define GB_NUM_RECEIVE_BUFFERS (GM_NUM_ETHERNET_RECV_TOKENS * 4)
#define GB_MIN_RECEIVE_BUFFERS 2
#define GB_MIN_GATHER_LENGTH 0
#define GB_ROUND_POINTER(p)(char*)(((((unsigned long)(p)) + (GB_GRAIN - 1)) & ~(GB_GRAIN - 1)))
#define GB_ROUND_INT(p)(long int)(((((unsigned long)(p)) + (GB_GRAIN - 1)) & ~(GB_GRAIN - 1)))
#define GB_ALIGNED(p)(!((((unsigned long)p) & GB_GRAIN - 1)))
#define GB_NAME "myri"
#define GB_NAME_LEN 71
#define GB_MAX_DEVICES 16

#define GB_VTOP(va) (char*)(vtophys(va))
#define GB_BUFFER_TO_ITEM(p)(gb_Item*) (*(gb_Item**)((((char*)p) - sizeof (char*))))

struct gb_Device;

typedef struct gb_Item
{
  struct gb_Item*next;
  struct gb_Device*device;
  int osize;
  int size;
  struct mbuf*m;
  char*ma;
  char*va;
  char*pa;
  int numPieces;
  int refs;
  
}gb_Item;


typedef struct gb_Queue
{
  int size;
  gb_Item*head;
  gb_Item*tail;
}gb_Queue;

typedef struct gb_Device
{
  struct arpcom arpcom;
  struct ifmedia ifmedia;
  
  struct gm_port*port;
  char address [6];
  char name [GB_NAME_LEN];
  int unit;
  int forceAlignment;
  int opened;

  gb_Queue freeSends;
  gb_Queue freeReceives;
  gb_Queue pendingSends;
  gb_Queue pendingReceives;
}gb_Device;

#define gbtoifp(p)(&p->arpcom.ac_if)
#define ifptogb(p)((gb_Device*)p)

int gb_isEmpty (gb_Queue*q);
int gb_put (gb_Queue*q, gb_Item*p);
gb_Item*gb_get (gb_Queue*q);
gb_Item*gb_newItem ();
void gb_freeItem (gb_Item*p);
gb_Item*gb_newBufferItem (gb_Device*d, int size);
void gb_freeBufferItem (gb_Item*p);
int gb_feedGm (gb_Device*d);
void gb_reclaimReceiveMbufItem (caddr_t address, u_int length);
gb_Item*gb_newMbufItem (gb_Device*d, gb_Item*p);
gb_Device*gb_newDevice ();
void gb_freeDevice (gb_Device*d);
int gb_attach (int unit);
int gb_detach (int unit);
int gb_send (gb_Device*d, struct mbuf*m);
void gb_receiveDone (gb_Device*d, unsigned length);
void gb_sendDone (gb_Device*d);
int gb_open (gb_Device*d);
int gb_close (gb_Device*d);
void gb_ref (caddr_t buffer, u_int size);

#ifdef __alpha__
#undef vtophys
#define vtophys(va)		alpha_XXX_dmamap((vm_offset_t)va)				
#endif

#endif /*gb_h*/


