/* 
 * Architecture-specific type for the "arch" field of the gm_intance_state_t
 * data structure. 
*/

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_
/*
 * FreeBSD driver defines 
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/uio.h>
#include <sys/kernel.h>
#include <sys/signalvar.h>
#include <sys/mman.h>
#include <sys/vmmeter.h>

#include <sys/bus.h>
#include <machine/bus.h>
#include <sys/rman.h>
#include <machine/resource.h>

#include <vm/vm.h>
#include <vm/vm_kern.h>
#include <vm/pmap.h>
#include <vm/vm_extern.h>
#include <machine/clock.h>      /* for DELAY */

#include <pci/pcivar.h>
#include <pci/pcireg.h>
#include <sys/sysctl.h>


#define GM_ARCH_MALLOC_REGION 1
#define GM_ARCH_CONTIGMALLOC_REGION 2


struct gm_instance_state;

typedef struct gm_arch_dma_region
{
	struct gm_instance_state *is; /* for debugging purpose */
	void *addr;                   /* aligned address */
	char *addr2;                  /* for gm_arch_dma_region_advance */
	void *alloc_addr;
	unsigned len;
	int flags;
	unsigned char type;
	unsigned char order;
} gm_arch_dma_region_t;

#define GM_SEND_RING 16 /* MUST be power of 2 */
#define GM_RECV_RING 8  /* MUST be power of 2 */
#define GM_SEND_RING_MAX_INDEX (GM_SEND_RING -1)
#define GM_RECV_RING_MAX_INDEX (GM_RECV_RING -1)
#define GM_NET_COPY_THRESHOLD 400

struct gm_port;

typedef struct  {
	int dummy;
} gm_arch_net_info_t;


typedef struct gm_arch_instance_info    /* what a name! -- think "softc" */
{
	device_t dev;                   /* newbus device handle */
	char * csr;                     /* control/status registers */
        struct resource *mem;           /* resource descriptor for registers */
        struct resource *irq;           /* resource descriptor for interrupt */
        void *ih;                       /* interrupt handler cookie */
	int inuse;                      /* count of users*/

} gm_arch_instance_info_t;

typedef struct gm_arch_port_info
{
  int ref_count; /* open file descriptor + mapping count */
} gm_arch_port_info_t;


/*
 * GM synchronization types
 */
typedef struct gm_arch_sync
{
        int held;
        int waiters;
	int wake_cnt;
} gm_arch_sync_t;


#define GM_SLEEP_WOKE 0
#define GM_SLEEP_TIMED_OUT EWOULDBLOCK
#define GM_SLEEP_INTERRUPTED ERESTART

/*
 * GM memory management types
 */


typedef struct
{
	struct proc *proc;
	vm_map_t    map;
	vm_offset_t addr;
} gm_arch_page_lock_t;

typedef int /*minor_t*/ gm_arch_minor_t;

typedef int gm_arch_ioctl_context_t;


#endif /*_gm_arch_types_h_*/
