# /************************************************************-*-makefile-*-
#  * Myricom GM networking software, interface, and documentation	   *
#  * Copyright (c) 1999 by Myricom, Inc.				   *
#  * All rights reserved.  See the file `COPYING' for copyright notice.	   *
#  *************************************************************************/

# This file includes shared rules for building all unix-like drivers

#############
# Header files
#############

include $(top_srcdir)/include/include.mk
gm_uc_h = $(top_srcdir)/drivers/gm_uc.h $(gm_impl_h)
gm_impl_h = $(top_srcdir)/drivers/gm_impl.h $(gm_arch_types_h)
gm_instance_h = $(top_srcdir)/drivers/gm_instance.h $(gm_impl_h)

#############
# C files
#############

gm_c_headers = $(gm_h) $(gm_io_h) $(gm_page_hash_h) $(gm_arch_h)
gm_uc_c_headers = $(gm_arch_h) $(gm_uc_h)
gm_minor_c_headers = $(gm_arch_h)
gm_instance_c_headers = $(gm_arch_h) $(gm_instance_h)
gm_port_state_c_headers = $(gm_arch_h)

gm_c = $(driver_srcdir)/gm.c
gm_uc_c = $(driver_srcdir)/gm_uc.c
gm_minor_c = $(driver_srcdir)/gm_minor.c
gm_instance_c = $(driver_srcdir)/gm_instance.c
gm_port_state_c = $(driver_srcdir)/gm_port_state.c

gmcp_array_l4_4k_c = $(mcp_srcdir)/gmcp_array_l4_4k.c
gmcp_array_l4_8k_c = $(mcp_srcdir)/gmcp_array_l4_8k.c
gmcp_array_l5_4k_c = $(mcp_srcdir)/gmcp_array_l5_4k.c
gmcp_array_l5_8k_c = $(mcp_srcdir)/gmcp_array_l5_8k.c
gmcp_array_l6_4k_c = $(mcp_srcdir)/gmcp_array_l6_4k.c
gmcp_array_l6_8k_c = $(mcp_srcdir)/gmcp_array_l6_8k.c

# MCP compressed loadable image files

$(mcp_srcdir)/gmcp_array_%.c: FORCE
	cd $(mcp_builddir) && $(MAKE) $(GM_MCPS)

gmcp_array_%.o: $(mcp_srcdir)/gmcp_array_%.c
	$(CC) $(CFLAGS) -o $@ -c $<

#############
# Object files
#############

gm.o: $(gm_c) $(gm_c_headers)
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(gm_c)

gm_uc.o: $(gm_uc_c) $(gm_uc_c_headers)
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(gm_uc_c)

gm_minor.o: $(gm_minor_c) $(gm_minor_c_headers)
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(gm_minor_c)

gm_instance.o: $(gm_instance_c) $(gm_instance_c_headers)
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(gm_instance_c)

gm_port_state.o: $(gm_port_state_c) $(gm_port_state_c_headers)
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(gm_port_state_c)

gmcp_array_%.o: $(mcp_srcdir)/gmcp_array_%.c
	$(CC) $(CFLAGS) -DGM_KERNEL -o $@ -c $(mcp_srcdir)/gmcp_array_$*.c

#############
# Libraries/Drivers
#############

libgmk_a = $(top_builddir)/libgm/libgmk.a
$(libgmk_a): FORCE
	cd $(top_builddir)/libgm && $(MAKE) libgmk.a

