#ifndef mpigm_h
#define mpigm_h

#include "gm.h"
/*#include "gm_types.h"*/
#undef RETURN

#define GMPI_ROUNDUP(x) (((x)+GM_DMA_GRANULARITY-1)&~(GM_DMA_GRANULARITY-1))
#define GMPI_INIT_LEN 8
#define GMPI_CONTROL_TAG 14 /* limits to 16384 bytes */
#define GMPI_NETDATA_HEADER_LEN 0


typedef struct gm_port *gmpi_port;

#if 0
#define GMPI_SEND_HEAD_LEN (sizeof(void*)*2)
/* used before send buffers, either for shandle or for free send_control buffer linking */
#define GMPI_SEND_NETDATA(p) ((void*)((void **)(p)+2))
#define GMPI_SEND_HEAD(p) ((void **)(p)-2)
#else
#define GMPI_SEND_HEAD_LEN 0
#define GMPI_SEND_NETDATA(p) (p)
#define GMPI_SEND_HEAD(p) (p)

#endif


#undef GMPI_CREDITS

#define GMPI_FIRST_TAG 20
#define GMPI_NTAGS 10

void gmpi_use_interval(unsigned long start,long length);
void gmpi_unuse_interval(unsigned long start, long length);
void gmpi_clear_interval(unsigned long start,long length);
void gmpi_clear_all_intervals(void);
void gmpi_regcache_init(void);


#define GMPI_ZONE_NPAGES 1024

struct gmpi_arch_var {
  struct gmpi_zone {
    struct gmpi_zone *next;
    unsigned long start;
    struct {
      unsigned int registered:1;
      unsigned int refcount:31;
    } status[GMPI_ZONE_NPAGES];
  } *intervals,*free_intervals;
  int nbintervals;
};

/* tunable parameters */

#define MPID_PKT_MAX_DATA_SIZE 16000
#define GMPI_MAX_NUMNODES 1024
#define GMPI_MAX_DMA_BYTES 600000 /* 1 mega (this should stay much bigger than the size of a message) */
#define GMPI_MAX_FRAG (1<<17) /* maximum message = 128Kbytes (temporary) */
#define GMPI_NSTOKEN 16


#ifdef GM_CAN_REGISTER_MEMORY
#define gmpi_need_rcopy(data,len) (((long)(data) & 7) || ((long)(len) & 7) || (len) < 8192)
#define gmpi_need_scopy(data,len) (((long)data & 7) || (len) < 8192)
#else
#define gmpi_need_rcopy(data,len) 1
#define gmpi_need_scopy(data,len) 1
#define gmpi_use_interval(s,b) gm_abort()
#define gmpi_unuse_interval(s,b) gm_abort()
#define gmpi_clear_interval(s,b) 
#define gmpi_clear_all_intervals()
#define gmpi_regcache_init()
#endif

#endif
