void gmpi_net_datasend(int dest,void *buf,int length,int tag,MPIR_SHANDLE *shandle)
{
  int size = (length+3)/4;
  gm_assert_p(!(long)buf & 3);
  gmpi.arch.sid = bip_tisend(gmpi.node_ids[dest],tag, (int*)buf,(size));
  gmpi.arch.shandle = (shandle);
  gmpi.arch.sbuf = buf;
}

void gmpi_net_ctlsend(int dest,void *buf,int length)
{
  int size = (length+3)/4;
  gm_assert_p(!(long)buf & 3);
  /* bip_tisend for ctl message is freeing the buffer immediately */
  bip_tisend(gmpi.node_ids[dest],0, (int*)buf,(size));
  process_cltsent_evt(buf);
}

void gmpi_netpostrecv(void *buf,int length,int tag,int copy)
{
  gm_assert_p(!(length & 3));
  gmpi.arch.rbuf = buf;
  gmpi.arch.rid = bip_tirecv(1, buf, length/4);
}



void gmpi_subinit(void)
{
  int i;
  bip_taginit(1,1,BIPSMALLSIZE);
  for (i=2;i<NTAGS;i++)
    bip_taginit(i,1,1);
  bip_taginit(0,GMPI_MAX_NUMNODES*GMPI_CREDITS,BIPSMALLSIZE);
  bip_init();
  gmpi.rtoken = 1;
  gmpi.stoken = 1;
  MPID_MyWorldSize = bip_numnodes;
  MPID_MyWorldRank = bip_mynode;
  for (i=0;i< MPID_MyWorldSize;i++)
    gmpi.node_ids[i] = i;
}


int gmpi_net_lookup(MPID_Device *dev,int blocking)
{
  int buf[GMPI_CONTROL_TAG];
  int src,length;
  int err = MPI_SUCCESS;
  if ((length = bip_tnrecv(0,buf,GMPI_CONTROL_TAG) != -1)) {
    err = control_recv_event(dev,buf);
    //      bip_tfreemsg(0);
  }
  /* transmission en cours */
  if (gmpi.rtoken == 0) {
    if ((length = bip_rtest(gmpi.arch.rid)) != -1) {
      length *= 4;
      gmpi.arch.rid = 0;
      recv_data(gmpi.arch.rhandle,gmpi.arch.rbuf,length);
      //	gmpi.rhandle = 0;
      //	gmpi.rbuf = 0;
    }
  }
  if (gmpi.stoken == 0) {
    if (bip_stest(gmpi.arch.sid)) {
      process_datasent_event(gmpi.arch.shandle,gmpi.arch.sbuf);
      gmpi.arch.sid = 0;
    }
  }
  return err;
}

