#include <unistd.h>
#include <unistd.h>
#include <sys/mman.h>
#include <features.h>

#include "gmpi.h"

#ifndef __linux__
/* loic: at least on 64bits archs, it is important that sbrk has the right prototype
   sbrk altough quite UNIX universal is a non-official function, so might not be in headers
   if this definition conflicts with yours, remove the OS from the def condition
 */
void *sbrk();
#endif

void *gmpi_sbrk(ptrdiff_t inc)
{
  if (inc < 0) {
    long oldp = (long)sbrk(0);
    gmpi_clear_interval(oldp+inc,-inc);
  }
  return sbrk(inc);
}

int gmpi_munmap(void * start, size_t length)
{
  gmpi_clear_interval((unsigned long)start,length);
  return munmap(start,length);
}
