
#include <unistd.h>
#include <unistd.h>
#include <sys/mman.h>
#include <features.h>

#include "gmpi.h"

#define IGNORE_REMAP 0

#if !defined __GLIBC__ && ! defined __GNU_LIBRARY__
#error only GNU libc has been tested, modify this file if needed
#endif


#ifdef __GLIBC__
#if __GLIBC_MINOR__ == 0
#define __mmap_arg_t __caddr_t
#elif __GLIBC_MINOR__ == 1
#define __mmap_arg_t __ptr_t
/* hack-hack */
int __libc_multiple_libcs;
#else
#error this version of GLIBC has not been tested
#endif
#elif __GNU_LIBRARY__ == 1
#define __mmap_arg_t __ptr_t
#else
#error __GNU_LIBRARY__ version not tested
#endif


void *orig_sbrk(ptrdiff_t increment);
int orig_munmap(void *start, size_t length);
__mmap_arg_t orig_mremap(__mmap_arg_t, size_t , size_t, int);
int orig_brk(void *e);

int brk(void *a)
{
  long oldp = (long)orig_sbrk(0);
  long newp =(long)a;
  if (newp && newp < oldp)
    gmpi_clear_interval(oldp,newp-oldp);
  return orig_brk(a);
}


void *sbrk(ptrdiff_t inc)
{
  if (inc < 0) {
    long oldp = (long)orig_sbrk(0);
    gmpi_clear_interval(oldp+inc,-inc);
  }
  return orig_sbrk(inc);
}


#if !IGNORE_REMAP
int munmap(__mmap_arg_t start, size_t length)
{
  gmpi_clear_interval((unsigned long)start,length);
  return orig_munmap(start,length);
}

__mmap_arg_t mremap(__mmap_arg_t old_address, size_t old_size , size_t
		      new_size, int flags)
{
  gmpi_clear_interval((unsigned long)old_address,old_size);
  return orig_mremap(old_address, old_size, new_size, flags);
}


int __brk(void *a)
{
  return brk(a);
}

void *__sbrk(ptrdiff_t inc)
{
  return sbrk(inc);
}

int __munmap(__caddr_t start, size_t length)
{
  return munmap(start,length);
}

__mmap_arg_t __mremap(__mmap_arg_t old_address, size_t old_size , size_t
		      new_size, int flags)
{
  return mremap(old_address, old_size, new_size, flags);
}

#endif

int gmpi_clear_benice = 0;

#if IGNORE_REMAP || __GLIBC_MINOR__ == 1

/* we cannot intercept __mmap, so we need to use malloc hooks to catch
   cases where malloc might call it */

#include <malloc.h>

#if __GLIBC_MINOR__ == 1
#define CALLER ,caller
#define CALLER_ARG ,__const __malloc_ptr_t caller
#else
#define CALLER 
#define CALLER_ARG
#endif

static void (*old_free_hook)(__malloc_ptr_t __ptr CALLER_ARG);
static __malloc_ptr_t (*old_realloc_hook)(__malloc_ptr_t __ptr,
                                          size_t __size CALLER_ARG);

static void my_free_hook(__malloc_ptr_t ptr CALLER_ARG)
{
  if (ptr)
    {
      long size = malloc_usable_size(ptr);
      /* if of small size, the block is not allocated with mmap, do
         not bother to slow down free */
      if (size >= 8192)
        {
          gmpi_clear_benice = 1;
          gmpi_clear_interval((long)ptr,size);
          gmpi_clear_benice = 0;
        }
    }
  __free_hook = old_free_hook;
  if (old_free_hook)
    (*old_free_hook)(ptr CALLER);
  else
    free(ptr);
  __free_hook = my_free_hook;
}


static __malloc_ptr_t my_realloc_hook(__malloc_ptr_t ptr,
                            size_t size CALLER_ARG)
{
  if (ptr)
    {
      long size = malloc_usable_size(ptr);
      if (size >= 8192)
	{
	  gmpi_clear_benice = 1;
	  gmpi_clear_interval((long)ptr,size);
	  gmpi_clear_benice = 0;
	}
    }
  __realloc_hook = old_realloc_hook;
  if (old_realloc_hook)
    ptr = (*old_realloc_hook)(ptr,size CALLER);
  else
    ptr = realloc(ptr,size);
  __realloc_hook = my_realloc_hook;
  return ptr;
}

void gmpi_mem_hook_init(void)
{
  /* better to call realloc to be sure everything is initialized
     before installing hooks */
  void *ptr = malloc(10);
  ptr = realloc(ptr,5);
  free(ptr);
  
  old_free_hook = __free_hook;
  gm_assert(old_free_hook == 0);
  old_realloc_hook = __realloc_hook;
  gm_assert(old_realloc_hook == 0);
  __free_hook = my_free_hook;
  __realloc_hook = my_realloc_hook;
}

#else /* ! glibc 2.1 */

void gmpi_mem_hook_init(void)
{
}


#endif
