#ifndef _gmpi_h
#define _gmpi_h

#include "mpichconf.h"

#ifdef BIP
#include "mpibip.h"
#else /* real GM */
#include "mpigm.h"
#endif

/* set this to "1" to turn OFF the sigalarm code */
/* set this to "0" to turn ON  the sigalarm code */
#define GM_DISABLE_ALARM  1

/* generic macros and definitions */

#ifdef GM_DEBUG
#define GM_DBG(a) a
#else
#define GM_DBG(a) 
#endif

#ifndef GM_PRINT_LEVEL
#define GM_PRINT_LEVEL 0
#endif
void gmpi_printf (char *format, ...);
#define GM_PRINT(a,b) do { if ((a) <= GM_PRINT_LEVEL) { gmpi_printf b ;} } while (0)


#include "mpid.h"
#include "req.h"
#include "dev.h"

struct send_control_block {
  struct send_control_block *next;
};

struct send_fifo_req {
  void *data;
  struct _MPIR_SHANDLE *shandle;
  int len;
  int grank;
  int is_data;
  struct send_fifo_req *next;
};



struct recv_fifo_req {
  void (*callback)(struct _MPIR_RHANDLE *,MPID_RNDV_T);
  struct _MPIR_RHANDLE *rhandle;
  int len;
  struct recv_fifo_req *next;
};


void gmpi_init(int *argc,char ***argv);
void gmpi_finish(MPID_Device * dev);
void gmpi_getconf(void);
void *gmpi_ctl_alloc(unsigned len);

void gmpi_net_datasend(int dest,void *buf,int length,int tag,MPIR_SHANDLE *shandle);
void gmpi_net_ctlsend(int dest,void *buf,int length);
void gmpi_netpostrecv(void *buf,int length,int tag,MPIR_RHANDLE *rhandle,int copy);
void gmpi_subinit(void);
int gmpi_net_lookup(MPID_Device *dev,int blocking);
void gmpi_ctlsent_event(void *p);
void gmpi_datasent_event(MPIR_SHANDLE *shandle, void *p);
void gmpi_free_databuf(void *buf,int length);
void gmpi_datafrag_complete(MPIR_SHANDLE *shandle);


void gmpi_lock(void);
void gmpi_unlock(void);

void *gmpi_xmalloc(int len,char *msg);

#define DMA_ALLOC(p,l,res) gmpi_alloc(p,l,res)
#define DMA_FREE(p,l,size,res) gmpi_free(p,l,size,res)
#define GMPI_RDMA 0
#define GMPI_SDMA 1

void *gmpi_alloc(gmpi_port, int,int);
void gmpi_free(gmpi_port, void *,int,int );

#define GMPI_MAX_DATA_FRAG (GMPI_MAX_FRAG-GMPI_NETDATA_HEADER_LEN)

#define MAX(a,b) ((a)>(b)? (a):(b))
#define MIN(a,b) ((a)<(b)? (a):(b))

unsigned gmpi_checksum(unsigned char*buf,int len);
struct pkt_cksum {
  unsigned short len;
  unsigned short sum;
};

#define GMPI_PKT_CKSUM struct pkt_cksum ck;

#if !GM_DISABLE_ALARM
#include <pthread.h>
#endif


struct gmpi_var {
  gmpi_port port; /*  global port variable */
  unsigned int my_node_id;
  long dma_bytes[2];
  long max_dma_bytes[2];
  int dma_nballoc;
  int stoken;/* current number of send tokens available */
  int max_stoken;/* max number of send tokens */
  int rtoken;/* number of recv tokens available */
  int num_sends_queued;
  struct gmpi_tag {
    struct gmpi_tag *next;
    int num;
    MPIR_RHANDLE *rhandle;
  } *free_tag,tags[GMPI_NTAGS];
  struct gmpi_stoken {
    struct gmpi_stoken *next;
    MPIR_SHANDLE *shandle;
    void *buf;
  } *free_stoken,*used_stoken,stokens[GMPI_NSTOKEN];
  struct send_fifo_req *send_fifo_head;
  struct recv_fifo_req *recv_fifo_head;
  struct send_control_block * send_control_root;

  unsigned int node_ids[GMPI_MAX_NUMNODES];/* node ids */
  char *node_names[GMPI_MAX_NUMNODES];/* names of machines */
  unsigned int mpi_pid[GMPI_MAX_NUMNODES];/*PID of remote processes */
  unsigned int port_ids[GMPI_MAX_NUMNODES];/* port ids */
  unsigned int board_ids[GMPI_MAX_NUMNODES];/* board/unit number */
#ifdef GMPI_CREDITS
  short credits_left[GMPI_MAX_NUMNODES];
  short credits_back[GMPI_MAX_NUMNODES];
#endif
  volatile int busy;
  int enable_csum;
#if !GM_DISABLE_ALARM
  pthread_cond_t alarm_wake;
  pthread_cond_t alarm_ack;
  pthread_mutex_t alarm_mutex;
#endif
  struct gmpi_arch_var arch;
};

#ifdef GMPI_CREDITS
#define GMPI_PKT_CREDITS int bip_credits;
#else
#define GMPI_PKT_CREDITS
#endif

extern struct gmpi_var gmpi;

void gmpi_queue_send(void *data, MPIR_SHANDLE *shandle, int len, int grank, int is_data, int type);
typedef void (*recvbuf_callback)(MPIR_RHANDLE *rhandle, MPID_RNDV_T);
void gmpi_queue_recv(int length, recvbuf_callback,MPIR_RHANDLE *);
void MPID_CH_Rndvn_ok_to_send( MPIR_RHANDLE *rhandle, MPID_RNDV_T);

#define MPID_PKT_PRIVATE GMPI_PKT_CREDITS GMPI_PKT_CKSUM

#if !defined(gm_always_assert)
#define gm_always_assert gm_assert
#endif



#endif /* gmpi_h */


