#ifndef BIP
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define GM_STRONG_TYPES 0
#include "gm.h"
#undef RETURN
#include "mpid.h"

#include "gmpi.h"

#define WHITE_SPACE " ()\t,\n"

#define NBITEM(a /*+ The structure to examin +*/) ((sizeof(a))/sizeof((a)[0]))

#define PRINT_CONFINFO	0		/* set to 1 for debugging conf file parsing */

struct opts {
	int rank;
	int size;
};

#ifdef DELETE
/* no longer needed */
static void
parse_opts(const char *s,		/*+ the environnement string. + */
		   struct opts *opts)
{								/*+ The internal options structure. + */
	int i;
	char *ptr;
#ifdef BOOL_OPTS
	struct {
		char c;
		int *ptr;
	} bool_opts[] = { };
#endif
	struct {
		char c;
	} int_opts[] = {
		{'m'},{'n'},
	};

	if (!s) {
#if PRINT_CONFINFO
		printf("environment string is NULL\n");
#endif
		return;
	}

#if PRINT_CONFINFO
	printf("environment string is '%s'\n",s);
#endif

#ifdef BOOL_OPTS
	/* set the bool_opts options */
	for (i = 0; i < NBITEM(bool_opts); i++) {
		if (strchr(s, bool_opts[i].c))
			*bool_opts[i].ptr = 1;
	}
#endif
	/* set the int_opts values */
	for (i = 0; i < NBITEM(int_opts); i++) {
#if PRINT_CONFINFO
		printf("checking for item = %d\n",i);
#endif
		if ((ptr = strchr(s, int_opts[i].c))) {
			int val = atoi(ptr + 1);
#if PRINT_CONFINFO
			printf("item = %d  val_found = %d\n",i,val);
#endif
			if (i==0){
			  opts->rank = val;
			}
			else if (i==1){
			  opts->size = val;
			}
		}
		else {
#if PRINT_CONFINFO
			printf("strchr failed for item = %d  char = '%c'\n",i,int_opts[i].c);
#endif
		}
	}
}

#endif /* DELETE */



static char line[255];

void
clipit(char *ptr, int maxlen)
{
	int offset = 0;
	/* drop newline character */
	do {
		if (!ptr[offset]) {
			return;
		}
		if (ptr[offset] == '\n') {
			ptr[offset] = 0;
		}
		offset++;
	} while (offset < maxlen);
}

void
gmpi_getconf()
{
	char *opt_string;
	char *ids_string;
	char *conf_file;
	char fn[255];
	FILE *conffile_stream;
	int num_read;
	char *s;
	char *t;
	struct opts opt;
	int i;
	int size;
	int state;
	char *node_id;
	int count = 0;
	int linecount = 0;
	int num = 0;

	opt.rank = -1;
	opt.size = -1;

	/* stdout line buffered */
	setvbuf(stdout, NULL, _IOLBF, BUFSIZ);

	opt_string = getenv("GMPI_OPTS");
	/* GMPI_OPTS=m5,n6 *** mrank, ntotal */

#if PRINT_CONFINFO
	printf("opt_string = '%s'\n",opt_string);
	if (!opt_string)
		fprintf(stderr, "Error: Need to obtain rank and size in GMPI_OPTS\n");
#endif
	conf_file = getenv("GMPI_CONF");
	sprintf(fn, conf_file);

#if PRINT_CONFINFO
	printf("conf_file = '%s'\n",conf_file);
	if (!conf_file)
		fprintf(stderr, "Error: Need to obtain conf in GMPI_CONF variables\n");
#endif

	if (!opt_string || !conf_file) {
		fprintf(stderr, "Error: Need to obtain conf in GMPI_OPTS, and GMPI_CONF variables\n");
		exit(1);
	}
	count = sscanf(opt_string, "m%d,n%d",&opt.rank,&opt.size);
	if ((count != 2)|| (opt.rank == -1) || (opt.size == -1)) {
		fprintf(stderr, "Error: GMPI_OPTS should give rank and World size\n");
		fprintf(stderr, "   rank is %d, and World size is %d\n", opt.rank, opt.size);
		exit(1);
	}
	MPID_MyWorldRank = opt.rank;
	MPID_MyWorldSize = opt.size;
	if ((opt.size > GMPI_MAX_NUMNODES) || (opt.rank >= opt.size) ||
	    (opt.rank<0) || (opt.size<=0)) {
		fprintf(stderr,"Error Size and Rank have problems size=%d maxsize=%d rank=%d\n",
			GMPI_MAX_NUMNODES, opt.size,opt.rank);
		exit(1);
	}

	conffile_stream = fopen(fn, "r");
	if (!conffile_stream) {
		fprintf(stderr, "conf file '%s' couldn't be opened\n", fn);
		exit(1);
	}

	linecount = 0;
	do {
		/* find the node count */
		/* this should skip comments and blank lines */
                bzero(line, 255);

		fgets(line, 255, conffile_stream);
		linecount++;
#if PRINT_CONFINFO
		clipit(line, 255);
		printf("look for count:  got line '%s'\n", line);
#endif

		if (line[0] == '#') {
#if PRINT_CONFINFO
			printf("look for count: skipping commented line\n");
#endif
			continue;
		}
		num_read = sscanf(line, "%d", &size);
		if (num_read == 1) {
			break;
		}
		if (num_read == 0) {
#if PRINT_CONFINFO
			printf("look for count:  skipping blank line\n");
#endif
		}
	} while ((!feof(conffile_stream)) && (num_read != 1));


	if (num_read != 1) {
		fprintf(stderr, "conf file '%s' missing 1st int (a count of nodes)??\n", fn);
		exit(1);
	}

#if PRINT_CONFINFO
	printf("got numnodes = %d\n", size);
#endif

	count = 0;
	bzero(gmpi.node_names, GMPI_MAX_NUMNODES * sizeof(char *));
	while (!feof(conffile_stream)) {
	        if (!gmpi.node_names[count])
		  gmpi.node_names[count] = gmpi_xmalloc(GM_MAX_HOST_NAME_LEN + 8,"MPI/ch_gm:read_conf");
		bzero(gmpi.node_names[count], GM_MAX_HOST_NAME_LEN + 8);
                bzero(line, 255);
		fgets(line, 255, conffile_stream);
		linecount++;
#if PRINT_CONFINFO
		clipit(line, 255);
		printf("look for nodes:  got line %d ==> '%s'\n", linecount, line);
#endif
		if (line[0] == '#') {
#if PRINT_CONFINFO
			printf("look for nodes:  line %d is a comment\n", linecount);
#endif
			continue;
		}
		num_read = sscanf(line, "%s %d %d", gmpi.node_names[count],
						  &gmpi.port_ids[count], &gmpi.board_ids[count]);
		switch (num_read) {
		 case 3:
			 /* OK, got node, port, board */
#if PRINT_CONFINFO
			 printf("look for nodes:  line %d has node,port,board\n", linecount);
#endif
			 break;

		 case 2:
			 /* OK, got node, port - set board to zero */
#if PRINT_CONFINFO
			 printf("look for nodes:  line %d has node,port - set board\n", linecount);
#endif
			 gmpi.board_ids[count] = 0;
			 break;

		 case 1:
			 fprintf(stderr, "Syntax error on line %d of '%s'\n", linecount, fn);
			 exit(1);
			 break;

		 default:
			 /* empty line? */
#if PRINT_CONFINFO
			 printf("look for nodes:  line %d is blank?\n", linecount);
#endif
			 continue;
			 break;
		}						/* switch num_read */

		if ((num_read == 2) || (num_read == 3)) {

			if (gmpi.board_ids[count] != 0) {
				/* append the ":1 :2 :3 etc for the board number */
				sprintf(gmpi.node_names[count], "%s:%x", gmpi.node_names[count], gmpi.board_ids[count]);
			}
			count++;
		}
	}
	fclose(conffile_stream);

#if PRINT_CONFINFO
	printf("found %d nodes\n", count);
#endif
	for (i = 0; i < count; i++) {
		/* sanity check */
		if (!gmpi.node_names[i][0] ||
				(gmpi.port_ids[i] < 1)) {

			fprintf(stderr, "Error getting node port,board info[%d]\n", i);
			fprintf(stderr, "  node = '%s' port = %d  board = %d\n",
					gmpi.node_names[i], gmpi.port_ids[i], gmpi.board_ids[i]);
			exit(1);
		}
#if PRINT_CONFINFO
		printf("name = %s, port = %d, board = %d\n",
			   gmpi.node_names[i], gmpi.port_ids[i], gmpi.board_ids[i]);
		fflush(stdout);
#endif
	}
}

#endif /* BIP */

