#include "gmpi.h"
#include "smpi.h"
#include "mpiddev.h"
#include "mpimem.h"

/* This function fill the MPID_Config structure to describe the multi-devices configuration */
MPID_Config * MPID_GetConfigInfo(int  * argc, char *** argv, void * config, int  *error_code)
{
  MPID_Config * new_config = NULL;
  MPID_Config * return_config = NULL;
  char *cp, *cq;
  int i, j;

  /* already configured ? */
  if (config != NULL)
    return (MPID_Config *)config;

  /* read the GM config file and the environnement variables */
  gmpi_getconf();

  /* search the number of local processes */
  smpi.num_local_nodes = 0;
  /* rip off :board specifier when doing comparisons to figure out
     smp-ness */
  if ((cp = strrchr(gmpi.node_names[MPID_MyWorldRank], ':')))
    *cp = 0;
  for (i=0; i < MPID_MyWorldSize; i++) {
    smpi.local_nodes[i] = -1; 
    if ((cq = strrchr(gmpi.node_names[i], ':')))
      *cq = 0;
    if (strcmp(gmpi.node_names[i], gmpi.node_names[MPID_MyWorldRank]) == 0) {
      /* Same node name, me or another process ? */
      if (i == MPID_MyWorldRank)
	smpi.my_local_id = smpi.num_local_nodes;
      smpi.local_nodes[i] = smpi.num_local_nodes;
      smpi.num_local_nodes++;
    }
    if (cq)
      *cq = ':';
  }
  if (cp)
    *cp = ':';
  
  /* at least one local node : myself ! */ 
  smpi_always_assert(smpi.num_local_nodes != 0);
  

 /* SELF DEVICE */
  /* if it's the first device, start the linked list of devices.
     Otherwise, add a new one at the end. */
  if (new_config == NULL) {
    new_config = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
    smpi_always_assert(new_config);
    return_config = new_config;
  } else {
    new_config->next = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
    smpi_always_assert(new_config->next);
    new_config = new_config->next;
  }
  /*we don't need to check if we need this device: we need this device ! */
  new_config->device_init = MPID_CH_InitSelfMsg;
  new_config->device_init_name = (char *)gmpi_xmalloc(255 * sizeof(char),"MPI/smp_plug");
  sprintf(new_config->device_init_name, "Self device");
  new_config->num_served = 1;
  new_config->granks_served = (int *)gmpi_xmalloc(sizeof(int),"MPI/smp_plug");
  new_config->granks_served[0] = MPID_MyWorldRank;
  new_config->next = NULL;


  /* SMP DEVICE */
  /* we don't need this device if there's only one process on this node */
  if (smpi.num_local_nodes > 1) {
    if (new_config == NULL) {
      new_config = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
      smpi_always_assert(new_config);
      return_config = new_config;
    } else {
      new_config->next = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
      smpi_always_assert(new_config->next);
      new_config = new_config->next;
    }
    new_config->device_init = MPID_SMP_InitMsgPass;
    new_config->device_init_name = (char *)gmpi_xmalloc(255 * sizeof(char),"MPI/smp_plug");
    sprintf(new_config->device_init_name, "SMP_plug device");
    new_config->num_served = smpi.num_local_nodes - 1;
    new_config->granks_served = (int *)gmpi_xmalloc(new_config->num_served * sizeof(int),"MPI/smp_plug");
    /* setup routes */
    j = 0;
    for(i=0; i<MPID_MyWorldSize; i++)
      if ((i!= MPID_MyWorldRank) && (smpi.local_nodes[i] != -1)) {
	smpi_always_assert(smpi.local_nodes[i] != smpi.my_local_id);
	new_config->granks_served[j] = i;
	j++;
      }
    smpi_always_assert(j == new_config->num_served);
    new_config->next = NULL;
  }


  /* GM DEVICE */
  /* We are not OBLIGED to use Myrinet and GM. */
  if (MPID_MyWorldSize > smpi.num_local_nodes) {
    if (new_config == NULL) {
      new_config = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
      smpi_always_assert(new_config);
      return_config = new_config;
    } else {
      new_config->next = (MPID_Config *)MALLOC( sizeof(MPID_Config) );
      smpi_always_assert(new_config->next);
      new_config = new_config->next;
    }
    new_config->device_init = MPID_CH_InitMsgPass;
    new_config->device_init_name = (char *)gmpi_xmalloc(255 * sizeof(char),"MPI/smp_plug");
    sprintf(new_config->device_init_name, "Myricom GM device");
    new_config->num_served = MPID_MyWorldSize - smpi.num_local_nodes;
    new_config->granks_served = (int *)gmpi_xmalloc(new_config->num_served * sizeof(int),"MPI/smp_plug");
    /* setup the routes */
    j = 0;
    for(i=0; i<MPID_MyWorldSize; i++)
      if (smpi.local_nodes[i] == -1) {
	new_config->granks_served[j] = i;
	j++;
      }
    smpi_always_assert(j == new_config->num_served);
    new_config->next = NULL;
  }

  return return_config;
}

