/*
Date: Fri, 17 Mar 2000 05:47:50 +0900
From: Takahashi Toshiyuki <tosiyuki@trc.rwcp.or.jp>
*/

#include "mpi.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define	N(len)		((len) < 1024 ? 10000 : (len) < 10*1024 ? 1000 : 100)
#define	ELAPSE		5
#define	LENGTH		8

int my_rank, comm_size;
int array[4 * 1024 * 1024 / sizeof(int)];

void
test(int length, int iteration)
{
	int i, k;
	char *p;
	MPI_Status status;

	k = length / sizeof(int);
	p = (char *) array;
	if (my_rank == 0) {
		for (i = 0; i < iteration; i++) {
			MPI_Send(p, k, MPI_INT, my_rank + 1, 1000, MPI_COMM_WORLD);
			MPI_Recv(p,
					 k, MPI_INT, my_rank + 1, 1000, MPI_COMM_WORLD, &status);
		}
	}
	else {
		for (i = 0; i < iteration; i++) {
			MPI_Recv(p,
					 k, MPI_INT, my_rank - 1, 1000, MPI_COMM_WORLD, &status);
			MPI_Send(p, k, MPI_INT, my_rank - 1, 1000, MPI_COMM_WORLD);
		}
	}
}

int
main(int argc, char **argv)
{
	int iteration = -1, elapse = ELAPSE, length = LENGTH;
	double time0, time1;
	MPI_Status status;

	MPI_Init(&argc, &argv);
	MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
	MPI_Comm_size(MPI_COMM_WORLD, &comm_size);

	--argc;
	++argv;
	memset(array, 0, sizeof(array));
	while (argc > 0) {
		if (strcmp(argv[0], "-iter") == 0) {
			iteration = atoi(argv[1]);
			argc -= 2;
			argv += 2;
			continue;
		}
		if (strcmp(argv[0], "-elapse") == 0) {
			elapse = atoi(argv[1]);
			argc -= 2;
			argv += 2;
			continue;
		}
		if (strcmp(argv[0], "-len") == 0) {
			length = atoi(argv[1]);
			argc -= 2;
			argv += 2;
			continue;
		}
	}

	if (iteration < 0) {
		MPI_Barrier(MPI_COMM_WORLD);

		if (my_rank == 0)
			time0 = MPI_Wtime();

		test(length, N(length));

		if (my_rank == 0) {
			time1 = MPI_Wtime();
			iteration = (double) elapse / (time1 - time0) * N(length);
			MPI_Send(&iteration,
					 1, MPI_INT, my_rank + 1, 1000, MPI_COMM_WORLD);
		}
		else
			MPI_Recv(&iteration,
					 1, MPI_INT, my_rank - 1, 1000, MPI_COMM_WORLD, &status);
	}

	MPI_Barrier(MPI_COMM_WORLD);

	if (my_rank == 0)
		time0 = MPI_Wtime();

	test(length, iteration);

	if (my_rank == 0) {
		double round_trip_time;

		round_trip_time = ((MPI_Wtime() - time0)*1000000.0) / (((double) iteration));
		printf("%d\t%12.1f\t%12.1f\n",
			   length, round_trip_time, round_trip_time/2);
		fflush(stdout);
	}

	MPI_Finalize();

	exit(0);
}
