/*
**  time.h              ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/


#ifndef _TIME_H
#define _TIME_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

#ifndef NULL
#if defined(__STDC__) || defined(__NDPX__)
#define NULL    ((void *)0L)
#else
#define NULL    ((char *)0L)
#endif
#endif  /* NULL */

#define CLK_TCK     100

#define CLOCKS_PER_SEC  CLK_TCK

typedef unsigned int clock_t;

#ifndef _TIME_T
#define _TIME_T
typedef unsigned long time_t;
#endif

struct tm {
    int tm_sec;             /* seconds of the minute, [0,59] */
    int tm_min;             /* minutes of the hour, [0,59] */
    int tm_hour;            /* hour of the day, [0,23] */
    int tm_mday;            /* day of the month, [1,31] */
    int tm_mon;             /* months since Jan, [0,11] */
    int tm_year;            /* years since 1900 */
    int tm_wday;            /* days since Sun, [0,6] */
    int tm_yday;            /* days since Jan 1, [0,365] */
    int tm_isdst;           /* daylight savings time */
};

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

clock_t   sec_micro(void);
clock_t   clock(void);
double    difftime(time_t _Time1, time_t _Time0);
time_t    mktime(struct tm *_Timeptr);
time_t    time(time_t *_Timer);
char *    asctime(const struct tm *_Timeptr);
char *    ctime(const time_t *_Timer);
struct tm *gmtime(const time_t *_Timer);
struct tm *localtime(const time_t *_Timer);
size_t    strftime(char *_S, size_t _Maxsize, const char *_Format,
                const struct tm *_Timeptr);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

clock_t   sec_micro();
clock_t   clock();
double    difftime();
time_t    mktime();
time_t    time();
char *    asctime();
char *    ctime();
struct tm *gmtime();
struct tm *localtime();
size_t    strftime();

#endif /* __STDC__ || __NDPX__ */
#endif /* _TIME_H */

