/*
**  stat.h              ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _STAT_H
#define _STAT_H

#include <sys/types.h>
struct stat {
        dev_t   st_dev;         /* Id of device containing directory entry. */
        ino_t   st_ino;         /* Checksum = f(path, file-name). */
        ushort  st_mode;        /* File attribute. */
        short   st_nlink;       /* Not used. */
        ushort  st_uid;         /* Not used. */
        ushort  st_gid;         /* Not used. */
        dev_t   st_rdev;        /* Not used. */
        off_t   st_size;        /* File size in bytes. */
        time_t  st_atime;       /* Not used. */
        time_t  st_mtime;       /* Time of last data write. */
        time_t  st_ctime;       /* Date of last data write. */
                                /* Time/date in standard DOS format - */
                                /* see description of function 4e of int 21. */

};

#define S_IFMT          0xf000  /* File type field mask. */
#define S_IFREG         0x8000  /* Regular type file. */

#define S_IFDIR 	0040000 /* directory */
#define S_IFCHR 	0020000 /* character special */
#define S_IFBLK 	0060000 /* block special */
#define S_IFIFO 	0010000 /* fifo */
#define S_IFNAM 	0050000 /* special named file */

#define S_IRWXU 	00700   /* read, write, execute: owner */
#define S_IRUSR 	00400   /* read permission: owner */
#define S_IWUSR 	00200   /* write permission: owner */
#define S_IXUSR 	00100   /* execute permission: owner */
#define S_IRWXG 	00070   /* read, write, execute: group */
#define S_IRGRP 	00040   /* read permission: group */
#define S_IWGRP 	00020   /* write permission: group */
#define S_IXGRP 	00010   /* execute permission: group */
#define S_IRWXO 	00007   /* read, write, execute: other */
#define S_IROTH 	00004   /* read permission: other */
#define S_IWOTH 	00002   /* write permission: other */
#define S_IXOTH 	00001   /* execute permission: other */
#define S_ISUID 	04000   /* set user id on execution */
#define S_ISGID 	02000   /* set group id on execution */

#define S_INSEM 	01      /* XENIX semaphore subtype of IFNAM file */
#define S_INSHD 	02      /* XENIX shared data subtype of IFNAM file */
#define S_ISVTX 	01000   /* save swapped text even after use */
#define S_IEXEC 	00100   /* execute/search permission, owner */
#define S_ENFMT 	S_ISGID /* record locking enforcement flag */

#ifndef _OS_H

#define S_IREAD     	0x100   /* read permission, owner */
#define S_IWRITE    	0x080   /* write permission, owner */

#endif /* _OS_H */

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __NDPX__			/* C++ */
   extern "C" {
#endif

#ifndef __NDPX__
int stat(char *_Fname, struct stat *_Stat_ptr);
#endif

int fstat(int _HFile, struct stat *_Stat_ptr);

#ifdef __NDPX__			/* C++ */
   }
#endif

#else

int stat();
int fstat();

#endif /* STDC || NDPX */
#endif  /* _STAT_H */
