/*
**  stdio.h             ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _STDIO_H
#define _STDIO_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

/* defined in stdarg.h */
#ifndef _VA_LIST
#define _VA_LIST

#if defined(__ALPHA__)

typedef struct
 {
  unsigned int sp_offset;  /* byte offset of the parameter in the stack    */
  unsigned int rr_offset;  /* byte offset of the parameter in the core reg */
  unsigned int fr_offset;  /* byte offset of the parameter in the fp reg   */
  unsigned int rr_max_offset;  /* maximum byte offset in the core reg      */
  unsigned int fr_max_offset;  /* maximum byte offset in the fp reg        */
  char *sp_buf;    /* stack parameter space     */
 }
va_list;

#else

typedef char *va_list;

#endif

#endif

typedef struct {
   int _Level;   /* Count of items in buffer:
                           >0 Read mode (characters left)
                           <0 Write mode (positions left)
                           =0 Unbuffered (or read buffer empty)
                           Since full buffers are flushed immediately,
                           0 cannot mean write buffer full
                        */
   unsigned _Flags;        /* Bit map info - positions described below */
   char _Fd;               /* File descriptor returned by UNIX */
   unsigned char _Hold;    /* Ungetc char if no buffer */
   unsigned _Bsize;        /* Size of the buffer (0=no buffering) */
   unsigned char *_Buffer;
   unsigned char *_Curp;   /* Pointer to current position in buffer */
   char *_Tmpnam;	  /* Temporary name, file to be deleted on close */
} FILE;

typedef unsigned fpos_t;

#ifndef NULL
#if defined(__STDC__) || defined(__NDPX__)
#define NULL    ((void *)0L)
#else
#define NULL    ((char *)0L)
#endif
#endif  /* NULL */

#define _IOFBF          0
#define _IOLBF          1
#define _IONBF          2
#define _IOSBF          3

#define BUFSIZ          8192
#define EOF             (-1)
#define FOPEN_MAX       64
#if defined (__MSDOS__)
#define FILENAME_MAX    63
#elif defined(__OS2__) || defined(__WIN32__)
#define FILENAME_MAX    256
#else
#define FILENAME_MAX    1023    /* should this be 14 under sysV?, 127 bsd? */
#endif

#if defined (__MSDOS__) || defined(__OS2__) || defined(__WIN32__)
#define L_tmpnam         9
#else
#define L_tmpnam        32
#endif

#define SEEK_CUR        1
#define SEEK_END        2
#define SEEK_SET        0

#define TMP_MAX         2600000

#define _LINEBUF 8
#define __ERR     16
#define _EOF     32
#define _LINE_FULL(fp,c)        ((c) == '\n' && ((fp)->_Flags & _LINEBUF))

#define stdin (&_iob[0])
#define stdout (&_iob[1])
#define stderr (&_iob[2])

/* variables */
extern FILE _iob[FOPEN_MAX];

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

int      _Filbuf(FILE *);
int      _Flsbuf(char,FILE *);
void      clearerr(FILE *_Stream);
int       fclose(FILE *_Stream);
int       feof(FILE *_Stream);
int       ferror(FILE *_Stream);
int       fflush(FILE *_Stream);
int       fgetc(FILE *_Stream);
int       fgetpos(FILE *_Stream, fpos_t *_Pos);
char *    fgets(char *_S, int _N, FILE *_Stream);
FILE *    fopen(const char *_Filename, const char *_Mode);
int       fprintf(FILE *_Stream, const char *_Format, ...);
int       fputc(int _C, FILE *_Stream);
int       fputs(const char *_S, FILE *_Stream);
size_t    fread(void *_Ptr, size_t _Size, size_t _Nmemb, FILE *_Stream);
FILE *    freopen(const char *_Filename, const char *_Mode, FILE *_Stream);
int       fscanf(FILE *_Stream, const char *_Format, ...);
int       fseek(FILE *_Stream, long int _Offset, int _Whence);
int       fsetpos(FILE *_Stream, const fpos_t *_Pos);
long int  ftell(FILE *_Stream);
size_t    fwrite(const void *_Ptr, size_t _Size, size_t _Nmemb,
                FILE *_Stream);
int       getc(FILE *_Stream);
int       getchar(void);
char *    gets(char *_S);
void      perror(const char *_S);
int       printf(const char *_Format, ...);
int       putc(int _C, FILE *_Stream);
int       putchar(int _C);
int       puts(const char *_S);
int       remove(const char *_Filename);
int       rename(const char *_Old, const char *_New);
void      rewind(FILE *_Stream);
int       scanf(const char *_Format, ...);
void      setbuf(FILE *_Stream, char *_Buf);
int       setvbuf(FILE *_Stream, char *_Buf, int _Mode, size_t _Size);
int       sprintf(char *_S, const char *_Format, ...);
int       sscanf(const char *_S, const char *_Format, ...);
FILE *    tmpfile(void);
char *    tmpnam(char *_S);
int       ungetc(int _C, FILE *_Stream);
int       vfprintf(FILE *_Stream, const char *_Format, va_list _Arg);
int       vprintf(const char *_Format, va_list  _Arg);
int       vsprintf(char *_S, const char *_Format, va_list _Arg);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

int      _Filbuf();
int      _Flsbuf();
void      clearerr();
int       fclose();
int       feof();
int       ferror();
int       fflush();
int       fgetc();
int       fgetpos();
char *    fgets();
FILE *    fopen();
int       fprintf();
int       fputc();
int       fputs();
size_t    fread();
FILE *    freopen();
int       fscanf();
int       fseek();
int       fsetpos();
long int  ftell();
size_t    fwrite();
int       getc();
int       getchar();
char *    gets();
void      perror();
int       printf();
int       putc();
int       putchar();
int       puts();
int       remove();
int       rename();
void      rewind();
int       scanf();
void      setbuf();
int       setvbuf();
int       sprintf();
int       sscanf();
FILE *    tmpfile();
char *    tmpnam();
int       ungetc();
int       vfprintf();
int       vprintf();
int       vsprintf();

#endif  /* __STDC__ || __NDPX__ */


#ifndef __MLTTHRD__

/* These macros evaluate stream variable 'fp' more then once, so do not use
   expression arguments with side effects.
*/

#define getc(fp)        (--(fp->_Level) >= 0 ? \
                        ((int)*(fp->_Curp++)) : _Filbuf(fp))

#define putc(_C,fp)     ((fp->_Hold=(_C),++(fp->_Level)) < 0 && \
                                !_LINE_FULL(fp,fp->_Hold) ? \
                                ((int)(*(fp->_Curp++) = fp->_Hold)) : \
                                _Flsbuf(fp->_Hold,fp))

#define getchar()       getc(stdin)
#define putchar(_C)     putc(_C, stdout)


/* The following stream functions are better written as macros. */
#define feof(fp)      (fp->_Flags & _EOF)
#define ferror(fp)    (fp->_Flags & __ERR)
#define clearerr(fp)  (fp->_Flags &= ~(_EOF | __ERR))

#endif


#endif  /* _STDIO_H */

