/*
**  memory.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _MEMORY_H
#define _MEMORY_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif  /* _SIZE_T */

#ifndef _OS_H

#define _fmemcpy( _A, _B, _C )     memcpy( (_A), (_B), (_C) )
#define _fmemchr( _A, _B, _C )     memchr( (_A), (_B), (_C) )
#define _fmemcmp( _A, _B, _C )     memcmp( (_A), (_B), (_C) )
#define _fmemset( _A, _B, _C )     memset( (_A), (_B), (_C) )
#define _fmemccpy( _A, _B, _C, _D ) memccpy( (_A), (_B), (_C), (_D) )
#define _fmemicmp( _A, _B, _C )    memicmp( (_A), (_B), (_C) )

#endif /* _OS_H */

#if defined(__STDC__) || defined(__NDPX__)


#ifdef __NDPX__     /* C++ */
    extern "C" {
#endif

void *    memccpy(void *_Dest, void *_Src, int _C, unsigned _Count);
void *    memchr(const void *_S, int _C, size_t _N);
int       memcmp(const void *_S1, const void *_S2, size_t _N);
void *    memcpy(void *_S1, const void *_S2, size_t _N);
int       memicmp(void *_S1, void *_S2, unsigned int _N);
void *    memmove(void *_S1, const void *_S2, size_t _N);
void *    memset(void *_S, int _C, size_t _N);


#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

void *    memccpy();
void *    memchr();
int       memcmp();
void *    memcpy();
int       memicmp();
void *    memmove();
void *    memset();

#endif  /* __STDC__ || __NDPX__ */
#endif /* _MEMORY_H */
