/*
**  locale.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _LOCALE_H
#define _LOCALE_H

struct lconv {
    char *decimal_point;        /* "." */
    char *thousands_sep;        /* "" */
    char *grouping;             /* "" */
    char *int_curr_symbol;      /* "" */
    char *currency_symbol;      /* "" */
    char *mon_decimal_point;    /* "" */
    char *mon_thousands_sep;    /* "" */
    char *mon_grouping;         /* "" */
    char *positive_sign;        /* "" */
    char *negative_sign;        /* "" */
    char int_frac_digits;       /* CHAR_MAX */
    char frac_digits;           /* CHAR_MAX */
    char p_cs_precedes;         /* CHAR_MAX */
    char p_sep_by_space;        /* CHAR_MAX */
    char n_cs_precedes;         /* CHAR_MAX */
    char n_sep_by_space;        /* CHAR_MAX */
    char p_sign_posn;           /* CHAR_MAX */
    char n_sign_posn;           /* CHAR_MAX */
};

#ifndef NULL
#if defined(__STDC__) || defined(__NDPX__)
#define NULL    ((void *)0L)
#else
#define NULL    ((char *)0L)
#endif
#endif  /* NULL */

#define LC_ALL              (LC_COLLATE|LC_CTYPE|LC_MONETARY|LC_NUMERIC|LC_TIME)
#define LC_COLLATE          (1<<0)
#define LC_CTYPE            (1<<1)
#define LC_MONETARY         (1<<2)
#define LC_NUMERIC          (1<<3)
#define LC_TIME             (1<<4)

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

char *setlocale(int category_, const char *locale_);
struct lconv *localeconv(void);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */
char *setlocale();
struct lconv *localeconv();

#endif  /* __STDC || __NDPX__ */
#endif /* _LOCALE_H */

