/*  
**  generic.h		C++ Runtime
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail tech@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef __GENERIC_H
# define __GENERIC_H

# define name2(a,b) a##b
# define name3(a,b,c) a##b##c
# define name4(a,b,c,d) a##b##c##d

# define declare(a,t)	name2(a,declare)(t)
# define implement(a,t)   name2(a,implement)(t)
# define declare2(a,t1,t2)   name2(a,declare2)(t1,t2)
# define implement2(a,t1,t2)   name2(a,implement2)(t1,t2)

#ifndef __cplusplus
overload genericerror;
#endif
extern int genericerror(int,char *);
typedef int (*GPT)(int,char *);

# define set_handler(generic,type,x) name4(set_,type,generic,_handler)(x)
# define errorhandler(generic,type) name3(type,generic,handler)
# define callerror(generic,type,a,b) (*errorhandler(generic,type))(a,b)

#endif
