/*
**  fcntl.h             ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _FCNTL_H
#define _FCNTL_H

#ifndef __OS_H

/* File mode constants */
#define O_RDONLY    0x00000000  /* file open for read only */
#define O_WRONLY    0x00000001  /* file open for write only */
#define O_RDWR      0x00000002  /* file open for read & write */
#define O_APPEND    0x00000008  /* seek to end of file before writing */
#define O_BINARY    0x00008000  /* do not translate LF <-> CR LF */
#define O_TEXT      0x00004000  /* translate LF <-> CR LF */
#define O_CREAT     0x00000100  /* if file doesn't exist, create new one */
#define O_TRUNC     0x00000200  /* if file already exists, truncate it */
#define O_EXCL      0x00000400  /* if file doesn't exist already, don't open */
#define O_NOINHERIT 0x00000080  /* child process doesn't inherit file */
#define O_RAW       O_BINARY


#define O_NONBLOCK  0x00000004	/* non-blocking I/O, POSIX style */
#define O_NOCTTY    0x00001000  /* POSIX REQUIRED */
#define O_DEFER     0x00000040	/* defered update		*/
#define O_NDELAY    0x00010000	/* Non-blocking I/O		*/


#endif /* __OS_H */

#endif /* _FCNTL_H */
