divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.macros.m4,v 1.2 1998/05/07 21:13:41 gafton Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#

#****************************************************************************#
#* Beware changing anything beyond here:                                    *#
#* M4 preprocessing can be tricky.  Read the info page, the man page, and   *#
#* look at examples if you have problems                                    *#
#****************************************************************************#

###############################################################################
# m4 utility macro constructs#
# Some of these came from examples distributed with m4

define(`forloop',
	`pushdef(`$1',`$2')_forloop(`$1', `$2', `$3', `$4')popdef(`$1')')
define(`_forloop',
	`$4`'ifelse($1,`$3', ,
    `define(`$1',incr($1))_forloop(`$1',`$2',`$3',`$4')')')

#eg. forloop(i,1,8,`i ') -> 1 2 3 4 5 6 7 8 

define(`foreach', `pushdef(`$1', `')_foreach(`$1', `$2', `$3')popdef(`$1')')
define(`_arg1', `$1')
define(`_foreach', 
	`ifelse(`$2', `()', ,
		`define(`$1', _arg1$2)$3`'_foreach(`$1', (shift$2), `$3')')')

#eg. foreach(x,`(first,second,third)',`Values is x ')
define(`upcase', `translit(`$*', `a-z', `A-Z')')
define(`downcase', `translit(`$*', `A-Z', `a-z')')
define(`capitalize1', `regexp(`$1', `^\(\w\)\(\w*\)', `upcase(`\1')`'downcase(`\2')')')
define(`capitalize', `patsubst(`$1', `\w+', ``'capitalize1(`\&')')')
define(`spaceto_', `translit(`$*', ` ', `_')')
define(`m4_basename',`regexp($1,`.*/\([^/]+\)',`\1')')

# These are defined early for .defines and .defaults
define(`IfProgramExists',`syscmd(type $1 >/dev/null 2>&1)ifelse(sysval,0,`$2',`#$1 not found')')
define(`IfElseProgramExists',`syscmd(type $1 >/dev/null 2>&1)ifelse(sysval,0,`$2',`$3')')
define(`IfProgramExistsOrError',`syscmd(type $1 >/dev/null 2>&1)ifelse(sysval,0,`$2',`$1_in_an_xterm not found')')

# A ProgramName is just the first word (delimited by whitespace) in the argument
define(`ProgramName',`regexp($1,`[^ ]+',`\&')')

define(`TraceForErrors',`syscmd(echo $1 >&2)')
# ForcedErrorForTracePurposes_$1')

ifdef(`NO_TRACE_FVWM_PARSE',
`define(`TraceForErrors',`')')

# Macro AddAmpersand for auto-picking a menu shortcut key
define(`m4_first_character',`substr(`$1',0,1)')
define(`m4_after_first_character',`substr(`$1',1)')

define(`m4_first_character_in',`index($2,upcase(m4_first_character($1)))')

#AmpersandFirstCharNotIn <title-to-insert-ampersand> <chars-to-skip>
define(`AmpersandFirstCharNotIn',`dnl
ifelse(len($1),0,`',`dnl
ifelse(m4_first_character_in($1,$2),`-1',`&$1',`m4_first_character($1)`'AmpersandFirstCharNotIn(m4_after_first_character($1),$2)')')')

define(`m4_char_after_ampersand',`upcase(regexp(`$1',`\&\(\w\)',`\1'))')

# AddAmpersand (<string>,<menu>)
define(`AddAmpersand',`ifdef($2`'_SHORTCUT_KEYS,`',`define(`$2_SHORTCUT_KEYS',`')')dnl
define(`m4_new_string',AmpersandFirstCharNotIn($1,$2`'_SHORTCUT_KEYS))dnl
define(`$2_SHORTCUT_KEYS',$2_SHORTCUT_KEYS`'m4_char_after_ampersand(m4_new_string))dnl
m4_new_string')

# ShortcutKey (<string>,<menu>)
define(`ShortcutKey',`m4_char_after_ampersand(AddAmpersand($1,$2))')

divert

