#include <stdio.h>
#include <string.h>
#include <dirent.h>

#include "libcsv.h"

#include "parcel.h"

static struct csv_table us_ups_pricing[100];
char *us_ups_pricing_name[100];
int us_ups_pricing_offset[100];

static int is_us_ups_pricing(struct csv_table *t, int *n)
{
	int w= -1;
	int i;
	
	for(i=0;i<30;i++)
	{	
		/* Some tables have this, some have it split */
		if(strcmp(CSV_ITEM(t,i,0), "Weight Not To Exceed")==0)
			w=i;
		if(strcmp(CSV_ITEM(t, i, 0), "Exceed")==0)
			w=i;
	}
	
	*n = w;
	
	if(w != -1 )
		return 0;
		
	return -1;
}

char *us_ups_zone_to_price(char *zone, int type, char *weight, int surcharge)
{
	int znum;
	int z;
	float wval;
	float wdat;
	int i;
	static char buf[64];
	
	if(sscanf(zone,"%d", &znum)!=1 ||
		sscanf(weight, "%f", &wdat)!=1)
	{
		sock_printf("W: Format error in zone to price.\n");
		return NULL;
	}

	/* Walk the zone names */
	for(i=1; i<CSV_WIDTH(&us_ups_pricing[type], us_ups_pricing_offset[type]);i++)
	{
		char *p=CSV_ITEM(&us_ups_pricing[type], us_ups_pricing_offset[type], i);
		if(sscanf(p, " Zone %d", &z)!=1 &&
			sscanf(p, "%d", &z)!=1)
		{
			sock_printf("W: bad '%s'\n",p);
			continue;
		}
		if(z!=znum)
			continue;

		/*
		 *	Ok first loop is done. Save the column for the zone
		 *	as z and reuse i for the next loop - now we go down
		 *	the table finding the weight.
		 */
		 			
		z=i;
		
		/*
		 *	Ok found it. Now find the pricing
		 */
		for(i=us_ups_pricing_offset[type]+1; i<us_ups_pricing[type].height;i++)
		{
			if(sscanf(CSV_ITEM(&us_ups_pricing[type],i,0), "%f", &wval)!=1)
				continue;
			if(wval>=wdat)
			{
				float f;
				char *p=CSV_ITEM(&us_ups_pricing[type],i,z);
				p=uncomma(p);
				if(*p=='$')
					p++;
				sscanf(p, "%f", &f);
				if(surcharge)
					f+=1.0;
				sprintf(buf, "%d.%02d", (int)f, ((int)(f*100.0))%100);
				return buf;
			}
				
		}
		return NULL;	/* Too heavy */
	}
	return NULL;	/* Not found */
}

void ups_load_rates(void)
{
	struct csv_table t;
	int i=1;
	
	/*
	 *	These MUST match the zone table order provided by UPS.
	 */
	 
	char *load[]={
		"",
		"USRate/gndcomm.csv",
		"USRate/3ds.csv",
		"USRate/2da.csv",
		"USRate/2dam.csv",
		"USRate/1dasaver.csv",
		"USRate/1da.csv",
		NULL
	};
	
	while(load[i]!=NULL)
	{
		FILE *f;

		f=fopen(load[i],"r");
		if(f==NULL)
		{
			perror(load[i]);
			exit(1);
		}
		if(csv_load_table(f, &t)==-1)
		{
			fprintf(stderr,"%s: failed at line %d: %s.\n",
				load[i], csv_line, csv_error);
			exit(1);
		}
		fclose(f);
		if(is_us_ups_pricing(&t, &us_ups_pricing_offset[i])==-1)
		{
			fprintf(stderr,"%s: not a valid UPS US rate file.\n",
				load[i]);
			exit(1);
		}
		us_ups_pricing[i]=t;
		us_ups_pricing_name[i]=CSV_ITEM(&t,0,0);
		i++;
	}
}	
