#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "parcel.h"


/*
 *	Demonstration client. Run with
 *	us_client src_zip dst_zip weight
 */
 
void main(int argc, char *argv[])
{
	int s;
	struct sockaddr_in sin;
	char buf[256];
	int len;
	
	if(argc!=4)
	{	
		fprintf(stderr,"%s: usage %s [srczip] [dstzip] [weight].\n",
			argv[0], argv[0]);
		exit(1);
	}
	
	s=socket(AF_INET, SOCK_STREAM, 0);
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY; 	/* This machine */
	sin.sin_port = htons(PORT);
	
	if(connect(s, (struct sockaddr_in *)&sin, sizeof(sin))==-1)
	{
		perror("connect");
		exit(1);
	}
	
	write(s, "\r\n\r\n", 4);
	write(s, argv[1], strlen(argv[1]));
	write(s, "\r\n\r\n\r\nUSA\r\n", 11);
	write(s, argv[2], strlen(argv[2]));
	write(s, "\r\n", 2);
	write(s, argv[3], strlen(argv[3]));
	write(s, "\r\nffffffff\r\n", 13);
	
	/* Now wait reply */
	
	while((len=read(s, buf, 256))>0)
		write(1, buf, len);
	if(len==-1)
		perror("end");		
	close(s);
}
