/*
 *	Glibc doesnt seem to like stdio on sockets. Sucky.
 */

#define _GNU_SOURCE
#include <stdarg.h>
#include <stdio.h>
#include <unistd.h>
 
static int skfd=1;

void set_socket_fd(int fd)
{
	skfd=fd;
}

void sock_printf(const char *format, ...)
{
	va_list ap;
	char buf[4096];
	int len;
	
	va_start(ap, format);
	len=vsnprintf(buf, sizeof(buf), format, ap);
	
	va_end(ap);
	
	if(write(skfd, buf, len)!=len)
		perror("write");
}

static char sockinput[1024];
static int sockiptr=0;
static int sockilen=0;

int sock_gets(char *buf, int len)
{
	int ct=0;
	do
	{
		if(sockiptr==sockilen)
		{
			sockilen=read(skfd, sockinput, sizeof(sockinput));
			if(sockilen<=0)
				return -1;
			sockiptr=0;
		}
		*buf=sockinput[sockiptr++];
		if(*buf=='\n')
		{
			buf[1]=0;
			return ct+1;
		}
		buf++;
		ct++;
	}
	while(ct<len-1);
	return ct+1;
}
