#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <math.h>

#include "libcsv.h"

#include "parcel.h"

static struct csv_table ups_world_zone[3];
//static struct csv_table ups_world_eas;
static struct csv_table ups_world_rate[3][2];

struct state_data 
{
	char *name;
	int type;
	/* 1 - Florida 2 - East 3 - West */
};

static struct state_data state_names[51]=
{
	/* Florida is odd */
	{"Florida",1},
	/* Eastern USA */
	{"Alabama", 2},
	{"Connecticut", 2},
	{"Delaware", 2},
	{"District of Columbia", 2},
	{"Georgia",2},
	{"Illinois",2},
	{"Indiana",2},
	{"Iowa",2},
	{"Kentucky",2},
	{"Maine",2},
	{"Maryland",2},
	{"Massachusetts",2},
	{"Michigan",2},
	{"Missouri",2},
	{"New Hampshire",2},
	{"New Jersey",2},
	{"New York",2},
	{"North Carolina",2},
	{"Ohio",2},
	{"Pennsylvania",2},
	{"Rhode Island",2},
	{"South Carolina",2},
	{"Tennessee",2},
	{"Vermont",2},
	{"Virginia",2},
	{"West Virginia",2},
	{"Wisconsin",2},
	/* Western USA */
	{"Alaska",3},
	{"Arizona",3},
	/* California is odd too, but not as far as UPS are concerned */
	{"California",3},
	{"Colorado",3},
	{"Hawaii",3},
	{"Idaho",3},
	{"Kansas",3},
	{"Louisiana",3},
	{"Minnesota",3},
	{"Mississippi",3},
	{"Montana",3},
	{"Nebraska",3},
	{"Nevada",3},
	{"New Mexico",3},
	{"North Dakota",3},
	{"Oklahoma",3},
	{"Oregon",3},
	{"South Dakota",3},
	{"Texas",3},
	{"Utah",3},
	{"Washington",3},
	{"Wyoming",3},
	{NULL,}
};

char *country_names[512];	/* More than enough for now */
int country_count=0;

static void open_load(char *p, struct csv_table *t)
{
	FILE *f=fopen(p,"r");
	if(f==NULL)
	{
		perror(p);
		exit(1);
	}
	if(csv_load_table(f, t)==-1)
	{
		fprintf(stderr, "Format error in table '%s'.\n",p);
		exit(1);
	}
	fclose(f);
}

void ups_world_load(void)
{
	int i,j;

	static char *zones[3]={
		"WorldZone/dbwwzone.csv", 
		"WorldZone/ewwzone.csv", 
		"WorldZone/wwwzone.csv"
	};
	
	static char *zonerate[3][2]={
		{
			"WorldRate/dbww-xpr.csv",
			"WorldRate/dbww-xpd.csv",
		},		
		{
			"WorldRate/eww-xpr.csv",
			"WorldRate/eww-xpd.csv",
		},		
		{
			"WorldRate/www-xpr.csv",
			"WorldRate/www-xpd.csv",
		}
	};
	
	for(i=0;i<3;i++)
	{
		open_load(zones[i], &ups_world_zone[i]);
		for(j=0;j<2;j++)
			open_load(zonerate[i][j], &ups_world_rate[i][j]);
	}
//	open_load("WorldZone/wweas.csv", &ups_world_eas);
}

void world_ups_parcel_types(void)
{
	printf("12:UPS:Worldwide Express\n");
	printf("13:UPS:Worldwide Expedited\n");
}

void ups_country_load(void)
{
	int i;
	
	for(i=0; i<ups_world_zone[0].height;i++)
	{
		if(strcmp(CSV_ITEM(&ups_world_zone[0], i, 0), "Country")==0)
		{
			for(++i;i<ups_world_zone[0].height;i++)
			{
				char *x=CSV_ITEM(&ups_world_zone[0], i, 0);
				if(*x==0)
					break;
				country_names[country_count++]=x;
			}
		}
	}
}

/*
 *	Find the zone code for a world wide parcel delivery.
 */
 
int ups_country_zone(struct csv_table **p, int *type, char *srccounty, char *srcstate, char *dstcountry)
{
	int i;
	int ztype;
	struct csv_table *t;
	
	for(i=0;i<51;i++)
	{
		if(state_names[i].name==NULL)
		{
			sock_printf("F: unknown world shipping source '%s'.\n",
				srcstate);
			return -1;
		}
		if(strcasecmp(srcstate, state_names[i].name)==0)
			break;
	}

	/*
	 *	Florida is just plain odd
	 */
	 
	if((ztype=state_names[i].type)==1)
	{
		if(strcasecmp(srccounty,"Dade") &&
			strcasecmp(srccounty, "Browdard"))
			ztype=2;
	}
	
	t=&ups_world_zone[ztype-1];
	
	for(i=0;i<t->height;i++)
	{
		if(strcmp(CSV_ITEM(t,i,0),"Country")==0)
			break;
		i++;
	}
	if(i==t->height)
	{
		sock_printf("F: World zone data corrupt.\n");
		return -1;
	}
	
	for(i++;i<t->height;i++)
	{
		if(strcasecmp(CSV_ITEM(t,i,0), dstcountry)==0)
		{
			*p=t;
			*type=ztype;
			return i;
		}
	}
	sock_printf("F: No deliveries to this '%s'.\n", dstcountry);
	return -1;
}

/*
 *	Remove commas from price data. Mutter mutter
 */
 
char *uncomma(char *p)
{
	static char buf[64];
	char *dp=buf;
	while(*p)
	{
		if(*p!=',')
			*dp++=*p;
		p++;
	}
	*dp=0;
	return buf;
}

/*
 *	UPS World Pricing
 */
 
char *ups_world_pricing(struct csv_table *t, int type, int line, int class, char *weight, char *place, char *country, char *pcode)
{
	char *zone=CSV_ITEM(t,line,class+1);
	int i;
	struct csv_table *rt;
	int zv;
	int zw;
	int j;
	float wv,ww;
	static char buf[64];
	char *value;
	float wl, wh;
	
	sscanf(zone,"%d", &zw);
	sscanf(weight,"%f", &ww);
	
	/*
	 *	Now see what Zone info we have.
	 */
	 
	if(strcmp(zone,"")==0)
		return NULL;
	
	/*
	 *	Walk the Zone tables.
	 */
	 
	rt=&ups_world_rate[type-1][class];
	
	for(i=0;i<rt->height;i++)
	{
		if(strcmp(CSV_ITEM(rt,i,0),"Weight")==0)
			break;
	}
	if(i==rt->height)
	{
		sock_printf("F: Format error in World Zone data.\n");
		return NULL;
	}
	
	/*
	 *	Now find our zone code
	 */
	 
	for(j=1;j<CSV_WIDTH(rt,i);j++)
	{
		char *p=CSV_ITEM(rt,i,j);
		if(sscanf(p,"Zone %d",&zv)<=0)
			continue;
		if(zv==zw)
			break;
	}
	
	if(j==CSV_WIDTH(rt,i))
	{
		sock_printf("F: Format error - Zone %d not listed.\n", zw);
		return NULL;
	}
	
	/*
	 *	Ok we know the table, the column, so now we finish off
	 *	with a look for the weight 
	 */
	 
	for(++i;i<=rt->height;i++)
	{
		char *p=CSV_ITEM(rt,i,0);
		
		 
		/*
		 *	Skip any XX KG box lines. We dont handle those.
		 */
		if(p[2]=='K'&&p[3]=='G')
			continue;

		/*
		 *	Get the weight
		 */
		if(sscanf(p,"%f", &wv)<=0)
		{
			/*
			 *	Have we hit the ranged data yet ?
			 */
			if(strcmp(p,"Letter"))
				break;
		}
			
		/*
		 *	Found a weight category
		 */
		 
		if(wv>=ww)
		{
			value=CSV_ITEM(rt,i,j);
			if(*value=='$')
				value++;
			value=uncomma(value);
			goto eas;
		}
	}
	
	/*
	 *	We've hit the ranged data now
	 */	

	if(class==1)
	{	 
		/* Skip the "Rate Per Pound" and carry on table walking */

		for(++i;i<rt->height;i+=2)
		{
			int n;
			char *p=CSV_ITEM(rt,i,0);
					 
			/*
			 *	Get the weight range
			 */
			n=sscanf(p,"%f-%f", &wl, &wh);
			
			if(n==0)
				break;
				
			if(n==1)
				wh=99999999999.99;
			/*
			 *	Found a weight category
			 */
			 
			if(ww+1>=wl && ww <= wh)
			{
				/* Price per lb */
				p=CSV_ITEM(rt,i,j);
				if(sscanf(p, "$%f", &wl)<=0)
				{
					sock_printf("F: Format error in ranged data.\n");
					return NULL;
				}
				wl*=ceil((double)wv);
				/* Check versus minimum price */
				p=CSV_ITEM(rt,i+1,j);
				/* They used commas in some of these which rather
				   upsets sscanf .. sigh */
				if(sscanf(uncomma(p),"$%f", &wh)<=0)
				{
					sock_printf("F: Format error in ranged data minimum.\n");
					return NULL;
				}
				if(wh>wl)
					wl=wh;
				goto eas_2;
			}
		}
	}
	else
	{
		float ratio;
		float minimum;
		char *x;
		static char buf[32];
		
		i++;	/* Now on multipliers */
		x=CSV_ITEM(rt,i,j);
		if(*x=='$')
			x++;
		if(sscanf(x, "%f", &ratio)!=1)
		{
			sock_printf("F: format error in world zone read\n");
			return NULL;
		}
		i++;	/* Now on min */
		x=CSV_ITEM(rt,i,j);
		if(*x=='$')
			x++;
		if(sscanf(x, "%f", &minimum)!=1)
		{
			sock_printf("F: format error in world zone read min\n");
			return NULL;
		}
		
		ratio *= ceil(ww);	/* Yes they screw you on fractions */
		if(ratio < minimum)
			ratio = minimum; /* and screw you again if you havent
					    been screwed hard enough yet */
		
		wl=ratio;
		goto eas_2;
	}
	return NULL;	 

eas:
	sscanf(value, "%f", &wl);
eas_2:
	wl+=ups_world_eas_check(country, place, pcode, ww);
	sprintf(buf,"$%d.%02d",
		(int)wl, ((int)(wl*100))%100);
	return buf;

}
