#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <math.h>

#include "libcsv.h"

#include "parcel.h"

/*
 *	UPS extortionate additional surcharge tables
 */
 
static struct csv_table eas_table;


void ups_world_eas_load(void)
{
	FILE *fp=fopen("WorldZone/wweas.csv", "r");
	if(fp==NULL)
	{
		perror("WorldZone/wweas.csv");
		exit(1);
	}
	
	if(csv_load_table(fp, &eas_table)<0)
	{
		fprintf(stderr, "World EAS table corrupt.\n");
		exit(1);
	}
	
	fclose(fp);
}

static int postal_match(char *a, char *lp, char *hp)
{
	int l, h;
	int v;
	
	sscanf(lp, "%d", &l);
	sscanf(hp, "%d", &h);
	sscanf(a, "%d", &v);
	
	if(v<l)
		return -1;
	if(v>h)
		return 1;
	return 0;
}

	
float ups_world_eas_check(char *country, char *place, char *pcode, float weight)
{
	int i;
	int fleece=0;
	int w;
	
	for(i=11;i<eas_table.height;i++)
	{
		char *p;
		
		if(strcasecmp(country, CSV_ITEM(&eas_table, i,0)))
			continue;
		/*
		 *	Could be a place or postal check
		 */
		 
		p=CSV_ITEM(&eas_table,i,3);
		if(*p && strcasecmp(place, p)==0)
		{
			/* You pay a surcharge */
			fleece=1;
			break;
		}
		p=CSV_ITEM(&eas_table, i, 1);
		if(*p && postal_match(pcode, p, CSV_ITEM(&eas_table, i, 2))==0)
		{
			fleece=1;
			break;
		}
	}
	if(!fleece)
		return 0.0;
		
	weight*=0.20;	
	if(weight<20)
		return 20.0;
	w=ceil(weight*100.0);
	return w/100.0;
}
